pro fit_linear_slope, x0, y0, sigx0, sigy0, peak, error, rchisq, $
                      plot=plot, guess=guess, $
                      acceptable_range=acceptable_range, $
                      ratio_range=ratio_range, $
                      kappa_surf=kappa_surf, $
                      status=status, $
                      kappa_picture=kappa_picture, $
                      grid=grid, debug=debug, robust_cut=robust_cut, $
                      stop=stop, log_plot=log_plot, s2=s2, $
                      xrange=xrange, yrange=yrange, $
                      residual_test=residual_test, fit_indices=fit_indices, $
                      robust_status=robust_status
;
;   Make least squares fit to linear slope y vs. x
;
;

if keyword_set(ratio_range) then begin

    ratio=y0/x0
    r0=where(ratio ge ratio_range(0) and ratio le ratio_range(1),nr0)
    if nr0 eq 0 then message, 'No points found.  Error.'
    
endif else begin
    r0=lindgen(n_elements(x0))
endelse
x=x0(r0)
y=y0(r0)
sigx=sigx0(r0)
sigy=sigy0(r0)


if not keyword_set(kappa_picture) then kappa_picture=0
if keyword_set(kappa_picture) then begin
    window=!d.window
    pmulti=!p.multi
    set_page, nv=2, nh=2
endif

kappa_data=1

message, '/force_kappa_search set in gen_fit_release', /cont
gen_fit_release, x=x, y=y, sigma_x=sigx, sigma_y=sigy, guess_slope= guess, $
  rchisq=rchisq, slope=m, s2=s2, intercept=b, $
  c68=c68, ks_c99=ks_c99, errorpercent=1e-3, status=status, nparm=1, $
  kappa_picture=0, kappa_data=kappa_data, /force_kappa_search, $
  ks_range_deg=[0,89.9], /renormalize

if m lt acceptable_range(0) or m gt acceptable_range(1) then begin
    slope= y/float(x)
    r= where(  slope ge acceptable_range(0) and slope le acceptable_range(1) )
    gen_fit_release, x=x(r), y=y(r), sigma_x=sigx(r), sigma_y=sigy(r), $
      guess_slope= guess, $
      rchisq=rchisq, slope=m, s2=s2, intercept=b, $
      c68=c68, ks_c99=ks_c99, errorpercent=1e-3, status=status, nparm=1, $
      ks_range_deg=[0,89.9], /renormalize
endif

kappa_surf= kappa_data

if keyword_set(debug) then stop

if status eq 1 and keyword_set(robust_cut_0) then begin
    r=where(s2 le robust_cut, nr)
    if nr/float(n_elements(x)) lt .95 then begin
        print, 'WARNING: more than 5% of residuals outside '+$
          strtrim(robust_cut,2)+'. No outliers cut.'
        nr=n_elements(x)
        r=lindgen(nr)
    endif else begin
        gen_fit_release, x=x(r), y=y(r), sigma_x=sigx(r), sigma_y=sigy(r), $
          guess_slope= guess, $
          rchisq=rchisq, slope=m, s2=s2, intercept=b, $
          c99=c99, ks_c99=ks_c99, errorpercent=1e-3, status=status, nparm=1, $
          /force_kappa, kappa_picture=kappa_picture, /renormalize, $
          ks_range_deg=[0,89.9]
        if status ne 1 then message, 'gen_fit_release failed: error '+$
          strtrim(status,2)
     endelse
endif else begin
    nr=n_elements(x)
    r=lindgen(nr)
endelse

robust_status=128
if status eq 1 and keyword_set(robust_cut) then begin

    r=lindgen(n_elements(x))
    linear_robust_fit, rchisq, m, b, ks_c99, status, s2, r, n, $
      x, y, sigx, sigy, robust_status=robust_status


    print, n, n_elements(r), rchisq, m, status
    nr=n_elements(r)
    x=x(r)
    y=y(r)
    sigx=sigx(r)
    sigy=sigy(r)

endif else begin
    nr=n_elements(x)
    r=lindgen(nr)
endelse
fit_indices=r

if keyword_set(debug) then stop

if status ne 1 then begin
    message, 'Inserting 1 when can''t fit', /cont
    m=1.
    b=0
    c68=[1.,0.]
    ks_c99=[1.,1.]
endif

;if status ne 1 then message, 'gen_fit_release failed: error '+strtrim(status,2)

peak=m
error= max( ks_c99 )

if m gt 0.1 then begin
    slope_str=strtrim(string(peak,format='(f7.3)'),2)
    err_str=strtrim(string(error,format='(f7.3)'),2)
endif else begin
    slope_str=strtrim(string(peak,format='(f8.5)'),2)
    err_str=strtrim(string(error,format='(f8.5)'),2)
endelse
if rchisq lt 10.0 then begin
    rchi_str=strtrim(string(rchisq,format='(f5.2)'),2)
endif else begin
    rchi_str=strtrim(string(rchisq,format='(f7.1)'),2)
endelse

if keyword_set(plot) then begin
    plot_ibscatter, x, y, sigx, sigy, $
      title='Scatter of Counts', xtitle='Counts Box 1', ytitle='Counts Box 2'
    max=max([!x.crange(1),!y.crange(1)])
    oplot, [0,max], [0,max]*m, linestyle=5
    oplot, [0,max], [0,max]*(m-c68), linestyle=5
    oplot, [0,max], [0,max]*(m+c68), linestyle=5

    xyouts, 0.9*!x.crange(0)+0.1*!x.crange(1), $
      0.1*!y.crange(0)+0.9*!y.crange(1), 'Slope='+strtrim(m,2)
    xyouts, 0.9*!x.crange(0)+0.1*!x.crange(1), $
      0.2*!y.crange(0)+0.8*!y.crange(1), '68% Error='+strtrim(c68,2)
    xyouts, 0.9*!x.crange(0)+0.1*!x.crange(1), $
      0.3*!y.crange(0)+0.7*!y.crange(1), 'RChisq='+strtrim(rchisq,2)

    plot_ibscatter, x, y, sigx, sigy, /xlog, /ylog, $
      title='Scatter of Counts', xtitle='Counts Box 1', ytitle='Counts Box 2'
    min=min(10.0^([!x.crange(0),!y.crange(0)]))
    max=max(10.0^([!x.crange(1),!y.crange(1)]))
    xline=findgen(1000)
    oplot, [min,max], [min,max]*m, linestyle=5
    oplot, [min,max], [min,max]*(m-c68), linestyle=5
    oplot, [min,max], [min,max]*(m+c68), linestyle=5
endif
if keyword_set(log_plot) then begin
    plot_ibscatter, x, y, sigx, sigy, /xlog, /ylog, $
      title='Scatter of Counts', xtitle='Counts Box 1', $
      ytitle='Counts Box 2', grid=grid, xrange=xrange, yrange=yrange
    min=min(10.0^([!x.crange(0),!y.crange(0)]))
    max=max(10.0^([!x.crange(1),!y.crange(1)]))
    xline=findgen(100)/99.0*(max-min)+min
    oplot, xline, xline*peak, linestyle=5
    oplot, xline, xline*(peak-error), linestyle=5
    oplot, xline, xline*(peak+error), linestyle=5

    xyouts, 10^(0.9*!x.crange(0)+0.1*!x.crange(1)), $
      0.1*!y.crange(0)+0.9*!y.crange(1), 'Slope='+slope_str
    xyouts, 10^(0.9*!x.crange(0)+0.1*!x.crange(1)), $
      10^(0.2*!y.crange(0)+0.8*!y.crange(1)), '99% Conf.='+err_str
    xyouts, 10^(0.9*!x.crange(0)+0.1*!x.crange(1)), $
      10^(0.3*!y.crange(0)+0.7*!y.crange(1)), 'RChisq='+rchi_str
endif

end
