; Idl document to Map Domains in Fast Slow Mode Space and Shock Boundaries
noplot=1
if (noplot eq 1) then goto, jump2
set_plot,'ps'
device,/landscape
jump2: ma=fltarr(10001)
mi=fltarr(10001)
beta=.01
gamma=5/3.
q=1+gamma*beta
mistar=sqrt((q-1)/q)
mastar=sqrt(q)

ma=10^(-3+5.*findgen(10001)/10000.)*mastar*0.999999999
mi=ma
mibdy=fltarr(10000)
misq=fltarr(10000)
misq=gamma*beta/(1+gamma*beta-ma^2)
iout=where(misq ge 0)


;***************************
;SET_PS, FILE = 'idl.ps', ORIENTATION = 'LAND', SCALE = 1.0, $
;         XOFFSET = 1.0, XSIZE = 9.0, YOFFSET = 1.0, YSIZE = 6.5, $
;         INCH = 1
set_page
line_plot, x_var = ma(iout), y_var = misq(iout)^0.5, $
          xrange = [1.0e-1,1.0e2], yrange = [1.0e-1,1.0e2], $
          xlabel = '!17M!lA!n', ylabel = '!17M!lI!n', $
          title = '!17Fast-Slow-Boundaries', charsize=1.3, $
          xtype = 1, ytype = 1, aspect_ratio = 1.0, $
          xsp = 0.1, ysp = 0.1, grid = 0.05
;***************************


;plot_oo,ma(iout),misq(iout)^0.5,xrang=[1.0e-1,1.0e2],yrange=[1.0e-1,1.0e2],$
; xtitle='!17M!lA!n',ytitle='!17M!lI!n',$
; title='!17Fast-Slow-Boundaries',charsize=1.3
xyouts,10.,2.,'!7b!17 = .01', charsize=1.3
xyouts,10.,1.4,'!7c!17 = 5/3',charsize=1.3
oplot,[mastar,mastar],[1.0e-1,1.0e2],linestyle=2
oplot,[1.0e-1,1.0e2],[mistar,mistar],linestyle=2
oplot,[1.0e-1,1.],[1.,1.],linestyle=3
oplot,[1.0e-1,1.0e2],[1.0e-1,1.0e2],linestyle=5
xyouts,5.0, 1.1*mistar, '!17M!lI!n!u2!n = !7cb/(1 +cb)!17',charsize=1.3

xyouts,1.2*mastar, 0.11,'!17M!lA!n!u2!n = !71+cb!17', orientation=90$
 ,charsize=1.3
islow=where(misq le 1 and (misq gt 0))
iboundslo=where((misq le 1) and (misq gt 0) and (misq^0.5 le ma))
if(iboundslo(0) lt 0) then goto, jump1
print, iboundslo(0)
print, max(iboundslo)
for jkl=iboundslo(0),max(iboundslo),100 do begin
oplot,[ma(jkl),ma(jkl)],[ma(jkl),1],linestyle=5
endfor
jump1: b=b
itemp=iboundslo(0)
if(itemp lt 0) then itemp=max(islow)
for jkl=itemp-100,0,-100 do begin
oplot,[ma(jkl),ma(jkl)],[misq(jkl)^0.5,1],linestyle=5
endfor

ifast=where(mi ge 1)
for jkl=ifast(0),max(ifast),100 do begin
maleft=((mi(jkl)^2*q-q+1)/mi(jkl)^2)^0.5
oplot,[maleft,mi(jkl)],[mi(jkl),mi(jkl)],linestyle=3
endfor
xyouts,1.3*mastar,3.,'!17<----------Fast Shocks',charsize=1.3
ilabel=max(islow)*4/5
xyouts,ma(ilabel),0.5*(misq(ilabel)^0.5+1.),'!17<------ Slow Shocks',$
 orientation=90,charsize=1.3
ytemp=ma
ytemp2=1/ma
for jkl=5,90,20 do begin
ytemp=ma/cos(jkl/180.*3.1415926)
oplot,ma,ytemp,linestyle=2
xmin=min(abs(ytemp-ytemp2))
ioutl=where( abs(ytemp-ytemp2) eq xmin)
if (jkl eq 85 ) then $
 xyouts,ma(ioutl),ytemp(ioutl),'!7H!17!ln1!n=85!uo',orientation=45
if (jkl eq 5 ) then $
 xyouts,ma(ioutl),ytemp(ioutl),'!175!uo',orientation=45
if (jkl eq 25 ) then $
 xyouts,ma(ioutl),ytemp(ioutl),'!1725!uo',orientation=45
if (jkl eq 45 ) then $
 xyouts,ma(ioutl),ytemp(ioutl),'!1745!uo',orientation=45
if (jkl eq 65 ) then $
 xyouts,ma(ioutl),ytemp(ioutl),'!1765!uo',orientation=45
endfor
if(noplot eq 1) then goto, jump3
device,/close
spawn,'lpr idl.ps'
set_plot,'x'
jump3: d=d

end_of_prog, print = 1

end
