pro get_hydra_data, timetags, label, var, time, dt, $
                    time_start=ts, time_end=te, date=date
;
;
;  Return Hyd_Access Quantity and set the time input using 
;  Human-like time-units
;
;  Inputs:
;     label                      - Hyd_Access Label to retrieve 
;                                  (run access_tool)
;     timetags                   - Can be input if optional keywords
;                                  not used.
;
;  Optional Inputs:
;     date                       - Date YYYYMMDD.
;     time_start                 - Starting Time UT: 'HH:MM:SS'
;     time_end                   - Ending Time UT:   'HH:MM:SS'
;
;  Outputs:
;     timetags                   - For use with subsequent calls.
;     var                        - The data output
;     time                       - Center of the data time interval (ssm)
;     dt                         - Width of time-interval (seconds)
;
;  Example:
;
;     Get Density and Temperature from m3 data for [4-7:30 UT] 5/29/96:
;
;    get_hydra_data, timetags, 'm3_n', m3_density, time, dt, $
;         date=19960529, time_start='04:00', time_end='07:30'
;
;    get_hydra_data, timetags, 'm3_temp', m3_temperature
;
;
;
  if n_params() eq 0 then begin
      message, 'get_hydra_data, timetags, label, var_out, time_out, dt_out, '+$
        'date=YYYYMMDD, time_start="HH:MM:SS", time_end="HH:MM:SS"', /cont
      return
  endif


  if keyword_set(date) then begin
      t=[gen_time(strtrim(date,2)+' '+ts), gen_time(strtrim(date,2)+' '+te)]
      hyd_access, timetags, label, var, get_timetags=t
      hyd_access, timetags, 'time_bin_center_ssm', time
      hyd_access, timetags, 'time_bin_width_seconds', dt
  endif else begin
      hyd_access, timetags, label, var
  endelse

end
