function hd_block_valid, date_in, block_num_in, nblocks=nblocks
;+
;
;   Return 1 if block_num is valid for date.
;          0 if invalid
;
;
;   A valid block number is a value <= MaxRec in 'BLOCK_ID' in the ddcal.
;
;
;-
date=strtrim(date_in,2)
block_num=long(block_num_in)
label='nblocks_'+date
if cache_variable(label=label, data=nblocks, /read) ne 0 then begin
    filename=hydra_findfile(date, /ddcal, version=version)
    if filename ne '' then begin
        cdf=cdf_open(filename)
        cdf_control, cdf, variable='BLOCK_ID', get_var_info=info
        nblocks=info.maxrec
        cdf_close, cdf
    endif else begin
        message, 'DDcal file not found for '+date, /cont
        return, 0
    endelse
    if cache_variable(label=label, data=nblocks, /save) ne 0 then begin
        message, 'Unable to save nblocks for '+date, /cont
    endif
endif
return, (block_num le nblocks)
end
