pro test_hd_convol
;
;   Test code for hd_convol
;
hydra_setcolors, cs
fill=-1e31
x=findgen(100)/10.0
y=sin(x+1.0)+0.2*sin(10.*x)
y[0:3]=fill
y[25]=fill
y[40:42]=!values.f_nan
y[60:70]=fill
y[99]=fill
plot, x, y, psym=-2, min_val=-1e10, yrange=[-2,2]
r=where(hd_is_fill(y) or finite(y) eq 0,nr)
if nr gt 0 then oplot, x(r), replicate(-1.75,nr), psym=2
yy=hd_convol(y,[1,1,1,1,1],5., /edge_trunc, interp_length=3)
oplot, x, yy, psym=-1, min_val=-1e10, color=cs.green
r=where(hd_is_fill(yy) or finite(yy) eq 0,nr)
if nr gt 0 then oplot, x(r), replicate(1.75,nr), psym=1, color=cs.red
end




function hd_convol, array_in, kernel, scale_factor, $
                    no_interp=no_interp, interp_length=interp_length, $
                    _extra=e_
;+
;
;  hd_convol is a wrapper for convol that handles fill points.
;
;  The arguments are transferred to convol.
;
;  Two additional keywords are available:
;
;     /no_interp:      Forces all fill points to be treated as boundaries.
;     interp_length=n: Linearly interpolates over data gaps of length
;                      n. The default is 1.
;
;
;-
forward_function convol
array=array_in
if not keyword_set(no_interp) then begin
    if not keyword_set(interp_length) then interp_length=1

    rarray=where((not hd_is_fill(array)) and (finite(array) eq 1))
    rdiff=rarray[1:*]-rarray
    r=where((rdiff le interp_length+1) and (rdiff gt 1), nr)
    if nr gt 0 then begin
        for i=0,nr-1 do begin
            rs=rarray[r[i]]+1
            re=rarray[r[i]]+rdiff[r[i]]-1
            v=array_in[rarray]
            x=rarray
            u=rs+lindgen(re-rs+1)
            array[rs:re]=interpol(v, x, u)
        endfor
    endif
endif
;
;   Operate on array as series of separate intervals
;
n=n_elements(array)-1
nkernel=n_elements(kernel)
ra=where(hd_is_fill(array) or finite(array) eq 0)
nr=n_elements(ra)
rarray=[-1,ra,n+1]
rs=-1
for i=0,nr+1 do begin
    re=rarray[i]
    if re-rs gt nkernel+2 then begin
        if n_params() eq 2 then begin
            array[rs+1:re-1]=convol(array[rs+1:re-1],kernel,$
                                    _extra=e_)
            help, /str, e_
        endif else begin
            array[rs+1:re-1]=convol(array[rs+1:re-1],kernel,$
                                    scale_factor,_extra=e_)
        endelse
    endif
    rs=re
endfor
r=where(hd_is_fill(array_in) or finite(array_in) eq 0, nr)
if nr gt 0 then array[r]=array_in[r]
return, array
end
