pro hd_plot_doc, doc_string, charsize=charsize, spacing=spacing
;
;   Plots a String Array onto a blank plot at the next location
;
;
if not keyword_set(charsize) then charsize=1.0
if not keyword_set(spacing) then spacing=0.05
doc=[doc_string,'Plotted time: '+systime()]
n=n_elements(doc)

blank_plot

dy=0.8/float(n)
if dy gt spacing then dy=spacing
x0=0.5
y0=0.5+n/2*dy
for i=0,n-1 do begin
    xyouts, x0, y0-dy*i, alignment=0.5, doc(i), charsize=charsize
endfor

return
end
