function hd_repeated_time_match_where, a1, t2, tol, count, $
                                       init=init
;+
;   hd_repeated_time_match_where
;
;   Where Test: abs(a1-t2) lt tol
;
;   Array a1 does not change.
;   Scalar t2 marches through a1 from lo-to-high.
;   tol does not change.
;
;   Speed-Up is accomplished through applying where to only a part of a1
;   each time.
;
;   Example:
;
;   dummy=hd_repeated_time_match_where(b54_time_hr, /init)
;
;
;   ineed=hd_repeated_time_match_where(b54_time_hr, $
;                                      time_hrkp_ssm(jio)/3600., $
;                                      2.15/3600., n_ineed)
;
;
;-
common hd_repeated_time_natch_where_comm, i0, array, whole_array, na, nw


if keyword_set(init) then begin
    array=a1
    whole_array=a1
    i0=0
    na=n_elements(array)
    nw=n_elements(whole_array)
    return, 0
endif

if (array[0] ge t2-tol) and (whole_array[0] lt t2-tol) then begin
    array=whole_array
    i0=0
    na=nw
endif else $
  if (array[na-1] lt t2+tol) and (whole_array[nw-1] gt t2+tol) then begin
    array=whole_array
    i0=0
    na=nw
endif

r=where( abs(array-t2) lt tol, nr)
if nr gt 0 then begin
    dr=r[nr-1]-r[0]
    return_val=r+i0
    i0=i0+r[0]
    i1=(i0+r[nr-1]+2*dr) < (nw-1)
    array=whole_array[i0:i1]
    na=i1-i0+1
endif else begin
    return_val=-1
endelse

count=nr
return, return_val
end
