pro hyd_chunk, matrix, weight, xfactor=xfactor, zfactor=zfactor, $
               avg_method=avg_method
;
;  Chucks by weighted average to 1/2 x 1/2 size (default)
;   or by xfactor, zfactor if specified
;
rfill=-1e31

if size(matrix, /n_dimensions) ne 2 then $
  message, 'Input matrix not 2 dimensions.'
if (where(size(matrix) ne size(weight)))(0) ne -1 then begin
    if size(matrix, /type) eq size(weight, /type) then $
      message, 'Matrix and weight not of consistent dimensions.'
endif
if size(matrix, /type) lt 4 then message, 'Requires float/type arrays.'
if size(weight, /type) lt 4 then message, 'Requires float/type arrays.'

if not keyword_set(avg_method) then avg_method='A'
n=size(matrix, /dimensions)
nx=n(0)
ny=n(1)

if (not keyword_set(xfactor)) and (not keyword_set(zfactor)) then begin
    xfactor=2
    zfactor=2
endif else begin
    if (not keyword_set(xfactor)) then xfactor=1
    if (not keyword_set(zfactor)) then zfactor=1
endelse

r=where(finite(weight) eq 0 or finite(matrix) eq 0)
if r(0) ne -1 then begin
    matrix(r)=0.0
    weight(r)=0.0
endif
r=where(weight eq 0.0)
if r(0) ne -1 then begin
    case avg_method of
        'A': begin
            matrix(r)=0.0
        end
        'B': begin
            matrix(r)=-1e31
        end
        'C': begin
            matrix(r)=1e31
        end
        'D': begin
            matrix(r)=0.0
        end
    endcase
endif

if avg_method eq 'A' then begin
    w=rebin(weight, nx/xfactor, ny/zfactor)
    m=rebin(weight*matrix, nx/xfactor, ny/zfactor)
    matrix=m/w
    weight=w*xfactor*zfactor
endif else begin
    w=fltarr(nx/xfactor, ny/zfactor)
    m=fltarr(nx/xfactor, ny/zfactor)
    case avg_method of
        'B': begin
            for j=0, ny/zfactor-1 do $
              for i=0, nx/xfactor-1 do begin
                m(i,j)=max([matrix(i*xfactor:(i+1)*xfactor-1, $
                                   j*zfactor:(j+1)*zfactor-1)])
                w(i,j)=total([weight(i*xfactor:(i+1)*xfactor-1, $
                                    j*zfactor:(j+1)*zfactor-1)])
            endfor
        end
        'C': begin
            for j=0, ny/zfactor-1 do $
              for i=0, nx/xfactor-1 do begin
                m(i,j)=min([matrix(i*xfactor:(i+1)*xfactor-1, $
                                   j*zfactor:(j+1)*zfactor-1)])
                w(i,j)=total([weight(i*xfactor:(i+1)*xfactor-1, $
                                    j*zfactor:(j+1)*zfactor-1)])
            endfor
        end
        'D': begin
            for j=0, ny/zfactor-1 do $
              for i=0, nx/xfactor-1 do begin
                mm=[matrix(i*xfactor:(i+1)*xfactor-1, $
                           j*zfactor:(j+1)*zfactor-1)]
                mmax=max(abs(mm),im)
                m(i,j)=mm(im)
                w(i,j)=total([weight(i*xfactor:(i+1)*xfactor-1, $
                                    j*zfactor:(j+1)*zfactor-1)])
            endfor
        end
    endcase
    matrix=m
    weight=w
endelse

r=where(w eq 0.0)
if r(0) ne -1 then matrix(r)=rfill

return
end
