pro hyd_contour_points, z, x, y, zlevel, $
                        path_data_coords=path_data_coords, $
                        path_info=info68, path_xy=xy, $
                        stop=stop, plot=plot, $
                        border_status=border_status, $
                        boundary_range=boundary_range, $
                        _extra=stuff
;
;  Return contour points along a level (zlevel) with "boundary points"
;  excluded.  The points returned are same format as contour returns.
;  Points are returned as sets of connect-the-dots.
;
;  path_data_coords is now the default.
;
;  border_status returns 2=(-x)+4=(+x)+8=(-y)+16=(+y) to show which
;                borders must expand.
;                Requires boundary_range=[-x, -y, +x, +y]
;
;
if not keyword_set(path_info) then info68=0
if not keyword_set(path_xy) then xy=0
if n_elements(path_data_coords) eq 0 then path_data_coords=0
if not keyword_set(plot) then plot=0
fill=-1e31

if keyword_set(plot) then begin
    hydra_setcolors, cs
    contour, z, x, y, levels=[zlevel], _extra=stuff
endif
contour, z, x, y, levels=[zlevel], _extra=stuff, $
  path_data_coords=path_data_coords, path_info=info68, path_xy=xy

if not keyword_set(info68) then begin

    contour, z, x, y, levels=[0.5*(max(z,min=min)+min)], _extra=stuff, $
      path_data_coords=path_data_coords, path_info=info68, path_xy=xy

    info68=[info68[0]]
    triangulate, x, y, tri, border
    xy=transpose([[x[border]],[y[border]]])
    info68.n=n_elements(border)
    info68.value=zlevel
    return
endif

if (where(info68.high_low eq 0))[0] eq -1 then begin
    high_low=1
endif else begin
    if (where(info68.high_low eq 1))[0] eq -1 then begin
        high_low=0
    endif else begin
        message, 'WARNING: Both high and low contours found.', /cont
        high_low=2
    endelse
endelse

triangulate, x, y, tri, border
;
;   Remove edge segments from contours
;
ncont=0
cont=lonarr(2,100*n_elements(info68))
cont_high_low=lonarr(100*n_elements(info68))
for i=0,n_elements(info68.type)-1 do begin
    i0=info68(i).offset
    i1=i0+info68(i).n-1

    xx=[reform(xy[0,i0:i1]),xy[0,i0]]
    yy=[reform(xy[1,i0:i1]),xy[1,i0]]
    n=n_elements(xx)-1
    if keyword_set(plot) then oplot, xx, yy, psym=-1, color=cs.red

    rs=find_border_points(xx, yy, x(border), y(border), nrs, plot=plot)

    if nrs gt 0 then begin

        if (where(rs-lindgen(nrs) ne 0))[0] ne -1 or $
          (n_elements(xx) gt nrs) then begin

            r1=where(rs eq n_elements(xx)-1, nr1)
            r2=where(rs eq 1, nr2)
            while r1[0] eq -1 or r2[0] ne -1 do begin
                                ; Rotate by 1
                xx_tmp=xx[0:n-1]
                xx[0]=xx_tmp[n-1]
                xx[1:n-1]=xx_tmp[0:n-2]
                xx[n]=xx[0]

                yy_tmp=yy[0:n-1]
                yy[0]=yy_tmp[n-1]
                yy[1:n-1]=yy_tmp[0:n-2]
                yy[n]=yy[0]

                rs=find_border_points(xx, yy, x(border), y(border), nrs)
                r1=where(rs eq n_elements(xx)-1, nr1)
                r2=where(rs eq 1, nr2)
            endwhile

            r1=where(rs[1:*]-rs ne 1)
            if r1[0] ne -1 then begin
                rs_end=[rs[r1],rs[n_elements(rs)-1]]
            endif else begin
                rs_end=[rs[n_elements(rs)-1]]
            endelse
            if r1[0] ne -1 then begin
                rs_start=[rs[0],rs[r1+1]]
            endif else begin
                rs_start=[rs[0]]
            endelse
            

            cont[0,ncont]=i0
            cont_high_low[ncont]=info68[i].high_low
            for irs=0,n_elements(rs_start)-1 do begin
                if rs_end[irs]-rs_start[irs] gt 0 then begin
                    if (rs_start[irs] ne 0) and $
                      (rs_end[irs] ne n_elements(xx)-1) then begin
                        cont[1,ncont]=i0+rs_start[irs]
                        ncont=ncont+1
                        cont[0,ncont]=i0+rs_end[irs]
                        cont_high_low[ncont]=info68[i].high_low
                    endif
                endif
                
                if rs_end[irs]-rs_start[irs] gt 1 then begin
                    xx[rs_start[irs]+1:rs_end[irs]-1]=-1e31
                    yy[rs_start[irs]+1:rs_end[irs]-1]=-1e31
                    cont_high_low[ncont]=1-info68[i].high_low
                endif
            endfor
            xy[0,i0:i1]=xx[0:info68[i].n-1]
            xy[1,i0:i1]=yy[0:info68[i].n-1]
            ir=info68[i].n-1
            while xx(ir) lt -1e30 do ir=ir-1
            info68[i].n=ir+1
            cont[1,ncont]=i0+ir
            if ir lt n_elements(xx)-1 then begin
                cont_high_low[ncont]=1-info68[i].high_low
            endif
            ncont=ncont+1
            
        endif else begin
            xx[*]=-1e31
            yy[*]=-1e31
        endelse
    endif else begin
        cont[0,ncont]=i0
        cont_high_low[ncont]=info68[i].high_low
        cont[1,ncont]=i0+info68[i].n-1
        ncont=ncont+1
    endelse
    if keyword_set(plot) then begin
        r=where(xx gt -1e30, nr)
        if nr gt 0 then oplot, xx(r), yy(r), psym=-2, color=cs.green
    endif
    if keyword_set(stop) then stop

endfor
if keyword_set(stop) then stop

if ncont gt 0 then begin
                                ;
                                ;  Redo info68 if necessary 
                                ;
    if ncont ne n_elements(info68) then begin
        info68_1=replicate(info68[0],ncont)
        for i=0,ncont-1 do begin
            info68_1[i].offset=cont[0,i]
            info68_1[i].n=cont[1,i]-cont[0,i]+1
            info68_1[i].high_low=cont_high_low[i]
            
            if keyword_set(plot) then begin
                i0=info68_1(i).offset
                i1=i0+info68_1(i).n-1
                
                xx=[reform(xy[0,i0:i1]),xy[0,i0]]
                yy=[reform(xy[1,i0:i1]),xy[1,i0]]
                oplot, xx, yy, psym=-1, color=cs.cyan, thick=2
            endif
        endfor
        if keyword_set(stop) then stop
        info68=info68_1
    endif else begin
        info68[*].high_low=cont_high_low[0:ncont-1]
    endelse
endif
;
;    Examine remaining border points and determine which border is used.
;
if keyword_set(boundary_range) then begin
    br=boundary_range
    if not keyword_set(border_status) then border_status=0
    for i=0,n_elements(info68.type)-1 do begin
        i0=info68(i).offset
        i1=i0+info68(i).n-1
        
        xx=[reform(xy[0,i0:i1]),xy[0,i0]]
        yy=[reform(xy[1,i0:i1]),xy[1,i0]]
        n=n_elements(xx)-1
        if keyword_set(plot) then oplot, xx, yy, psym=-1, color=cs.red
        
        rs=find_border_points(xx, yy, x(border), y(border), nrs, $
                              plot=plot)
        
        if nrs gt 0 then begin
            for irs=0,nrs-1 do begin
                border_status=border_status or  2*(xx[rs[irs]] le br[0])
                border_status=border_status or  4*(xx[rs[irs]] ge br[2])
                border_status=border_status or  8*(yy[rs[irs]] le br[1])
                border_status=border_status or 16*(yy[rs[irs]] ge br[3])
            endfor
        endif
    endfor
endif


end

