pro hyd_error_bars, x,y, dx,dy, overplot=overplot, color=color, $
                    xmin=xmin, ymin=ymin, $
                    psym=psym, xlog=xlog, ylog=ylog, _extra=_e
;+
;  Plot x-y data with non-symmetric error bars
;
;  x,y are the data-pts length [*]
;  dx, dy are the error bar lengths [*] or [*,2] to include lower,upper
;
;  color=color sets the color.  - The calling code must define the
;                                 color using hydra_setcolors.
;  xmin=xmin, ymin=ymin set the min values for the error-bars
;                       1e-9 is the default for log-plots
;
;  /overplot indicates to plot on existing plot.
;
;  if overplot is not set, then
;
;  psym=psym defines the symbol to be used.
;  /xlog, /ylog determine the plot.
;
;-

if not keyword_set(psym) then psym=4
if not keyword_set(color) then color=!p.color
if not keyword_set(xmin) then begin
    if not keyword_set(overplot) then begin
        if keyword_set(xlog) then xmin=1e-9 else xmin=-1e31
    endif else begin
        if keyword_set(!x.type) then xmin=1e-9 else xmin=-1e31
    endelse
endif
if not keyword_set(ymin) then begin
    if not keyword_set(overplot) then begin
        if keyword_set(ylog) then ymin=1e-9 else ymin=-1e31
    endif else begin
        if keyword_set(!y.type) then ymin=1e-9 else ymin=-1e31
    endelse
endif
npts=n_elements(X)
if not keyword_set(overplot) then begin
    plot, x, y, /NODATA, xlog=xlog, ylog=ylog, psym=psym, _extra=_e
endif else begin
    oplot, x, y, psym=psym, _extra=_e
endelse

if size(dx,/n_dimensions) eq 1 then begin
    xlower=x-dx
    xupper=x+dx
endif else begin
    xlower=x-dx[*,0]
    xupper=x+dx[*,1]
endelse
if size(dy,/n_dimensions) eq 1 then begin
    ylower=y-dy
    yupper=y+dy
endif else begin
    ylower=y-dy[*,0]
    yupper=y+dy[*,1]
endelse


for i=0L,n_elements(x)-1 do begin
    oplot, [xlower[i],xupper[i]], replicate(y[i],2), color=color
    oplot, replicate(x[i],2), [ylower[i],yupper[i]], color=color
endfor
end
