FUNCTION hyd_expand_array, array, new_dims_input
;+
; NAME:
;      HYD_EXPAND_ARRAY
;
; PURPOSE:
;      Expand an array by a set amount for use reading input files of unknown
;      size.
;
; CATEGORY:
;      Utility
;
; CALLING SEQUENCE:
;      array = HYD_EXPAND_ARRAY(array, [new_dimensions])
;
; INPUTS:
;      new_dims_input: An array containing the new dimensions
;
; OPTIONAL INPUTS:
;      None.
;
; KEYWORD PARAMETERS:
;      None.
;
; OUTPUTS:
;      Result is the array expanded to new size with data preserved.
;
; OPTIONAL OUTPUTS:
;      None.
;
; COMMON BLOCKS:
;      None.
;
; SIDE EFFECTS:
;      None.
;
; RESTRICTIONS:
;      Tested for 1D and 2D arrays only.
;
; PROCEDURE:
;      Determine size/type of input array, create new array, copy
;      existing data to new array.
;
; EXAMPLE:
;      a=replicate(1,10)
;      a=hyd_expand_array(a,[100])
;      print, a(0:20)
;
; MODIFICATION HISTORY:
;      $Log: hyd_expand_array.pro,v $
;      Revision 1.2  2000/03/14 20:21:31  rdh
;      Fixed for 2D arrays.
;
;      Revision 1.1  1998/11/17 21:08:24  rdh
;      Initial revision
;
;-

s = size(array)
new_dims = new_dims_input
sd = size(new_dims)
IF (sd(0) EQ 0) THEN new_dims = [new_dims]
IF (s(0) NE n_elements(new_dims)) THEN BEGIN 
                                ;  Check that the number of dimensions not
                                ;  change
   print, 'Error in dimensions.'
   stop
endif
;
;     Make Array from size array information
;
s_new = s
n=1
no=1
FOR i=1,s(0) DO BEGIN
   s_new(i) = new_dims(i-1)
   n = n*new_dims(i-1)
   no=no*s(i)
ENDFOR
no=no/s(1)
s_new(n_elements(s_new)-1) = n
temp = make_array(size=s_new)
;
;  Fill new array with old information
;
FOR i=0,no-1 DO BEGIN
    temp(0:s(1)-1,i)=array(*,i)
ENDFOR

return, temp
END
