function hyd_factorial, x, ln=ln
;+
;   hyd_factorial - Vector factorial w/sterling's formula
;
;   keyword(ln) returns the natural log.
;
;-
y=make_array(dimension=size(x,/dimen), value=0.0)
for i=0L,n_elements(x)-1 do begin
    if x[i] le 26 then begin
        y[i]=factorial(x[i])
        if keyword_set(ln) then y[i]=alog(y[i])
    endif else begin
        if not keyword_set(ln) then begin
            y[i]=factorial(x[i], /stirling)
        endif else begin
              y[i]=0.5*alog(2*!pi*x[i])+x[i]*alog(x[i])-x[i]
        endelse
    endelse
endfor

return, y
end
