function hyd_fill_out_points, timetags_in, v_in, interval, trange=trange
;
;   Add Fill data to form a contiguous set of HYD_ACCESS  timetags/quantities
;
;
;   Return filled-out v.
;
;   Input:
;
;           timetags:   hyd_access timetags
;           v:          quantity to be filled (should be 1D array or
;                                               array of structures)
;           interval;   scalar - repetition rate for timetags 
;                                               (from hyd_access)
;
;   Keyword Input:
;
;           trange:     Set the range (ssm) if beyond the timetag inputs.
;
rfill=-1e31
timetags=timetags_in
v=v_in
fp=hd_get_footprints()
hyd_data, timetags, 'time_bin_start_ssm', tstart
hyd_data, timetags, 'time_bin_width_seconds', twidth
hd_add_footprint, fp
nt=n_elements(tstart)
if interval ne rfill then begin

    np0=long((tstart(1:*)-(tstart+interval))/interval+0.5)
    rp=where(np0 gt 0, nrp)
    if not keyword_set(trange) then begin
        trange=[tstart(0),tstart(nt-1)+interval]
    endif
;
;   Assume decimal days since 1/1/1996, fraction = ssm/86400
;
    if (nrp eq 0) and (tstart(0) le trange(0)) and $
      (tstart(nt-1)+interval ge trange(1)) then return, v
    if rp(0) ne -1 then np=np0(rp)
    message, 'Missing data in interval: adding points...', /cont

    dt=interval/86400.d0
    if nrp gt 0 then begin
        if (size(v, /type) ne 8) then begin
            vv=[v(0:rp(0))]
            vv=[vv,replicate(rfill,np(0))]
            for i=1L,nrp-1 do $
              vv=[vv,v(rp(i-1)+1:rp(i)),replicate(rfill,np(i))]
            if (rp(nrp-1) ne nt-1) then vv=[vv,v(rp(nrp-1)+1:*)]
        endif else begin        ; timetag array of structures
            ttag=v(0:np(0)-1)
            ttag(*).bin_start=v(rp(0)).bin_start+(lindgen(np(0))+1)*dt
            vv=[v(0:rp(0))]
            vv=[vv,ttag]
            for i=1L,nrp-1 do begin
                ttag=v(0:np(i)-1)
                ttag(*).bin_start=v(rp(i)).bin_start+(lindgen(np(i))+1)*dt
                vv=[vv,v(rp(i-1)+1:rp(i)),ttag]
            endfor
            vv=[vv,v(rp(nrp-1)+1:*)]
        endelse
    endif else begin
        vv=v
    endelse
endif else begin
    vv=v
endelse

if (tstart(0) gt trange(0)) then begin
    v=vv
    if interval eq rfill then begin
        it=1
        dt=(tstart(0)-trange(0))/86400.d0
    endif else begin
        it=long((tstart(0)-trange(0))/interval)+1
        dt=interval/86400.d0
    endelse    
    if (size(v, /type) ne 8) then begin
        vv=[replicate(rfill,it),v]
    endif else begin            ; timetag array of structures
        nv=n_elements(v)
        if (it ge nv) then $
          message, 'Not coded for it > nv.'
        ttag=v(0:it-1)
        ttag(*).bin_start=v(0).bin_start-reverse(lindgen(it)+1)*dt
        if (interval eq rfill) then begin
            ttag(*).bin_width=dt
        endif
        vv=[ttag,v]
    endelse
endif

nv=n_elements(v)
if (trange(1) gt tstart(nt-1)+twidth(nt-1)) then begin
    if interval eq rfill then begin
        it=1
        dt=(trange(1)-tstart(nt-1)+twidth(nt-1))/86400.d0
    endif else begin
        it=long((trange(1)-(tstart(nt-1)+interval))/interval)+1
        dt=interval/86400.d0
    endelse
    v=vv
    nv=n_elements(v)
    
    if (size(v, /type) ne 8) then begin
        vv=[v,replicate(rfill,it)]
    endif else begin            ; timetag array of structures
        if (it ge nv) then $
          message, 'Not coded for it > nv.'
        ttag=v(nv-it:nv-1)
;        ttag(*).bin_start=v(nv-1).bin_start+v(nv-1).bin_width+(lindgen(it))*dt
        ttag(*).bin_start=v(nv-1).bin_start+(1+lindgen(it))*dt
        if (interval eq rfill) then begin
            ttag(*).bin_width=dt
        endif
        vv=[v,ttag]
    endelse
endif

return, vv
end
