pro hyd_get_nif_coords, timetags_in, xnif_start, xnif_end, $
                        znif_start, znif_end, $
                        footprint=footprint_nif
;
;    Get NIF coordinates at tstart tend
;

;
;    Request 10 extra ttags to eliminate the fill values from hyd_access
;
n=(size(timetags_in,/dimension))(0)
hyd_data, timetags_in(0:1), 'time_bin_start_ssm', tstart_in
dt0=tstart_in(1)-tstart_in(0)
na=long(20.0/dt0) > 1
if (na gt n) then message, 'Timetags error: Check bin_start for indexes 0:1.'
dt=timetags_in(n-1).bin_start-timetags_in(n-2).bin_start
timetags_extra=timetags_in(n-na:n-1)
timetags_extra(*).bin_start=timetags_in(n-1).bin_start+dt*(indgen(na)+1)

timetags_pre=timetags_in(0:na-1)
dt=timetags_in(1).bin_start-timetags_in(0).bin_start
timetags_pre(*).bin_start=timetags_in(0).bin_start-dt*(indgen(na)+1)

timetags=[timetags_pre,timetags_in,timetags_extra]
ttags=[timetags,timetags]
nt=n_elements(timetags(*).bin_start)
ttags1=timetags
ttags2=timetags
ttags2(*).bin_start=ttags2(*).bin_start+ttags2(*).bin_width
ttags1(*).bin_width=0
ttags2(*).bin_width=0

hyd_access, ttags1, 'nif_traj', nif_traj_start, /synchronize_interpolate, $
  footprint=footprint_nif
hyd_access, ttags2, 'nif_traj', nif_traj_end, /synchronize_interpolate
;
;   Take only the ones we want
;
r=where(timetags_in.bin_start eq timetags(na:*).bin_start,nr)
if (nr ne n) then message, 'ERROR: timetag-alignment failed.'
;
;   Convert nif from RE to inertial Length: 42km
;
xnif_start=hd_svmult(6378/42.0,nif_traj_start(r+na,0))
xnif_end=hd_svmult(6378/42.0,nif_traj_end(r+na,0))

znif_start=hd_svmult(6378/42.0,nif_traj_start(r+na,2))
znif_end=hd_svmult(6378/42.0,nif_traj_end(r+na,2))

return
end
