pro hyd_get_separator_coords, timex, xs, timez, zs, $
                              generator=generator, $
                              mfe_8hz=mfe_8hz, angle_filter=angle_filter
;
;    Get Separator Coordinates from idlsav
;
;
;
;    Notes:  xxc gives Separator position in NIF (RE Units)
;            jds gives Separator position wrt Polar (Di units)
;
;
if not keyword_set(generator) then generator='xxc' else $
  if generator ne 'jds' then message, 'Must choose generator=jds or xxc.'

check=0
check1=0

if generator eq 'jds' then begin
;    adjust_time=1               ; TTAG Adjustment
;    separator_filename=$
;      '/opt/hydra/scratch0/holdaway/separator/'+$
;    'jacks_mapping_4_6b_2000_subset.idlsav'
;
;    separator_filename=$
;      '/opt/hydra/scratch0/holdaway/separator/'+$
;      'jacks_mapping_7_06_2000.idlsav'

    dir='/opt/hydra/tmp_data/other_data_sets/'

    separator_filename=dir+'jacks_mapping_10_22_2001.idlsav'

    if keyword_set(mfe_8hz) then begin
        message, 'Not supported 10/22/01.'
;        separator_filename=dir+'jacks_mapping_5_23_2001.idlsav'
    endif else begin
        if keyword_set(angle_filter) then begin
            message, 'Not supported 10/22/01.'
;            separator_filename=dir+'jacks_mapping_5_23_2001_AF.idlsav'
        endif else begin
;            separator_filename=dir+'jacks_mapping_4_05_2001.idlsav'
        endelse
    endelse
endif else begin
    separator_filename='/opt/hydra/scratch0/holdaway/separator/'+ $
      'nif_separator_pos_031400_3a.idlsav'
endelse
restore, separator_filename, /verbose

hd_add_footprint, 'IDLSAV Separator File:'+separator_filename
;
;   Convert to inertial scalelength units
;  
if generator eq 'xxc' then begin ; Convert to Di Units
    xs=x_sept_nif*6378.0/42.
    zs=z_sept_nif*6378.0/42.
endif else begin
    xs=x_nif
    zs=z_nif

    if keyword_set(adjust_time) then begin
        time_x_out=time_x_out-0.5/54.+9.2/1024
    endif
    timex=time_x_out
    timez=time_x_out
endelse

if keyword_set(check1) then begin
    timex_jds=timex
    timez_jds=timez
    set_ps, /landscape
    set_page, nv=2, nh=2
    plot, timex, xs, psym=3, xtickformat='tick_hms', xticks=2, title='x jds'
    plot, timez, zs, psym=3, xtickformat='tick_hms', xticks=2, title='z jds'

    separator_filename='/opt/hydra/scratch0/holdaway/separator/'+ $
      'nif_separator_pos_031400_3a.idlsav'
    restore, separator_filename, /verbose
    xs=x_sept_nif*6378.0/42.
    zs=z_sept_nif*6378.0/42.
    plot, timex, xs, psym=3, xtickformat='tick_hms', xticks=2, title='x xxc'
    plot, timez, zs, psym=3, xtickformat='tick_hms', xticks=2, title='x xxc'
    end_of_prog, /delete, /print
    stop
endif

if keyword_set(check) then begin
    set_page, nv=2, nh=2

    plot, xs, zs, psym=1
    plot, xs, zs, psym=1, xrange=[-100,100], yrange=[-100,100]

    plot, xs, zs, psym=1, xrange=[-5,5], yrange=[-5,5]
    plot, xs, zs, psym=1, xrange=[-1,1], yrange=[-1,1]

    stop
endif
return
end
