pro hyd_merge, matrix1, weight1, matrix2, weight2, avg_method=avg_method, $
               var1=var1, var2=var2
;
;  Merges two matrices, weights using avg_methods.
;  Variances will be supported in the future.
;
;  Avg Methods:
;         A: Weighted Average
;         B: Max
;         C: Min
;         D: |Max|
;
if not keyword_set(avg_method) then avg_method='A'
rfill=-1e31
matrix=make_array(value=rfill,size=size(matrix1))
weight=make_array(value=0.0,size=size(matrix1))
variance=make_array(value=rfill,size=size(matrix1))
r=where(matrix1 ne rfill and matrix2 ne rfill,nr)     ;    Both non-fill
r1=where(matrix1 ne rfill and matrix2 eq rfill,nr1)   ;    #2 is fill
matrix(r1)=matrix1(r1)
r2=where(matrix1 eq rfill and matrix2 ne rfill,nr2)   ;    #1 is fill
matrix(r2)=matrix2(r2)
if avg_method eq 'A' then begin
    weight(r)=weight1(r)+weight2(r)
    matrix(r)=(matrix1(r)*weight1(r)+matrix2(r)*weight2(r))/weight(r)
    weight(r1)=weight1(r1)
    weight(r2)=weight2(r2)
    if keyword_set(var1) and keyword_set(var2) then begin
        variance(r)=$
          sqrt($
                (var1(r)^2*weight1(r)+var2(r)^2*weight2(r))/weight(r)-$
                matrix(r)^2+$
                (matrix1(r)^2*weight1(r)+matrix2(r)^2*weight2(r))/weight(r)$
              )
        variance(r1)=var1(r1)
        variance(r2)=var2(r2)
    endif
endif else begin
    case avg_method of
        'B': begin
            for i=0,nr-1 do matrix(r(i))=max([matrix1(r(i)), matrix2(r(i))])
        end
        'C': begin
            for i=0,nr-1 do matrix(r(i))=min([matrix1(r(i)), matrix2(r(i))])
        end
        'D': begin
            for i=0,nr-1 do begin
                m=[matrix1(r(i)), matrix2(r(i))]
                max=max(abs([matrix1(r(i)), matrix2(r(i))]),ind)
                matrix(r(i))=m(ind)
            endfor
        end
        else: begin
            message, 'Avg_Method '+strtrim(avg_method,2)+' not defined.'
        end
    endcase
endelse
weight1=weight
matrix1=matrix

if keyword_set(var1) and keyword_set(var2) then begin
    var1=variance
endif else begin
    var1=make_array(value=rfill,size=size(variance))
endelse

return
end
