pro hyd_plot_average_single_segment, x, y, t, $
                                     nx, ny, $
                                     xrange=xrange, yrange=yrange, $
                                     xi, yi, wi, $
                                     verbose=verbose
;+
; NAME:
;            hyd_plot_average_single_segment
;
;
; PURPOSE:
;            Return indexes and weights
;
;
; CATEGORY:
;            Plot routine
;
;
; CALLING SEQUENCE:
;            hyd_plot_average_single_segment, x, y, t
;
; 
; INPUTS:
;            x, y:   Coordinates in space to be plotted.
;            t:      Times associated with x, y.
;
;            nx, ny: dimensions of matrix to be used.
;
; OPTIONAL INPUTS:
;
;
;	
; KEYWORD PARAMETERS:
;            xrange, yrange =[low,high] values for matrix.
;            /verbose: Extra debugging information
;
; OUTPUTS:
;            xi, yi, wi: indexes and weights for matrix elements
;
;
; OPTIONAL OUTPUTS:
;            None.
;
;
; COMMON BLOCKS:
;            None.
;
;
; SIDE EFFECTS:
;            None.
;
;
; RESTRICTIONS:
;            None.
;
;
; PROCEDURE:
;
;
;
; EXAMPLE:
;
;
;
; MODIFICATION HISTORY:
;            Startted: RDH 2/21/00 
;-
plot=0

nt=n_elements(t)
dx=(xrange(1)-xrange(0))/float(nx)
dy=(yrange(1)-yrange(0))/float(ny)
xn=(x-xrange(0))/dx
yn=(y-yrange(0))/dy


dt=t(nt-1)-t(0)
if (dt lt 0.019) then begin
    xi=[xn(nt/2)]
    yi=[yn(nt/2)]
    wi=[dt]
    return
endif
xi=[0]
yi=[0]
wi=[0.0]
;
;  Loop over individual segments to be plotted
;
if keyword_set(verbose) then begin
    openw, 1, 'verbose_output'
endif
for i=1L, nt-1 do begin
    dt=t(i)-t(i-1)
    xmin=min([xn(i-1),xn(i)],max=xmax)
    ymin=min([yn(i-1),yn(i)],max=ymax)

    nix=long(xmax)-long(xmin)
    if nix gt 0 then $
      ix=[xmin,indgen(nix)+long(xmin)+1,xmax] $
    else $
      ix=[xn(i-1),xn(i)]
    if xn(i-1) gt xn(i) then ix=reverse(ix)
    yix=interpol(yn(i-1:i),xn(i-1:i),ix)

    niy=long(ymax)-long(ymin)
    if niy gt 0 then $
      iy=[ymin,indgen(niy)+long(ymin)+1,ymax] $
    else $
      iy=[yn(i-1),yn(i)]
    if yn(i-1) gt yn(i) then iy=reverse(iy)
    xiy=interpol(xn(i-1:i),yn(i-1:i),iy)
    
    xx=[ix,xiy]
    yy=[yix,iy]
    s=sort(xx)
    xx=xx(s)
    yy=yy(s)
    n=n_elements(xx)
    
    length=[sqrt((xx(1:n-1)-xx(0:n-2))^2+(yy(1:n-1)-yy(0:n-2))^2),0]+1e-10
    ta=dt/total(length, /double)
    wa=length*ta
    xa=long(xx)
    ya=long(yy)
    r=where(wa gt 0)
    if r(0) ne -1 then begin
        xi=[xi,xa(r)]
        yi=[yi,ya(r)]
        wi=[wi,wa(r)]
        if keyword_set(verbose) then begin
            printf, 1, 'X: ', xn(i-1), xn(i)
            printf, 1, 'Y: ', yn(i-1), yn(i)
            
            for j=0L, n_elements(xx)-1 do $
              printf, 1, xx(j), yy(j), xa(j), ya(j), wa(j)
            printf, 1, total(wa, /double)
            
            if keyword_set(plot) then begin
                set_page, nv=2
                plot, [xn(i-1),xn(i)], [yn(i-1),yn(i)], /ynoz
                oplot, ix, yix, psym=1
                oplot, xiy, iy, psym=4
                plot, [xn(i-1),xn(i)], [yn(i-1),yn(i)], /ynoz
                for j=0L, n_elements(xx)-1 do $
                  oplot, [xa(j), xa(j),   xa(j)+1, xa(j)+1, xa(j)], $
                  [     ya(j), ya(j)+1, ya(j)+1, ya(j),   ya(j)]
            endif
        endif
    endif else begin
        message, 'Zero-weight smear not tested.'
    endelse
endfor
nxi=n_elements(xi)
if nxi gt 1 then begin
    xi=xi(1:nxi-1)
    yi=yi(1:nxi-1)
    wi=wi(1:nxi-1)
endif else begin
    xi=[0]
    yi=[0]
    wi=[0.0]
endelse

if keyword_set(collapse_points) then begin
    collapse_points, xi, yi, wi

    xxi=xi+yi*10000
    nxi=n_elements(xi)
    nxxi=n_elements(uniq(xxi(sort(xxi))))
    print, nt, nxi, nxxi

    set_page, nv=1,nh=1
    plot, xn, yn, /nodata, /ynozero, $
      xrange=[min(xn)-5,max(xn)+5], yrange=[min(yn)-5,max(yn)+5]
    for i=1L,nt-1 do begin
        oplot, [xn(i-1),xn(i)], [yn(i-1),yn(i)]
    endfor
    plot_boxes, xi,yi

    if nxi ne nxxi then stop
endif

if keyword_set(verbose) then begin
        close, 1
endif

return
end

