function hyd_poisson, x, mu_in, ln=ln, test=test
;+
;
;  Return the poisson probability at x from mean mu
;
;-
mu=mu_in
if not keyword_set(ln) then ln=0
n=n_elements(x)
if n gt 1 then begin
    p=make_array(size=size(float(x)), value=-1e31)
    for i=0L, n_elements(x)-1 do p[i]=hyd_poisson(x[i],mu,ln=ln)
    return, p
endif
if mu eq 0 and x eq 0 then mu=1e-10    

if x[0] gt 26 then begin
    lnp=(x[0]*alog(mu/x[0])+x-mu)-0.5*alog(!pi*x[0])
;    p=(mu/x[0])^x[0] * exp(x[0]-mu)/sqrt(2*!pi*x[0])
endif else begin
    lnp=x[0]*alog(mu)-mu-alog(factorial(x[0]))
;    p=mu^x[0] * exp(-mu) / factorial(x[0])
endelse
if keyword_set(ln) then p=lnp else p=exp(lnp)
if keyword_set(test) then begin
    print, (x[0]*alog(mu/x[0])+x-mu)-0.5*alog(!pi*x[0]), $
      x[0]*alog(mu)-mu-alog(factorial(x[0]))
endif



return, p
end

