function hyd_poisson_prob, c1, c2, mu1, mu2
;+
;
;   Calculate the confidence level at which (c1,c2) agree with
;   Poisson distribution centered at mu1, mu2.
;
;-
n1=long(2*mu1+5 > mu1+c1)
n2=long(2*mu2+5 > mu2+c2)
x=indgen(n1)
y=indgen(n2)
cx=hyd_poisson(x,mu1)
cy=hyd_poisson(y,mu2)
cxy=cx#cy
rx=abs(x#replicate(1,n2)-c1)
ry=abs(replicate(1,n1)#y-c2)
r=where(rx^2+ry^2 le (c1-mu1)^2+(c2-mu2)^2, nr)
if nr gt 0 then begin
    prob=total(cxy[r])
endif else begin
    prob=cxy[c1,c2]
endelse
return, prob
end


