function hyd_robust_fitter, c1, c2, $
                            fitter=fitter, iterations=iterations, $
                            redchisq=redchisq, sfunction=sfunction, $
                            filter=filter, $
                            stop=stop, _extra=e
;+
;
; hyd_robust_fitter
;
; fitter='hyd_poisson_slope', iterations=#
;
; Cuts out 10% of the data at a time for up to # iterations, or 'no change'.
;
;-
if not keyword_set(iterations) then iterations=10
if fitter eq 'hyd_poisson_slope' then begin
    iter=0
    slope=hyd_poisson_slope(c1, c2, $
                            redchisq=redchisq, $
                            sfunction=sfunction, $
                            _extra=e)
    while iter lt iterations do begin
        iter=iter+1
        
        asf=abs(sfunction)
        histogram_rdh, asf, xt, yt, binsize=1.0
        n=total(yt)
        nyt=n_elements(yt)
        i=nyt-1
        ni=yt[i]
        while ni lt 0.1*iter*n do begin
            i=i-1
            ni=ni+yt[i]
        endwhile

        r=where(asf lt xt[i])
        new_slope=hyd_poisson_slope(c1[r], c2[r], $
                                    redchisq=redchisq, $
                                    sfunction=sfunction, $
                                    _extra=e)
        dummy_slope=hyd_poisson_slope(c1, c2, $
                                      redchisq=dummy_redchisq, $
                                      sfunction=sfunction, $
                                      straw_slope=new_slope, $
                                      _extra=e)
        if abs(slope-new_slope)/slope lt 0.01 then iter=iterations

    endwhile

    asf=abs(sfunction)
    histogram_rdh, asf, xt, yt, binsize=1.0
    n=total(yt)
    nyt=n_elements(yt)
    i=nyt-1
    ni=yt[i]
    while ni lt 0.1*iter*n do begin
        i=i-1
        ni=ni+yt[i]
    endwhile
    
    r=where(asf lt xt[i])
    slope=hyd_poisson_slope(c1[r], c2[r], $
                            redchisq=redchisq, $
                            sfunction=sfunction, $
                            _extra=e)

    filter=r
endif else begin
    print, 'hyd_robust_fitter not coded for '+fitter+'.'
    return ,-1e31
endelse

return, slope
end

