function hyd_set_range, v, normal=normal
;
;   Set Range based on quantity v
;
;   /normal: Use Mean +/- 3 s.d.
;
;   otherwise use range of the data + 10 %.
;
;
@hd_include
r=where(v ne hd_fill)

n=n_elements(v(r))
min=min(v(r),max=max)
range=max-min
if min-0.1*range gt 0 or min lt 0 then min=min-0.01*range
if max+0.1*range lt 0 or max gt 0 then max=max+0.01*range
if keyword_set(normal) then begin
    vbar=total(v(r),/double)/float(n)
    sd=sqrt(total((v(r)-vbar)^2, /double)/(n-1))
    
    zr=[vbar-2*sd > min,vbar+2*sd < max]
    r=where(v(r) gt zr(1) or v(r) lt zr(0),nr)
    if (float(nr)/n lt 0.05) then begin
        zr=[vbar-1*sd > min,vbar+1*sd < max]
        rr=where(v(r) gt zr(1) or v(r) lt zr(0),nr)
    endif
endif else begin
    zr=[min,max]

endelse

return, zr
end
