pro hydra_colorpolar, radius, angle, value, $
                      vrange=vrange, _extra=e
;
;   Plot a color polar plot using plot, /polar to set axes, and 
;   convert_coord to map the polar image to pixels.
;
nbins=100
rrange=[0,max(radius)]
arange=[min(angles,max=max),max]
limits=[rrange(0), arange(0), rrange(1), arange(1)]

rval=findgen(nbins)/nbins * (rrange(1)-rrange(0)) + rrange(0)
aval=findgen(nbins)/nbins * (arange(1)-arange(0)) + arange(0)

triangulate, radius, angle, triangles
vval = trigrid(radius, angle, value, triangles,limits)

zval = congrid(vval, nbins, nbins, /interp)





;
;  Set Up Axes and establish coordinates
;
plot, radius, angle, _extra=e, /polar
;
;  Convert Corners to device coordinates
;
xy=convert_coord(!x.crange,!y.crange, /data, /to_device)

nxy=[xy(0,1)-xy(0,0),xy(1,1)-xy(1,0)]

if not keyword_set(vrange) then vrange=[min(value,max=max),max)]
ncolors=256
dv=(vrange(1)*1.001-vrange(0))/float(ncolors)

value_array=fltarr(nxy(0),nxy(1))

color_array=bytarr(nxy(0),nxy(1))
index_array=fltarr(2,nxy(0),nxy(1))
index_array(0,*,*)=findgen(nxy(0))#replicate(1.0,nxy(1))+xy(0,0)
index_array(1,*,*)=replicate(1.0,nxy(0))#findgen(nxy(1))+xy(0,0)

index_array=convert_coord(index_array, /device, /to_data)
value_array=

return
end
