PRO hydra_data_avail, date, output, out, $
                             level1=level1, survey=survey, verbose=verbose


   date = strtrim(date,2)

   IF keyword_set(verbose) THEN silent = 0 ELSE silent = 1

   IF keyword_set(level1) THEN BEGIN 
      fn = hydra_findfile(date, /level1, silent=silent)
      IF (fn NE '') THEN BEGIN 
         IF keyword_set(verbose) THEN print, 'L1 file =',fn
         fn = str_sep(fn, '/')
         nf = n_elements(fn)
         file = fn(nf-1)
         v = str_sep(file,'.cdf')
         nv = n_elements(v)
         vers = v(0)
         nv = strlen(vers)
         p = rstrpos(vers,'_v')
         np = nv-p-2
         dd_version = float(strmid(vers,p+2,np))
         
         fn = hydra_findfile(date, /ddcal, silent=silent)
         IF (fn NE '') THEN BEGIN 
            IF keyword_set(verbose) THEN print, 'L1 CAL file =',fn
            fn = str_sep(fn, '/')
            nf = n_elements(fn)
            file = fn(nf-1)
            v = str_sep(file,'.cdf')
            nv = n_elements(v)
            vers = v(0)
            nv = strlen(vers)
            p = rstrpos(vers,'_v')
            np = nv-p-2
            ddcal_version = float(strmid(vers,p+2,np))

            version = ddcal_version
         ENDIF ELSE BEGIN
            IF keyword_set(verbose) THEN $
             print, 'L1 CAL file not found for '+date
            version = dd_version
         ENDELSE 

         product_version_web, plot_vers, np, 'LEVEL1_CAL_FILE', $
          [version,-1.0,-1.0], up_to_date, deficiency=defstring

         IF up_to_date EQ 1 THEN BEGIN
            output = 'Up To Date'
            out = 1
         ENDIF ELSE BEGIN
            output = defstring
            out = 1
         ENDELSE 
      ENDIF ELSE BEGIN
         output = 'Hydra L1 File Not Found'
         out = 0
      ENDELSE 
      
   ENDIF ELSE BEGIN

      IF keyword_set(survey) THEN BEGIN



         fn = hydra_findfile(date, /survey, silent=silent)
         IF (fn NE '') THEN BEGIN 
            IF keyword_set(verbose) THEN print, 'Survey file =',fn
            fn = str_sep(fn, '/')
            nf = n_elements(fn)
            file = fn(nf-1)
            v = str_sep(file,'.cdf')
            nv = n_elements(v)
            vers = v(0)
            nv = strlen(vers)
            p = rstrpos(vers,'_v')
            np = nv-p-2
            version = float(strmid(vers,p+2,np))
         
            product_version_web, plot_vers, np, 'SURVEY_FILE', $
             [version,-1.0,-1.0], up_to_date, deficiency=defstring

            IF up_to_date EQ 1 THEN BEGIN
               output = 'Up To Date'
               out = 1
            ENDIF ELSE BEGIN
               output = defstring
               out = 1
            ENDELSE 
         ENDIF ELSE BEGIN
            output = 'Hydra Survey File Not Found'
            out = 0
      ENDELSE 

      ENDIF ELSE BEGIN
         
         output = 'Data Availability ERROR'
         
      ENDELSE 

   ENDELSE 


   return
END
