PRO hydra_data_availability, first=first, last=last, $
                             level1=level1, survey=survey, $
                             verbose=verbose, everyday=everyday
;
;
;   
;
;
;
;
;
   IF keyword_set(level1) AND keyword_set(survey) THEN BEGIN
      print, 'Cannot use both level1 and survey keywords at the same time.'
      stop
   ENDIF 
   IF NOT (keyword_set(level1) OR  keyword_set(survey)) THEN BEGIN
      print, 'Must use keywords level1 or survey.'
      stop
   ENDIF 

   IF keyword_set(first) THEN first = strtrim(first,2) ELSE first = '19960320'
   IF keyword_set(last) THEN last = strtrim(last,2) ELSE last = '19960703'

   command = 'list_of_days '+first+' '+last

   spawn, command, days

   days = str_sep(days(0), ' ')
   ndays = n_elements(days)

   FOR i=0,ndays-1 DO BEGIN

      hydra_data_avail, days(i), output, out, $
       level1=level1, survey=survey, verbose=verbose

      IF (out EQ 1) OR (keyword_set(everyday)) THEN BEGIN 
         print, days(i)+' '+output
      ENDIF 
   ENDFOR 


   return
END
