function hydra_rcs_version_number, name_string, number=number
;
;   Returns the Snapshot Name converted to version number
;
;
start=strpos(name_string,':')+2
length=rstrpos(name_string,'$')-1-start
string=strmid(name_string,start,length)
if not keyword_set(number) then begin
    if string eq ' ' then string='Develop'
    return, string
endif

num=[0]
while strpos(string,'_') ne -1 do begin
    c=strmid(string,0,strpos(string,'_'))
    b=byte(c)
    if (where(b ge 48 and b le 57))(0) ne -1 then begin
        num=[num,long(c)]
    endif
    ip=strpos(string,'_')
    if (ip ne -1) then string=strmid(string,ip+1,strlen(string)-ip)
endwhile
num=[num,long(string)]
return, total(num*100.0^(reverse(indgen(n_elements(num)))-1))
end
