pro idl_mail, address, subject, message
;
;   Send a mail message from an IDL session/script
;
;
common idl_mail_common, save_address, save_subject, save_message, save_time

if n_params() ne 3 then begin
    message, '3 arguments not supplied to idl_mail.', /cont
    return
endif

time = systime(1)
if keyword_set(save_address) then begin
    if (address eq save_address) and (subject eq save_subject) and $
      (time-save_time lt 3600) then begin
        i=0
        imax=n_elements(save_message) < n_elements(message)-1
        while (save_message(i) ne message(i)) and (i lt imax) do i=i+1
        if i eq imax and (save_message(i) eq message(i)) then return
    endif
endif
save_address = address
save_subject = subject
save_message = message
save_time = time

filename='/tmp/idl_mail.'+strtrim(time,2)
get_lun, unit
openw, unit, filename
printf, unit, message
close, unit
free_lun, unit

command = 'cat '+filename+' | mailx -s "'+'IDL: '+subject+'" '+address+';rm '+filename
spawn, command

return
end

