;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                 ;
;   ISTP Key Parameter Visualization Tool                         ;
;            Version 1.5                                          ;
;          SPOF, GSFC, NASA                                       ;
;                                                                 ;
;               by                                                ; 
;       Syau-Yun Wang Hsieh , HSTX                                ;
;                                                                 ;
;                                                                 ;
;     E-mail: xrswh@istp1.gsfc.nasa.gov                           ;
;                                                                 ;
;   Phone: (301)286-4981     Fax:(301)286-1683                    ;
;                                                                 ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

pro replot_event,eventreplot
common setting,psflag,rpflag,poflag,mday
common pop,sub2_slider_new
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length

widget_control,eventreplot.id,get_uvalue=uval
case uval of
 1: begin
      for i=0,num_panel-1 do begin
        for j=0,1+2*psflag.num_KP_panel(i) do begin
          widget_control,sub2_slider_new(i,j),get_value=minORmax2
          minORmax=double(minORmax2(0))
          case j of
	 0: rpflag.xmin(i,2)=minORmax
	 1: rpflag.xmax(i,2)=minORmax
	 2: rpflag.ymin(i,0)=minORmax
	 3: rpflag.ymax(i,0)=minORmax
	 4: rpflag.ymin(i,1)=minORmax
	 5: rpflag.ymax(i,1)=minORmax
          endcase
        endfor
      endfor
      widget_control,/destroy,eventreplot.top
    end
 2: widget_control,/destroy,eventreplot.top
 else:begin
	iold=uval/10
	i=iold-1
	j=uval-iold*10-1
	widget_control,sub2_slider_new(i,j),get_value=minORmax2
	minORmax=double(minORmax2(0))
	case j of
	 0: rpflag.xmin(i,2)=minORmax
	 1: rpflag.xmax(i,2)=minORmax
	 2: rpflag.ymin(i,0)=minORmax
	 3: rpflag.ymax(i,0)=minORmax
	 4: rpflag.ymin(i,1)=minORmax
	 5: rpflag.ymax(i,1)=minORmax
	endcase
      end
endcase
end
  
pro replot

common setting,psflag,rpflag,poflag,mday
common cdfbloc,cdf,anycdf2,KP
common xxx,cdf_KPselect,butval2, axslide,deghappy, happyindex
common pop,sub2_slider_new
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common sysbloc,sys_def

;device,get_screen_size=screensize
popupbase=widget_base(/column,title='Select/Change User Defined Values', $
                      xoffset=sys_def.xsubwin(1),yoffset=sys_def.ysubwin(1) )
sub1_base=widget_base(popupbase,/row,space=30)
sub2_base=widget_base(popupbase,/column,/frame)
sub1_button1=widget_button(sub1_base,value='  OK  ',uvalue=1,  $
                           font=sys_def.fontname,/frame) 
sub2_button2=widget_button(sub1_base,value=' Cancel ',uvalue=2, /frame, $
                           font=sys_def.fontname)
sub2_labeli=lonarr(4)
sublabtext=[' ','X and Y Axis Scales','-----------------------------',' ']
for i=0,3 do sub2_labeli(i)=widget_label(sub2_base,value=sublabtext(i),  $
					 font=sys_def.fontname)
vartitle=['X   : ','Y(1): ','Y(2): ']
varclass=['min','max']
sub2_base_new=lonarr(num_panel)
sub2_label_new=lonarr(num_panel)
sub2_slider_new=lonarr(num_panel,6)
sub2_base2=lonarr(num_panel,6)
sub2_slider_lab=lonarr(num_panel,6)
unbase=lonarr(num_panel,6)
text_lab=unbase
sub3_base=widget_base(sub2_base,/row)

for i=0,num_panel-1 do begin
  sub2_base_new(i)=widget_base(sub3_base,/column,space=8)
  sub2_label_new(i)=widget_label(sub2_base_new(i),value='panel '+ $
           strcompress(string(i+1),/remove_all),font=sys_def.fontname )
  sub2_base2(i)=widget_base(sub2_base_new(i),/frame,/column)
  for j=0,1+2*psflag.num_KP_panel(i) do begin
    if psflag.xyrange eq 1 then begin
      if(j le 1)then                                                      $
	 if(psflag.typeplot eq 1)then myname=vartitle(0)+'Time (hour)' else $
	    myname=vartitle(0)+cdf_KPselect(i,2)                          $
      else                                                                $
	 if(j le 3)then myname=vartitle(1)+cdf_KPselect(i,0) else         $
	    myname=vartitle(2)+cdf_KPselect(i,1)
    endif else begin
      if(j le 1)then                                                      $
	 if(psflag.typeplot eq 1)then myname=vartitle(0)+'Time (hour)' else $
	    myname=vartitle(0)                          $
      else                                                                $
	 if(j le 3)then myname=vartitle(1) else         $
	    myname=vartitle(2)
    endelse

    if((j eq 0) or (j eq 2) or (j eq 4))then begin
	 sub2_slider_lab(i,j)=widget_label(sub2_base2(i),value=myname,  $
					   font=sys_def.fontname )
	 textlabval=varclass(0)
    endif else      textlabval=varclass(1)
    
    unbase(i,j)=widget_base(sub2_base2(i),/row)
    text_lab(i,j)=widget_label(unbase(i,j),value=textlabval,  $
                                font=sys_def.fontname)
    sub2_slider_new(i,j)=widget_text(unbase(i,j),xsize=15,/editable,  $
	    value='   ', uvalue=(j+1)+10*(i+1),/frame,font=sys_def.fontname )
    if(textlabval eq 'max ')then zerolab=widget_label(sub2_base2(i),   $
					      value=' ',font=sys_def.fontname)
  endfor
endfor

widget_control,popupbase,/realize
xmanager,"replot",popupbase,group_leader=sys_def.leader

for i=0,num_panel-1 do begin
  for j=0,1+2*psflag.num_KP_panel(i) do begin
    case j of
     0: slider_min_max=rpflag.xmin(i,2)
     1: slider_min_max=rpflag.xmax(i,2)
     2: slider_min_max=rpflag.ymin(i,0)
     3: slider_min_max=rpflag.ymax(i,0)
     4: slider_min_max=rpflag.ymin(i,1)
     5: slider_min_max=rpflag.ymax(i,1)
    endcase
    slider_min_max2=strcompress(string(slider_min_max),/remove_all)
    widget_control,sub2_slider_new(i,j),set_value=slider_min_max2
 endfor
endfor
end

pro minmax,i,j
common setting,psflag,rpflag,poflag,mday
common cdfbloc,cdf,anycdf2,KP

rpflag.xmin(i,j+2)=KP.scalemin(i,j+2)
rpflag.xmax(i,j+2)=KP.scalemax(i,j+2)
rpflag.ymin(i,j)=KP.scalemin(i,j)
rpflag.ymax(i,j)=KP.scalemax(i,j)

end

pro yourplot,i,j
common setting,psflag,rpflag,poflag,mday
common xxx,cdf_KPselect,butval2, axslide,deghappy, happyindex
common cdfbloc,cdf,anycdf2,KP

if(mday.i8_flag(i,j) eq 1)then begin
   x=dblarr(KP.i8mscount(i,j)) 
   y=x
   x(*)=KP.KPval(i,j+2,0:KP.i8mscount(i,j)-1)
   y(*)=KP.KPval(i,j,0:KP.i8mscount(i,j)-1)
endif else begin
   if(KP.dn_found(i,j) eq 1 and KP.dn_type eq 0)then begin
     x=dblarr(KP.valsize(i,j))
     y=x
     x(*)=KP.KPval_dn(i,j+2,0:KP.valsize(i,j)-1)
     y(*)=KP.KPval(i,j,0:KP.valsize(i,j)-1)
   endif else begin
     if(KP.dn_found(i,j) eq 1 and KP.dn_type eq 1)then begin
	x=dblarr(KP.valsize(i,j))
	y=x
	x(*)=KP.KPval(i,j+2,0:KP.valsize(i,j)-1)
	y(*)=KP.KPval(i,j,0:KP.valsize(i,j)-1)
     endif else begin
	x=dblarr(cdf.max_rec(i,j))
	y=x
	x(*)=KP.KPval(i,j+2,0:cdf.max_rec(i,j)-1)
	y(*)=KP.KPval(i,j,0:cdf.max_rec(i,j)-1)
     endelse
   endelse
endelse

case poflag.xyscale(i) of
1:begin
    x_type=0
    y_type=0
  end
2:begin
    x_type=0
    y_type=1
  end
3:begin
    x_type=1
    y_type=0
  end
4:begin
    x_type=1
    y_type=1
  end
endcase
;if ((poflag.xyscale(i)-1) and 2) ne 0 then x_type=1 else x_type=0
;y_type=(poflag.xyscale(i)-1) and 1

KP.unit(i,j)=strcompress(KP.unit(i,j),/remove_all)
KP.labl(i,j)=strcompress(KP.labl(i,j),/remove_all)
testy=KP.labl(i,j)+'('+KP.unit(i,j)+')'
xstyle=1 & ystyle=1
plot,x,y,xtitle=KP.labl(i,j+2)+'('+KP.unit(i,j+2)+')',             $
        ytitle=KP.labl(i,j)+'('+KP.unit(i,j)+')',                  $
	xrange=[rpflag.xmin(i,j+2),rpflag.xmax(i,j+2)],            $
	yrange=[rpflag.ymin(i,j),rpflag.ymax(i,j)],                $
	xticks=poflag.xmajor(i),xminor=poflag.xminor(i),           $
	yticks=poflag.ymajor(i),yminor=poflag.yminor(i),           $
	psym=poflag.symbol_val(i,j),linestyle=poflag.line_val(i,j),$
	xtype=x_type,ytype=y_type,symsize=0.3,xstyle=1,ystyle=1,/normal
end



pro make_plot
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common xxx,cdf_KPselect,butval2, axslide,deghappy, happyindex
common listv,file_list,flag_lpr,flag_cdftext,CDF_text,flag_cdf,flag_KP,  $
             sktfile,sfdfile,file_ext
common cdfbloc,cdf,anycdf2,KP
common extra,KPvar_select,KPd_select,KPvarnum_select,KPdtype_select, $
	     iKPcount_select,KPdimsiz_select

KPval_new=dblarr(num_panel,4,10000)
!p.charsize=psflag.pfontsize
!p.multi=[0,0,num_panel,0,0]

program_name='ISTP'

for i=0,num_panel-1 do begin
  case mday.i8_flag(i,0) of
  1: i8dayno='(Day '+strcompress(string(mday.i8day(i,0)),/remove_all)+ $
	     ' of Year '+strcompress(string(mday.i8year(i,0)),/remove_all)+')'
  else: i8dayno=''
  endcase
  if(i eq 0)then begin
    case psflag.typeplot of
       1: begin
	    case psflag.SorM of
	    3: !p.title='!3'+program_name+' Key Parameters (Time Series)'
	    else: !p.title='!3'+program_name+' Key Parameters (Time Series)'+  $
			 '!cCDF: '+cdf_selection(i,0)+i8dayno
	    endcase
	  end
       2: begin
	    case psflag.SorM of
	    3: !p.title='!3'+program_name+' Key Parameters (Variable-Variable)'
	    else: !p.title='!3'+program_name+' Key Parameters '+$
			   '(Variable-Variable)'+$
			   '!cCDF: '+cdf_selection(i,0)+i8dayno
	    endcase
	  end
    endcase
  endif else begin
      case psflag.SorM of
      2: !p.title='CDF: '+cdf_selection(i,0)+i8dayno
      else: !p.title=' '
      endcase
  endelse

  subtext1='CDF: '+cdf_selection(i,0)+'  KP: '+cdf_KPselect(i,0)
  subtext2='CDF1 (L): '+cdf_selection(i,0)+'  KP: '+cdf_KPselect(i,0)+'  '+$
         i8dayno $
  + '!cCDF2 (R): '+cdf_selection(i,1)+'  KP: '+cdf_KPselect(i,1)+'  '+i8dayno
  subtext3='KP: '+cdf_KPselect(i,0) 
  subtext4='KP1 (L): '+cdf_KPselect(i,0)+ $
	 '!cKP2 (R): '+cdf_KPselect(i,1)
  subtext5=+'!c   '+ $
	   '!cKey Parameter Visualization Tool V1.5        @ '+systime() 
  
  if(i lt num_panel-1)then extratext='' else extratext=subtext5
  case psflag.SorM of
    3: begin
	 if(psflag.num_KP_panel(i) lt 2)then !p.subtitle=subtext1+extratext  $ 
	 else  !p.subtitle= subtext2+extratext 
       end
    else:begin
	   case psflag.typeplot of
	   1: if(psflag.num_KP_panel(i) lt 2)then   $
                   !p.subtitle=subtext3+extratext   $
	      else !p.subtitle=subtext4+extratext
	   2: if(psflag.num_KP_panel(i) lt 2)then !p.subtitle='(X) KP: '+$
		  cdf_KPselect(i,2)+'!c(Y) '+subtext3+extratext $
	      else !p.subtitle='(X) KP : '+cdf_KPselect(i,2)+$
		    '!c(Y) '+'KP1 (L): '+cdf_KPselect(i,0)+$
		    '!c(Y) '+'KP2 (R): '+cdf_KPselect(i,1)+extratext
	   endcase
	 end
  endcase
  for j=0,psflag.num_KP_panel(i)-1 do begin
      if(psflag.xyrange eq 1)then minmax,i,j
      case j of
      0:yourplot,i,j
      1:begin
	  if(mday.i8_flag(i,j) eq 1)then numcount=KP.i8mscount(i,j) else $
		   numcount=cdf.max_rec(i,j)
	  if(psflag.replot eq 1)then begin
	      leftmin=rpflag.ymin(i,0)
	      leftmax=rpflag.ymax(i,0)
	      rightmin=rpflag.ymin(i,j)
	      rightmax=rpflag.ymax(i,j)
	  endif else begin
	      leftmin=KP.scalemin(i,0)
	      leftmax=KP.scalemax(i,0)
	      rightmin=KP.scalemin(i,j)
	      rightmax=KP.scalemax(i,j)
	  endelse
	  if(poflag.xyscale(i) eq 2 or poflag.xyscale(i) eq 4)then begin
	    bbb=float(alog10(leftmax)-alog10(leftmin))/ $
		 float(alog10(rightmax)-alog10(rightmin))
	    for kkk=0,numcount-1 do begin
		      if(KP.KPval(i,j,kkk) ne 0.0)then  $
			KPval_new(i,j,kkk)=    $
			10^(bbb*(alog10(KP.KPval(i,j,kkk))- $
			alog10(rightmin))+alog10(leftmin))
	    endfor
	    axis,/yaxis,ytitle=KP.labl(i,j)+'('+KP.unit(i,j)+')',$
		  /ytype,yrange=[rpflag.ymin(i,j),rpflag.ymax(i,j)],$
		  xticks=poflag.xmajor(i),xminor=poflag.xminor(i),$
		  yticks=poflag.ymajor(i),yminor=poflag.yminor(i)
	    oplot,KP.KPval(i,j+2,0:numcount-1),$
		  KPval_new(i,j,0:numcount-1),    $
		  psym=poflag.symbol_val(i,j),linestyle=poflag.line_val(i,j),$
                  symsize=0.3
	  endif else begin
	    if((poflag.xyscale(i) eq 1) or    $
		 (poflag.xyscale(i) eq 3))then begin
		KPval_new(i,j,0:numcount-1)=    $
		      ( (leftmax-leftmin)/  $
			(rightmax-rightmin) ) $
		   *(KP.KPval(i,j,0:numcount-1)-rightmin) $
		   +leftmin
		axis,/yaxis,ytitle=KP.labl(i,j)+'('+KP.unit(i,j)+')',$
		     yrange=[rpflag.ymin(i,j),rpflag.ymax(i,j)], $
		     xticks=poflag.xmajor(i),xminor=poflag.xminor(i),$
		     yticks=poflag.ymajor(i),yminor=poflag.yminor(i)
		oplot,KP.KPval(i,j+2,0:numcount-1),    $
		    KPval_new(i,j,0:numcount-1),       $
		    psym=poflag.symbol_val(i,j),       $
                    linestyle=poflag.line_val(i,j), symsize=0.3
	    endif
	  endelse
	end
      endcase
   endfor
endfor

end


pro get_vardata,i,j,TIME_VAR=time_var,val,  $
		label,units,validmin,validmax,scalemin,scalemax,prefer_scale 
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common cdfbloc,cdf,anycdf2,KP
common extra,KPvar_select,KPd_select,KPvarnum_select,KPdtype_select, $
	     iKPcount_select,KPdimsiz_select
common timbloc, d_Epo,d_PB5,PB5


var_type=202

if j gt 1 then idcdf=cdf_open(cdf_selection(i,0)) else $
	       idcdf=cdf_open(cdf_selection(i,j))
if keyword_set(time_var) then begin 
    cdf_varget,idcdf,time_var,varval,rec_count=cdf.max_rec(i,j)  
    timevar_flag=1
    dims,var_type,timevar_flag,i,j,varval,val,cc
endif else begin
   timevar_flag=0
   cdf_varget,idcdf,KPvarnum_select(i,j),varval,  $
					   rec_count=cdf.max_rec(i,j)           
   get_c_n_d,cc,i,j

   dims,var_type,timevar_flag,i,j,varval,val,cc

   ; get attr info

   varattrname=strarr(cdf.num_attrs(i,j))
   for kkk=0,cdf.num_attrs(i,j)-1 do begin
     cdf_attinq,idcdf,kkk,name,scope,maxentry,maxzentry
     varattrname(kkk)=name
   endfor

  ; get label

  var_type=101
  attr_type='CHAR'
  attrname=['LABLAXIS','LABL_PTR_1']
  attrcheck_flag=lonarr(2)
  for mm=0,1 do begin
    acheck=where(varattrname eq attrname(mm),count)
    if count ne 0 then attrcheck_flag(mm)=1
  endfor

  get_attr_chaval,i,j,idcdf,var_type,type=attr_type,attrname,label,cc,$
		  timevar_flag,attrcheck_flag

  ; get unit
  
  var_type=101
  attr_type='CHAR'
  attrname=['UNITS','UNIT_PTR']
  attrcheck_flag=lonarr(2)
  for mm=0,1 do begin
    acheck=where(varattrname eq attrname(mm),count)
    if count ne 0 then attrcheck_flag(mm)=1
  endfor

  get_attr_chaval,i,j,idcdf,var_type,type=attr_type,attrname,units,cc,$
		  timevar_flag,attrcheck_flag

  ; get  [validmin, validmax] and [scalemin, scalemax]

  attrcheck_flag=intarr(4)
  attrname=['VALIDMIN','VALIDMAX','SCALEMIN','SCALEMAX']
  attrcheck_flag=[0, 0, 0, 0]
  var_type=101
  for mm=0,3 do begin
     acheck=where(varattrname eq attrname(mm),count)
     if count ne 0 then attrcheck_flag(mm)=1
     get_attr_numval,i,j,idcdf,var_type,attrname(mm),attrval,cc, $
                        timevar_flag, attrcheck_flag(mm)
     case mm of
        0: validmin=attrval
        1: validmax=attrval
        2: scalemin=attrval
        3: scalemax=attrval
     endcase
  endfor
  ;print,'attrcheck_flag= ',attrcheck_flag
  case 1 of                ; prefer_scale=1 means [validmin,validmax] is 
                           ; in use and prefer_scale=2 means [scalemin,
                           ; scalemax] is in use.
  (attrcheck_flag(0) eq 1) and (attrcheck_flag(1) eq 1) and    $
    (attrcheck_flag(2) eq 1) and (attrcheck_flag(3) eq 1): prefer_scale=2
  (attrcheck_flag(0) eq 1) and (attrcheck_flag(1) eq 1) and    $
    (attrcheck_flag(2) eq 0) and (attrcheck_flag(3) eq 0): prefer_scale=1
  (attrcheck_flag(0) eq 0) and (attrcheck_flag(1) eq 0) and    $
    (attrcheck_flag(2) eq 1) and (attrcheck_flag(3) eq 1): prefer_scale=2
  (attrcheck_flag(0) eq 0) and (attrcheck_flag(1) eq 0) and    $
    (attrcheck_flag(2) eq 0) and (attrcheck_flag(3) eq 0): prefer_scale=2
  else:                        prefer_scale=2
  endcase

endelse 
cdf_close,idcdf
end

function find_day,yr,mon,dayday

firstday=[0,31,59,90,120,151,181,212,243,273,304,334,366]
if (((yr mod 4)eq 0) and ((yr mod 100) ne 0)) or ((yr mod 400) eq 0) $
then firstday(2)=firstday(2:*)+1
day=dayday+firstday(mon-1)
return,day
end

pro dims,var_type,timevar_flag,i,j,varval,val,cc

common extra,KPvar_select,KPd_select,KPvarnum_select,KPdtype_select, $
	     iKPcount_select,KPdimsiz_select
common cdfbloc,cdf,anycdf2,KP
common timbloc, d_Epo,d_PB5,PB5

case var_type of
  202: begin
         index202=where(KPd_select(i,j,0:cdf.num_dims(i,j)-1) eq 2001,count)
					      ;for data (rec-vary) 
         index=index202(0)
       end
  101: begin
         index101=-5      ;for char (non rec-vary variables) 
         index=index101
       end
else:
endcase
if index ne -5 then begin
   if timevar_flag eq 1 then begin
     if cdf.time_var(i,j) eq 'Time_PB5' then begin
        for k=0,2 do begin
           d=reform(d_PB5(k,*))
           dimlysis,index,i,j,varval,b,cc,d,timevar_flag
           PB5(0:cdf.max_rec(i,j)-1,k)=reform(b)
        endfor
     endif else begin    ;Epoch
        d=d_Epo(*)
        dimlysis,index,i,j,varval,b,cc,d,timevar_flag

        Epo_val=reform(b)
        for mm=0,cdf.max_rec(i,j)-1 do begin
            cdf_epoch,Epo_val(mm),yr,mo,dy,hr,mn,sc,mi,/break
            ms=float(hr)*3600000.+float(mn)*60000.+float(sc)*1000.+float(mi)
            doy=find_day(yr,mo,dy)
            PB5(mm,0)=yr
            PB5(mm,1)=doy
            PB5(mm,2)=ms
        endfor
     endelse
   endif else begin
     d=reform(KPd_select(i,j,0:cdf.num_dims(i,j)-1))
     dimlysis,index,i,j,varval,b,cc,d,timevar_flag
     val=reform(b)
   endelse
endif else begin
   dimlysis,index,i,j,varval,b,cc,d,timevar_flag
   if n_elements(b) eq 1 then val=b else val=reform(b)
endelse

end

pro dimlysis,index,i,j,varval,b,cc,d,timevar_flag
common cdfbloc,cdf,anycdf2,KP
common extra,KPvar_select,KPd_select,KPvarnum_select,KPdtype_select, $
	     iKPcount_select,KPdimsiz_select

if timevar_flag eq 1 then index=-1
case cdf.num_dims(i,j) of
  1:begin
      case index of 
       -1: b=varval(d(0),*)
	0: b=varval(*,*)
      else: b=varval(cc(0))
      endcase
  end

  2:begin
      case index of
       -1: b=varval(d(0),d(1),*)
	0: b=varval(*,d(1),*)
	1: b=varval(d(0),*,*)
      else: b=varval(cc(0),cc(1))
      endcase
    end

  3:begin
      case index of
       -1: b=varval(d(0),d(1),d(2),*)
	0: b=varval(*,d(1),d(2),*)
	1: b=varval(d(0),*,d(2),*)
	2: b=varval(d(0),d(1),*,*)
      else: b=varval(cc(0),cc(1),cc(2))
      endcase
    end
  
  4:begin
      case index of
       -1: b=varval(d(0),d(1),d(2),d(3),*)
	0: b=varval(*,d(1),d(2),d(3),*)
	1: b=varval(d(0),*,d(2),d(3),*)
	2: b=varval(d(0),d(1),*,d(3),*)
	3: b=varval(d(0),d(1),d(2),*,*)
      else: b=varval(cc(0),cc(1),cc(2),cc(3))
      endcase
    end

  5:begin
      case index of
       -1: b=varval(d(0),d(1),d(2),d(3),d(4),*)
	0: b=varval(*,d(1),d(2),d(3),d(4),*)
	1: b=varval(d(0),*,d(2),d(3),d(4),*)
	2: b=varval(d(0),d(1),*,d(3),d(4),*)
	3: b=varval(d(0),d(1),d(2),*,d(4),*)
	4: b=varval(d(0),d(1),d(2),d(3),*,*)
      else: b=varval(cc(0),cc(1),cc(2),cc(3),cc(4))
      endcase
    end

  6:begin
      case index of
       -1: b=varval(d(0),d(1),d(2),d(3),d(4),d(5),*)
	0: b=varval(*,d(1),d(2),d(3),d(4),d(5),*)
	1: b=varval(d(0),*,d(2),d(3),d(4),d(5),*)
	2: b=varval(d(0),d(1),*,d(3),d(4),d(5),*)
	3: b=varval(d(0),d(1),d(2),*,d(4),d(5),*)
	4: b=varval(d(0),d(1),d(2),d(3),*,d(5),*)
	5: b=varval(d(0),d(1),d(2),d(3),d(4),*,*)
      else: b=varval(cc(0),cc(1),cc(2),cc(3),cc(4),cc(5))
      endcase
    end
  else:
endcase

end

pro get_c_n_d,cc,i,j
common extra,KPvar_select,KPd_select,KPvarnum_select,KPdtype_select, $
	     iKPcount_select,KPdimsiz_select
common cdfbloc,cdf,anycdf2,KP

cc=KPd_select(i,j,0:cdf.num_dims(i,j)-1)
index2001=where(KPd_select(i,j,0:cdf.num_dims(i,j)-1) eq 2001,count)
if count ne 0 then cc(index2001)=0
  
end

pro get_attr_chaval,i,j,idcdf,var_type,type=attr_type,attrname,attr_val,cc ,$
		    timevar_flag,attrcheck_flag
common cdfbloc,cdf,anycdf2,KP
common extra,KPvar_select,KPd_select,KPvarnum_select,KPdtype_select, $
	     iKPcount_select,KPdimsiz_select

status=intarr(2)
for attrcount=0,n_elements(attrname)-1 do begin
  if attrcheck_flag(attrcount) ne 0 then begin
     trigger =0
     on_ioerror,noattr
     cdf_attget,idcdf,attrname(attrcount),KPvarnum_select(i,j),val
     case attrcount of
       0: attrval0=val
       1: attrval1=val
       else:
     endcase
     status(attrcount)=1
     trigger=1
   noattr: if trigger ne 1 then status(attrcount)=0
   endif else status(attrcount)=0
endfor

case 1 of
 (status(0) eq 1) and (status(1) eq 1): attr_val='Illegal Attrbute!'
 (status(0) eq 1) and (status(1) eq 0): attr_val=string(attrval0)
 (status(0) eq 0) and (status(1) eq 1): begin
	cdf_varget,idcdf,attrval1,attrval  ;attrval1 is the var name
                                 ;attrval is the val of var attrval1
	attrval=string(attrval)
	dims,var_type,timevar_flag,i,j,attrval,attr_val,cc
				   ;attr_val is the reformed var value
				   ; of attrval1
      end
 (status(0) eq 0) and (status(1) eq 0): attr_val='NO_SUCH_ENTRY'
else: badnews,'There is something wrong!!'
endcase
end

pro get_attr_numval,i,j,idcdf,var_type,type=attr_type,attrname,attr_numval,cc,$
		    timevar_flag,check_flag
common cdfbloc,cdf,anycdf2,KP
common extra,KPvar_select,KPd_select,KPvarnum_select,KPdtype_select, $
	     iKPcount_select,KPdimsiz_select

status=0
attrcount=0

if check_flag ne 0 then begin
   trigger =0
   on_ioerror,noattr
   cdf_attget,idcdf,attrname(attrcount),KPvarnum_select(i,j),attrval
   status=1
   trigger=1
   attrcount=attrcount+1
noattr: if trigger ne 1 then begin
	    status=0
	    attrcount=attrcount+1
	endif
endif else status=0

index_flag=0 
case 1 of
 (status eq 1) :begin
		  num_attrval=n_elements(attrval)
		  case 1 of
		    (num_attrval eq 1): attr_numval=attrval
		    (num_attrval gt 1): begin
					  for k=0,cdf.num_dims(i,j)-1 do begin
					    if cc(k) ne 0 then begin
					       index_attr=cc(k)
					       index_flag=1
					    endif
					  endfor
					  if index_flag eq 0 then index_attr=0
					  attr_numval=attrval(index_attr)
					end
		  else:
		  endcase
		end
 else: if((attrname eq 'VALIDMIN') or (attrname eq 'SCALEMIN'))then $
	  attr_numval=-55555.0  else attr_numval=55555.0
endcase

end
		     
pro read_time,i,j,CHECKDATE=checkdate,stryear,strdoy,stoyear,stodoy
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common cdfbloc,cdf,anycdf2,KP
common extra,KPvar_select,KPd_select,KPvarnum_select,KPdtype_select, $
	     iKPcount_select,KPdimsiz_select
common timbloc, d_Epo,d_PB5,PB5

case 1 of
(cdf.time_var(i,j) eq 'Time_PB5' ): begin
       d_PB5=intarr(3,cdf.num_dims(i,j))
       KPdata_type_PB5=strarr(3,1)
       KPvar_index_PB5=intarr(3,1)
       time_check_flag=0
       i_KPlist=0

       timevar=['Time_PB5 (component:1)', 'Time_PB5 (component:2)', $
                'Time_PB5 (component:3)']
       itime=0
   while((time_check_flag eq 0) and (i_KPlist le (cdf.KPcount(i,j)-1))) do begin
          if(cdf.KPlist(i,j,i_KPlist) eq timevar(itime))then begin
	     d_PB5(itime,*)=cdf.d(i,j,i_KPlist,0:cdf.num_dims(i,j)-1)
	     KPvar_index_PB5(itime,0)=cdf.KPvar_index(i,j,i_KPlist)
	     KPdata_type_PB5(itime,0)=cdf.KPdata_type(i,j,i_KPlist)
	     itime=itime+1
          endif
          if(itime eq 3) then time_check_flag=1
          i_KPlist=i_KPlist+1
       endwhile
    end
(cdf.time_var(i,j) eq 'Epoch'): begin
       d_Epo=intarr(cdf.num_dims(i,j))
       KPdata_type_Epo=' '
       KPvar_index_Epo=1
       time_check_flag=0
       i_KPlist=0

       timevar='Epoch (scalar)'
       itime=0
  while((time_check_flag eq 0) and (i_KPlist le (cdf.KPcount(i,j)-1))) do begin
          if(cdf.KPlist(i,j,i_KPlist) eq timevar)then begin
	     d_Epo(*)=cdf.d(i,j,i_KPlist,0:cdf.num_dims(i,j)-1)
	     KPvar_index_Epo=cdf.KPvar_index(i,j,i_KPlist)
	     KPdata_type_Epo=cdf.KPdata_type(i,j,i_KPlist)
             time_check_flag=1
          endif
          i_KPlist=i_KPlist+1
       endwhile
    end
else:
endcase

PB5=lonarr(cdf.max_rec(i,j),3)

time_var=cdf.time_var(i,j)
get_vardata,i,j,TIME_VAR=time_var,   $
	    val,label,units,validmin,validmax,scalemin,scalemax,prefer_scale 

;
; check the date to determine whether it is a multiday CDF
;
if keyword_set(checkdate) then begin
  intyr=PB5(0,0)
  intdoy=PB5(0,1)
  endyr=PB5(cdf.max_rec(i,j)-1,0)
  enddoy=PB5(cdf.max_rec(i,j)-1,1)

  case 1 of
  (intyr eq endyr):begin
		      case 1 of
		      (intdoy eq enddoy):begin
					   mday.i8_flag(i,j)=0
					   stryear=intyr
					   strdoy=intdoy
					   stoyear=endyr
					   stodoy=enddoy
					 end
		      else: begin
			      mday.i8_flag(i,j)=1
			      stryear=intyr
			      strdoy=intdoy
			      stoyear=endyr
			      stodoy=enddoy
			    end
		      endcase
		    end
  else:begin
       mday.i8_flag(i,j)=1
       stryear=intyr
       strdoy=intdoy
       stoyear=endyr
       stodoy=enddoy
     end
  endcase
endif else begin

; compute the time for plotting

  i8yr=lonarr(cdf.max_rec(i,j)) & i8dy=i8yr & i8ms=i8yr
  n=j+2
  KP.labl(i,n)='Time' & KP.unit(i,n)='Hour'
  KP.validmin(i,n)=0.0 & KP.validmax(i,n)=24.0
  KP.scalemin(i,n)=0.0 & KP.scalemax(i,n)=24.0

  if(mday.i8_flag(i,j) eq 1)then begin
    i8yr(*)=PB5(*,0) ;year
    i8dy(*)=PB5(*,1) ;month
    i8ms(*)=PB5(*,2) ;ms
    KP.imp8yr(i,n,0:cdf.max_rec(i,j)-1)=i8yr(*)
    KP.imp8dy(i,n,0:cdf.max_rec(i,j)-1)=i8dy(*)
    KP.imp8ms(i,n,0:cdf.max_rec(i,j)-1)=i8ms(*)
    zzz=where(i8dy eq mday.i8day(i,j))
    zzzcount=n_elements(zzz)
    i8msselect=lonarr(zzzcount)
    if(zzzcount eq 1) then $
       if(zzz eq -1)then i8msselect=0 else i8msselect=i8ms(zzz) $
    else i8msselect=i8ms(zzz)
    KP.i8mscount(i,j)=n_elements(i8msselect)
    for k=0,KP.i8mscount(i,j)-1 do KP.KPval(i,n,k)=$
	   float(i8msselect(k))/float(3600000)
  endif else begin
    for k=0,cdf.max_rec(i,j)-1 do KP.KPval(i,n,k)=$
	   float(PB5(k,2))/float(3600000)
  endelse
endelse

end
 

pro pea,CDFname
common cdfbloc,cdf,anycdf2,KP
common peabloc,id,num_dims,dim_sizes,encoding,majority,max_rec,num_vars,$
	num_attrs

id=cdf_open(CDFname)
cdfinfo=cdf_inquire(id)

num_dims=cdfinfo.ndims
dim_sizes=lonarr(num_dims)
dim_sizes=cdfinfo.dim
encoding=cdfinfo.encoding
majority=cdfinfo.majority
max_rec=cdfinfo.maxrec
num_vars=cdfinfo.nvars
num_attrs=cdfinfo.natts

KPcountmax=500
anycdf2={var_name:strarr(num_vars), data_type:strarr(num_vars),        $
         num_elems:lonarr(num_vars), rec_vary:strarr(num_vars),        $
         dim_vary:lonarr(num_vars,num_dims),                           $
         var_index:lonarr(num_vars), KPcount:0L,                       $
         KPlist:strarr(KPcountmax), KPdata_type:strarr(KPcountmax),    $
         KPvar_index:intarr(KPcountmax), d:intarr(KPcountmax,num_dims),$
         KPvar_list:strarr(KPcountmax), time_var:' ' }

for i=0,num_vars-1 do begin
   varinfo=cdf_varinq(id,i)
   anycdf2.var_name(i)=varinfo.name
   anycdf2.data_type(i)=varinfo.datatype
   anycdf2.rec_vary(i)=varinfo.recvar
   anycdf2.dim_vary(i,*)=varinfo.dimvar
   anycdf2.num_elems(i)=varinfo.numelem
   anycdf2.var_index(i)=i  
endfor

; check time variables   06/21/95

time_var1=where(strcompress(anycdf2.var_name,/remove_all) eq 'Time_PB5',count)
if count ne 0 then time_var1=1    ; 'Time_PB5 exists.'
time_var2=where(strcompress(anycdf2.var_name,/remove_all) eq 'Epoch',count2)
if count2 ne 0 then time_var2=1   ; 'Epoch exists.'
case 1 of 
(time_var1 eq 0) and (time_var2 eq 1): anycdf2.time_var='Epoch'
else: anycdf2.time_var='Time_PB5'
endcase
;

anycdf2.KPcount=0

for i=0, num_vars-1 do begin
  dim_flag=0
  if(anycdf2.rec_vary(i) eq 'VARY' )then begin  
    for j=0, num_dims-1 do begin
      case anycdf2.dim_vary(i,j) of
      1:begin
          case dim_flag of
          0: begin
               for k=0,dim_sizes(j)-1 do begin
	         kk=k+1
	         anycdf2.KPlist(anycdf2.KPcount)=    $
                        strcompress(anycdf2.var_name(i),/remove_all) $
		        +' (component:'+strcompress(string(kk),  $
                        /remove_all)+')'
		 anycdf2.KPvar_list(anycdf2.KPcount)=   $
                        strcompress(anycdf2.var_name(i),/remove_all)
       	         anycdf2.d(anycdf2.KPcount,j)=k
		 anycdf2.KPdata_type(anycdf2.KPcount)=   $
                                              anycdf2.data_type(i)
		 anycdf2.KPvar_index(anycdf2.KPcount)=   $
                                              anycdf2.var_index(i)
		 anycdf2.KPcount=anycdf2.KPcount+1
	       endfor
	       dim_flag=1001
             end
	  else: for k=0,dim_sizes(j-1)-1 do    $
                             anycdf2.d(anycdf2.KPcount-1-k,j)=2001
	  endcase
	end
      else:
      endcase
    endfor
    
    if(dim_flag eq 0)then begin
      anycdf2.KPlist(anycdf2.KPcount)=strcompress(anycdf2.var_name(i), $
			   /remove_all)+' (scalar)'
      anycdf2.KPvar_list(anycdf2.KPcount)=    $
                    strcompress(anycdf2.var_name(i),/remove_all)
      anycdf2.KPdata_type(anycdf2.KPcount)=anycdf2.data_type(i)
      anycdf2.KPvar_index(anycdf2.KPcount)=anycdf2.var_index(i)
      anycdf2.d(anycdf2.KPcount,*)=0
      anycdf2.KPcount=anycdf2.KPcount+1
    endif
  endif
endfor

anycdf2.KPlist = anycdf2.KPlist(0:anycdf2.KPcount-1)
anycdf2.KPvar_list = anycdf2.KPvar_list(0:anycdf2.KPcount-1)
anycdf2.d = anycdf2.d(0:anycdf2.KPcount-1,0:num_dims-1)
for i=0,anycdf2.KPcount-1 do begin
 for j=0,num_dims-1 do begin
   if(anycdf2.d(i,j) eq 0) then anycdf2.d(i,j)=0
 endfor
endfor
anycdf2.KPvar_index = anycdf2.KPvar_index(0:anycdf2.KPcount-1)
anycdf2.KPdata_type = anycdf2.KPdata_type(0:anycdf2.KPcount-1)
cdf_close,id
end
 
pro peasoup,i,j

common peabloc,id,num_dims,dim_sizes,encoding,majority,max_rec,num_vars,$
	num_attrs
common cdfbloc,cdf,anycdf2,KP

cdf.id(i,j)=id
cdf.num_dims(i,j)=num_dims
cdf.dim_sizes(i,j,0:num_dims-1)=dim_sizes
cdf.encoding(i,j)=encoding
cdf.majority(i,j)=majority
cdf.max_rec(i,j)=max_rec+1
cdf.num_vars(i,j)=num_vars
cdf.num_attrs(i,j)=num_attrs
cdf.KPcount(i,j)=anycdf2.KPcount
cdf.KPvar_list(i,j,0:anycdf2.KPcount-1)=anycdf2.KPvar_list(0:anycdf2.KPcount-1)
cdf.KPlist(i,j,0:anycdf2.KPcount-1)=anycdf2.KPlist(0:anycdf2.KPcount-1)
cdf.d(i,j,0:anycdf2.KPcount-1,0:num_dims-1)=anycdf2.d(0:anycdf2.KPcount-1,*)
cdf.KPvar_index(i,j,0:anycdf2.KPcount-1)=        $
                                       anycdf2.KPvar_index(0:anycdf2.KPcount-1)
cdf.KPdata_type(i,j,0:anycdf2.KPcount-1)=        $
                                       anycdf2.KPdata_type(0:anycdf2.KPcount-1)
cdf.time_var(i,j)=anycdf2.time_var
;print,cdf.time_var(i,j)

end

pro pass,i,j
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common cdfbloc,cdf,anycdf2,KP
common extra,KPvar_select,KPd_select,KPvarnum_select,KPdtype_select, $
	     iKPcount_select,KPdimsiz_select

;;val=dblarr(cdf.max_rec(i,j))
KP.dn_found(i,j)=0
for k=0,cdf.num_dims(i,j)-1 do begin
   if(KPd_select(i,j,k) eq 2001) then begin
       KP.dn_found(i,j)=1
       KP.dn_size(i,j)=KPdimsiz_select(i,j,k)
       KP.valsize(i,j)=cdf.max_rec(i,j)*KPdimsiz_select(i,j,k)
       val=dblarr(KP.valsize(i,j))
   endif
endfor

label=' ' & units=' ' & validmin=1.0e+10 & validmax=validmin
scalemin=validmin & scalemax=validmin

get_vardata,i,j,val,label,units,validmin,validmax,scalemin,scalemax, $
            prefer_scale
;print,'pass: units= ',units
if(j gt 1)then begin
   case mday.i8_flag(i,0) of
   1:begin
      i8dy=lonarr(cdf.max_rec(i,0))
      i8dy(*)=KP.imp8dy(i,2,0:cdf.max_rec(i,0)-1)
      ttt=where(i8dy eq mday.i8day(i,0))
      tttcount=n_elements(ttt)
      i8KPselect=dblarr(tttcount)
      if(tttcount eq 1)then $
	if(ttt eq -1) then i8KPselect=0 else i8KPselect=val(ttt) $
       else i8KPselect=val(ttt) 
      KP.KPval(i,j,0:KP.i8mscount(i,0)-1)=i8KPselect(0:KP.i8mscount(i,0)-1)
     end
   else: if(KP.dn_found(i,j) eq 1)then    $
                KP.KPval(i,j,0:KP.valsize(i,j)-1)=val(*) else $
		KP.KPval(i,j,0:cdf.max_rec(i,j)-1)=val(*)
   endcase
endif else begin
   case mday.i8_flag(i,j) of
   1:begin
       i8dy=lonarr(cdf.max_rec(i,j))
       i8dy(*)=KP.imp8dy(i,j+2,0:cdf.max_rec(i,j)-1)
       www=where(i8dy eq mday.i8day(i,j))
       wwwcount=n_elements(www)
       i8KPselect=dblarr(wwwcount)
       if(wwwcount eq 1)then $
	 if(www eq -1) then i8KPselect=0 else i8KPselect=val(www) $
	else i8KPselect=val(www) 
       KP.KPval(i,j,0:wwwcount-1)=i8KPselect(0:wwwcount-1)
     end 
   else: if(KP.dn_found(i,j) eq 1)then KP.KPval(i,j,0:KP.valsize(i,j)-1)=val(*) else $
		KP.KPval(i,j,0:cdf.max_rec(i,j)-1)=val(*)
   endcase
endelse
KP.labl(i,j)=label
KP.unit(i,j)=units
KP.prefer_defscale=prefer_scale
if prefer_scale eq 2 then begin
   KP.scalemin(i,j)=scalemin
   KP.scalemax(i,j)=scalemax
endif else begin
   KP.scalemin(i,j)=validmin
   KP.scalemax(i,j)=validmax
endelse
end


pro dn_check,i,j,cdfi,cdfj,kpi,kpj
Common cdfbloc,cdf,anycdf2,KP
common extra,KPvar_select,KPd_select,KPvarnum_select,KPdtype_select, $
	     iKPcount_select,KPdimsiz_select

for ii=0,cdf.max_rec(cdfi,cdfj)-1 do begin
       kkend=ii*KP.dn_size(i,j)+KP.dn_size(i,j)-1
       kkint=ii*KP.dn_size(i,j)
       for kk=kkint,kkend do $
	      KP.KPval_dn(kpi,kpj,kk)=KP.KPval(kpi,kpj,ii)
endfor
end

pro kp_all,iL,jL,iR,jR
common cdfbloc,cdf,anycdf2,KP

KP.KPval(iL,jL,*)=KP.KPval(iR,jR,*)
KP.labl(iL,jL)=KP.labl(iR,jR)
KP.unit(iL,jL)=KP.unit(iR,jR)
KP.validmin(iL,jL)=KP.validmin(iR,jR)
KP.validmax(iL,jL)=KP.validmax(iR,jR)
KP.scalemin(iL,jL)=KP.scalemin(iR,jR)
KP.scalemax(iL,jL)=KP.scalemax(iR,jR)
end

pro i8_check,i8iL,i8jL,i8iR,i8jR,numiL,numjL,numiR,numjR
common cdfbloc,cdf,anycdf2,KP

KP.imp8yr(i8iL,i8jL,*)=KP.imp8yr(i8iR,i8jR,*)
KP.imp8dy(i8iL,i8jL,*)=KP.imp8dy(i8iR,i8jR,*)
KP.imp8ms(i8iL,i8jL,*)=KP.imp8ms(i8iR,i8jR,*)
KP.i8mscount(numiL,numjL)=KP.i8mscount(numiR,numjR)
end

pro set_go
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common cdfbloc,cdf,anycdf2,KP
common extra,KPvar_select,KPd_select,KPvarnum_select,KPdtype_select, $
	     iKPcount_select,KPdimsiz_select

;for KPval----- 0,1:var y1 & y2  ; 2,3:var x1 & x2(or t1 & t2)

KP={KPval:dblarr(num_panel,4,10000),KPval_dn:dblarr(num_panel,4,10000),$
    labl:strarr(num_panel,4), unit:strarr(num_panel,4),          $
    validmin:fltarr(num_panel,4), validmax:fltarr(num_panel,4),  $
    scalemin:fltarr(num_panel,4), scalemax:fltarr(num_panel,4),  $
    imp8yr:lonarr(num_panel,4,10000), imp8dy:lonarr(num_panel,4,10000),$
    imp8ms:lonarr(num_panel,4,10000), i8mscount:intarr(num_panel,2),   $
    dn_found:intarr(num_panel,4), dn_size:intarr(num_panel,4),         $
    valsize:intarr(num_panel,4) , dn_type:0L,                          $
    prefer_defscale:lonarr(num_panel,4)  }

case psflag.typeplot of
1:begin     ;time series
    KP.dn_type=0
    case psflag.SorM of
     1:begin   ;single CDF
	 read_time,0,0,stryear,strdoy,stoyear,stodoy
	 for i=0,num_panel-1 do begin
	   for j=0,psflag.num_KP_panel(i)-1 do begin
	      if(j gt 0)then begin
		 kp_all,i,3,0,2
		 if(mday.i8_flag(i,j) eq 1)then $
		    i8_check,i,3,0,2,i,j,0,0
	      endif else begin
		 kp_all,i,2,0,2
		 if(mday.i8_flag(i,j) eq 1)then $
		     i8_check,i,2,0,2,i,j,0,0
	      endelse
	      pass,i,j
	      if(KP.dn_found(i,j) eq 1)then begin
		 dn_check,i,j,0,0,0,2
		 if(j gt 0)then   KP.KPval_dn(i,3,*)=KP.KPval_dn(0,2,*)
		 if(j eq 0)then   KP.KPval_dn(i,2,*)=KP.KPval_dn(0,2,*)
	      endif
	   endfor
	 endfor
       end
     2:begin    ; single CDF/panel & multi CDF's/plot
	 for i=0,num_panel-1 do begin
	   read_time,i,0,stryear,strdoy,stoyear,stodoy
	   for j=0,psflag.num_KP_panel(i)-1 do begin
	     if(j gt 0)then begin
	       kp_all,i,3,i,2
	       if(mday.i8_flag(i,j) eq 1)then $
		   i8_check,i,3,i,2,i,j,i,0
	     endif 
	     pass,i,j
	     if(KP.dn_found(i,j) eq 1)then begin
		 dn_check,i,j,i,0,i,2
		 if(j gt 0)then   KP.KPval_dn(i,3,*)=KP.KPval_dn(i,2,*)
		 if(j eq 0)then   KP.KPval_dn(i,2,*)=KP.KPval_dn(i,2,*)
	     endif
	   endfor
	 endfor
       end
     3:begin     ; multi CDF's
	 for i=0,num_panel-1 do begin
	   for j=0,psflag.num_KP_panel(i)-1 do begin
	     read_time,i,j,stryear,strdoy,stoyear,stodoy
	     pass,i,j
	     if(KP.dn_found(i,j) eq 1)then dn_check,i,j,i,j,i,j+2
	   endfor
	 endfor
       end
    endcase
  end
2:begin     ;variable-variable
    KP.dn_type=1
    case psflag.SorM of
     3: badnews,'This case is not allowed!'
     else:begin  ; valid for both cases of single CDF and
		 ; single CDF/panel & multi CDF's/plot
	    for i=0,num_panel-1 do begin
	       if(mday.i8_flag(i,0) eq 1)then begin
		  read_time,i,0,stryear,strdoy,stoyear,stodoy
		  for j=0,psflag.num_KP_panel(i)-1 do begin
		      if(j gt 0)then begin
			 if(mday.i8_flag(i,j) eq 1)then $
			   i8_check,i,3,i,2,i,j,i,0
		      endif
		      pass,i,j
		  endfor
		  pass,i,2
		  for j=0,psflag.num_KP_panel(i)-1 do begin
		      if(j gt 0)then kp_all,i,3,i,2
		  endfor
	       endif else begin
		  pass,i,2
		  for j=0,psflag.num_KP_panel(i)-1 do begin
		     pass,i,j
		     if(j gt 0)then kp_all,i,3,i,2
		  endfor
	       endelse
	    endfor
	  end
     endcase
  end
endcase

end

pro testpea
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common peabloc,id,num_dims,dim_sizes,encoding,majority,max_rec,num_vars,$
	num_attrs
common cdfbloc,cdf,anycdf2,KP

cdf={id:lonarr(num_panel,3), num_dims:lonarr(num_panel,3),    $
     dim_sizes:lonarr(num_panel,3,10), max_rec:lonarr(num_panel,3),  $
     encoding:strarr(num_panel,3), majority:strarr(num_panel,3),     $
     num_vars:lonarr(num_panel,3), num_attrs:lonarr(num_panel,3),    $
     KPcount:lonarr(num_panel,3), KPlist:strarr(num_panel,3,500),    $
     KPvar_list:strarr(num_panel,3,500),d:lonarr(num_panel,3,500,10),$
     KPvar_index:lonarr(num_panel,3,500),KPdata_type:strarr(num_panel,3,500),$
     time_var:strarr(num_panel,3) } 

case psflag.typeplot of
 1:begin
     case psflag.SorM of
      1:begin
	  pea,cdf_selection(0,0)
	  for i=0,num_panel-1 do begin
	  for j=0,psflag.num_KP_panel(i)-1 do peasoup,i,j
	  endfor
	end
      2:begin
	  for i=0,num_panel-1 do begin
	    pea,cdf_selection(i,0)
	    for j=0,psflag.num_KP_panel(i)-1 do peasoup,i,j
	  endfor
	end
      3:begin
	  for i=0,num_panel-1 do begin
	    for j=0,psflag.num_KP_panel(i)-1 do begin
	      pea,cdf_selection(i,j)
	      peasoup,i,j
	    endfor
	  endfor
	end
     endcase
   end
 2:begin
     case psflag.SorM of
      1:begin
	  pea,cdf_selection(0,0)
	  for i=0,num_panel-1 do begin
	    for j=0,psflag.num_KP_panel(i)-1 do peasoup,i,j
	    peasoup,i,2
	  endfor
	end
      2:begin
	  for i=0,num_panel-1 do begin
	    pea,cdf_selection(i,0)
	    for j=0,psflag.num_KP_panel(i)-1 do peasoup,i,j
	    peasoup,i,2
	  endfor
	end
      3:badnews,'This case is not allowed'
     endcase
   end
endcase
end


pro find_md,yr,dy,m,d
ydays=[0,31,59,90,120,151,181,212,243,273,304,334,366]
if(((yr mod 4) eq 0) and ((yr mod 100) ne 0)) or ((yr mod 400) eq 0) then $
	ydays(2)=ydays(2:*)+1
for i=1,12 do if dy le ydays(i) then goto, next
m=-1
d=-1
return
next:m=i
     d=dy-ydays(m-1)
return
end

pro happy_event,eventhappy
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common cdfbloc,cdf,anycdf2,KP
common xxx,cdf_KPselect,butval2, axslide,deghappy, happyindex

type=tag_names(eventhappy,/structure)
widget_control,eventhappy.id,get_uvalue=uval
case uval of
77: widget_control,eventhappy.top,/destroy
88: widget_control,eventhappy.top,/destroy
else: begin
	case 1 of
	(uval lt 100): begin
			iold=uval/30
			i=iold-1
			j=uval-iold*30-1
			if(uval lt 30)then degha=deghappy-deghappy $
			   else degha=deghappy-deghappy+1
			poflag.lineorsym(happyindex-1,degha)=(uval mod 30)-1
	   
			case 1 of
			(j ge 0) and (j le 5): begin
			   poflag.line(happyindex-1,degha)=1
			   poflag.line_val(happyindex-1,degha)=butval2(j)
			   poflag.symbol_val(happyindex-1,degha)=0
			   poflag.symbol(happyindex-1,degha)=0
			  end
			(j ge 6) and (j le 19): begin
			   poflag.symbol(happyindex-1,degha)=1
			   poflag.symbol_val(happyindex-1,degha)=butval2(j)
			   poflag.line(happyindex-1,degha)=0
			  end
			endcase
		      end
      (uval gt 100) and (uval lt 200):poflag.xyscale(happyindex-1)=uval mod 100 
      else:begin      
		iold=uval/200
		i=iold-1
		j=uval-iold*200-1
		widget_control,axslide(i,j),get_value=xymajmin
		case i of
		0:begin
		   case j of
		     0: poflag.xmajor(happyindex-1)=xymajmin
		     1: poflag.xminor(happyindex-1)=xymajmin
		   endcase
		  end
		1:begin
		   case j of
		     0: poflag.ymajor(happyindex-1)=xymajmin
		     1: poflag.yminor(happyindex-1)=xymajmin
		   endcase
		  end
		endcase
	     end
       endcase
    end
endcase
end
 
pro happy,happy_index,deg_happy

common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common xxx,cdf_KPselect,butval2, axslide,deghappy, happyindex
common cdfbloc,cdf,anycdf2,KP
common sysbloc,sys_def

deghappy=deg_happy
happyindex=happy_index
butval=['solid             (line)',   $
	'dotted            (line)',   $
	'dashed            (line)',   $
	'dash dot          (line)',   $
	'dash dot dot dot  (line)',   $
	'long dashes       (line)',   $
	'plus sign         (symbol)', $
	'asterisk          (symbol)', $
	'period            (symbol)', $
	'diamond           (symbol)', $
	'triangle          (symbol)',$
	'square            (symbol)',$
	'x                 (symbol)',$
	'plus sign         (symbol + line)',$
	'asterisk          (symbol + line)',$
	'period            (symbol + line)',  $
	'diamond           (symbol + line)',$
	'triangle          (symbol + line)',$
	'square            (symbol + line)',$
	'x                 (symbol + line)'      $
	 ]
butval2=[0,1,2,3,4,5,1,2,3,4,5,6,7,-1,-2,-3,-4,-5,-6,-7]
axisbutval=['LINEAR x-axis - LINEAR y-axis',    $
	    'LINEAR x-axis - LOG    y-axis',    $
	    'LOG    x-axis - LINEAR y-axis',    $
	    'LOG    x-axis - LOG    y-axis']
base2=lonarr(2)
label2=base2 & base3=base2 & label20=base2 & base21=base2 
axisbut=lonarr(4) & axslide=lonarr(2,2) & but=lonarr(2,22)

;device,get_screen_size=screensize

base_happy=widget_base(/column,title='Graphics Settings for Panel '+ $
	      strcompress(string(happy_index),/remove_all),          $
              xoffset=sys_def.xsubwin(2),yoffset=sys_def.ysubwin(2)) 
base01=widget_base(base_happy,/row)
okbut=widget_button(base01,value='  OK  ',uvalue=88,font=sys_def.fontname)
cancelbut=widget_button(base01,value='Cancel',uvalue=77,font=sys_def.fontname)
base02=widget_base(base_happy,/row)
base1=widget_base(base02,/column,/frame)
label1=widget_label(base1,value='Plot Style',font=sys_def.fontname)
base11=widget_base(base1,/row,space=15)
for i=0,deg_happy-1 do begin
  base2(i)=widget_base(base11,/column,space=15) 
  label2(i)=widget_label(base2(i),value='<< Key Parameter '+ $
	     strcompress( string(i+1),/remove_all)+' >>',font=sys_def.fontname)
  base3(i)=widget_base(base2(i),/column,/exclusive,/frame)
 for j=0,19 do but(i,j)=widget_button(base3(i),value=butval(j),   $
				      uval=30*i+j+1 , font=sys_def.fontname )
endfor
base10=widget_base(base02,/column)
base11=widget_base(base10,/column,/frame)
label11=widget_label(base11,value='Axis Scaling',font=sys_def.fontname )
base12=widget_base(base11,/exclusive,/frame)
for i=0,3 do axisbut(i)=widget_button(base12,value=axisbutval(i),   $
				      uvalue=i+101, font=sys_def.fontname )
base20=widget_base(base10,/column,/frame,space=10)
axislabel=['X - Axis','Y - Axis']
majorORminor=['major','minor']
for i=0,1 do begin
 label20(i)=widget_label(base20,value=axislabel(i),font=sys_def.fontname )
 base21(i)=widget_base(base20,/column,/frame)
 for j=0,1 do axslide(i,j)=widget_slider(base21(i),title='number of '+   $
		majorORminor(j)+' tick intervals',minimum=1,maximum=20,  $
		uvalue=(i+1)*200+j+1, font=sys_def.fontname )
endfor

widget_control,/realize,base_happy
xmanager,"happy",base_happy,group_leader=sys_def.leader

for i=0,1 do begin
   for j=0,1 do begin
      case i of 
       0:begin
	   case j of 
	     0: xymajmin=poflag.xmajor(happy_index-1)
	     1: xymajmin=poflag.xminor(happy_index-1)
	   endcase
	 end
       1:begin
	   case j of 
	     0: xymajmin=poflag.ymajor(happy_index-1)
	     1: xymajmin=poflag.yminor(happy_index-1)
	   endcase
	 end
      endcase
      widget_control,axslide(i,j),set_value=xymajmin
   endfor
endfor

if poflag.xyscale(happy_index-1) eq 1 then   $
   widget_control,axisbut(0),/set_button,get_uvalue=but_val $
else widget_control,axisbut(poflag.xyscale(happy_index-1)-1),/set_button,  $
		    get_uvalue=but_val
poflag.xyscale(happy_index-1)=but_val mod 100

for i=0,deg_happy-1 do begin
  if poflag.lineorsym(happy_index-1,i) eq 99 then begin
     case i of
      0: j=8
      1: j=10
     endcase
     widget_control,but(i,j),/set_button,get_uvalue=but_val
  endif else widget_control,but(i,poflag.lineorsym(happy_index-1,i)), $
			   /set_button, get_uvalue=but_val
  poflag.lineorsym(happy_index-1,i)=(but_val mod 30)-1
endfor

end

function getme,index,uval,i,j,listvalue2
iold=uval/10
i=iold-1
j=uval-iold*10-1
choice=listvalue2(i,j,index)
return,choice
end

pro plotset_event,eventplotset
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common cdfbloc,cdf,anycdf2,KP
common some,i8day_text1,i8day_text2
common sysbloc,sys_def


type=tag_names(eventplotset,/structure)
widget_control,eventplotset.id,get_uvalue=uval
case 1 of
(uval eq 1): begin
              mday.init=0
              for i=0,num_panel-1 do begin
               for j=0,psflag.num_KP_panel(i)-1 do begin
                  if mday.i8_flag(i,j) eq 1 then begin
	            widget_control,i8day_text1(i,j),get_value=seedoy
                    mday.i8day(i,j)=seedoy
	            widget_control,i8day_text2(i,j),get_value=seeyear
                    mday.i8year(i,j)=seeyear
                  endif
               endfor
              endfor
	      widget_control,eventplotset.top,/destroy
	      erase
	      xyouts,0.5,0.7,'!18It is working.....',charsize=2.0,/normal, $
		     alignment=0.5
	      set_go
	      make_plot
              psflag.plot=1
	     end
(uval eq 2): widget_control,eventplotset.top,/destroy
(uval eq 3): display,'goplot.hlp',sys_def.xsubwin(1),sys_def.ysubwin(1),$
                         font=sys_def.fontname
(uval gt 10) and (uval lt 70):begin
		       iold=uval/10
		       i=iold-1
		       j=uval-iold*10-1
		       yearordoy=uval mod (iold*10)
		       if(yearordoy le 2) then begin
			  widget_control,i8day_text1(i,j),get_value=seedoy
			  mday.i8day(i,j)=seedoy
		       endif else begin
			  widget_control,i8day_text2(i,j),get_value=seeyear
			  mday.i8year(i,j)=seeyear
		       endelse
		       end
else:
endcase

end

pro plotset
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common xxx,cdf_KPselect,butval2, axslide,deghappy, happyindex
common cdfbloc,cdf,anycdf2,KP
common some,i8day_text1,i8day_text2
common sysbloc,sys_def

base2=lonarr(num_panel)
base3=base2 & label3=base2 & plotbut=base2 & base4=base2
base5=lonarr(num_panel,2) & label5a=base5 & label5b=base5 & label5c=base5
label5d=base5 & base6=base5 & i8day_label1=base5 & i8day_text1=base5
i8day_label2=base5 & i8day_text2=base5
butright=lonarr(3)

;device,get_screen_size=screensize
base_plotset=widget_base(/row,title=' Plot ',xoffset=sys_def.xsubwin(0),  $
                         yoffset=sys_def.ysubwin(0)) 
base1=widget_base(base_plotset,/column,/frame,space=5)
for i=0,num_panel-1 do begin
  base2(i)=widget_base(base1,/row)
  base3(i)=widget_base(base2(i),/column)
   label3(i)=widget_label(base3(i),value='Panel '+strcompress(string(i+1),   $
			 /remove_all)+' ',font=sys_def.fontname )
  base4(i)=widget_base(base2(i),/row,/frame)
  for j=0,psflag.num_KP_panel(i)-1 do begin
    base5(i,j)=widget_base(base4(i),/column)
    label5a(i,j)=widget_label(base5(i,j),value='CDF: '+cdf_selection(i,j),  $
			      font=sys_def.fontname )
    if psflag.num_KP_panel(i) gt 1 then label5b_val='Key Parameter '+ $ 
	  strcompress(string(j+1),/remove_all)+': '+cdf_KPselect(i,j) else $
	  label5b_val='Key Parameter: '+ cdf_KPselect(i,j)
    label5b(i,j)=widget_label(base5(i,j),value=label5b_val,  $
                              font=sys_def.fontname)
       
    if mday.i8_flag(i,j) eq 1 then begin 
	labelnothing=widget_label(base5(i,j),value='',font=sys_def.fontname )
	labelnothing=widget_label(base5(i,j),value='',font=sys_def.fontname )
	label5c(i,j)=widget_label(base5(i,j),value=                    $
	 'Start: Day '+strcompress(string(mday.startdoy(i,j)),/remove_all)+ $
	 ' of Year '+strcompress(string(mday.startyear(i,j)),/remove_all)+  $
	 ' ( '+strcompress(string(mday.startyear(i,j)),/remove_all)+'-'+    $
	 strcompress(string(mday.startmonth(i,j)),/remove_all)+'-'+         $
	 strcompress(string(mday.startday(i,j)),/remove_all)+' ) ',  $
         font=sys_def.fontname )
	label5d(i,j)=widget_label(base5(i,j),value=                    $
	 ' Stop: Day '+strcompress(string(mday.stopdoy(i,j)),/remove_all)+  $
	 ' of Year '+strcompress(string(mday.stopyear(i,j)),/remove_all)+  $
	 ' ( '+strcompress(string(mday.stopyear(i,j)),/remove_all)+'-'+    $
	 strcompress(string(mday.stopmonth(i,j)),/remove_all)+'-'+         $
	 strcompress(string(mday.stopday(i,j)),/remove_all)+' ) ',  $
         font=sys_def.fontname )
  ;  if mday.i8_flag(i,j) eq 1 then begin 
	base6(i,j)=widget_base(base5(i,j),/row)
	i8day_label1(i,j)=widget_label(base6(i,j),value='SELECT Day ',  $
				       font=sys_def.fontname )
	i8day_text1(i,j)=widget_text(base6(i,j),xsize=5,/editable,/frame,   $
		      value=' ',uvalue=10*(i+1)+(j+1),font=sys_def.fontname )
	i8day_label2(i,j)=widget_label(base6(i,j),value=' of Year ',  $
				       font=sys_def.fontname)
	i8day_text2(i,j)=widget_text(base6(i,j),xsize=5,/editable,/frame,    $
			 value=' ',uvalue=10*(i+1)+(j+3),font=sys_def.fontname )
       endif
  endfor
endfor

baseright=widget_base(base_plotset,/column,space=15)
butright_val=['  Go!  ',' Cancel ',' Help ']
for k=0,2 do butright(k)=widget_button(baseright,value=butright_val(k),$
			  uvalue=(k+1),/frame,font=sys_def.fontname  )
widget_control,/realize,base_plotset
xmanager,"plotset",base_plotset,group_leader=sys_def.leader

for i=0,num_panel-1 do begin
   for j=0,psflag.num_KP_panel(i)-1 do begin
      if mday.i8_flag(i,j) eq 1 then begin
        if mday.init eq 1 then begin
          widget_control,i8day_text1(i,j),set_value=strcompress(      $
	    string(mday.startdoy(i,j)),/remove_all )
	  widget_control,i8day_text2(i,j),set_value=strcompress(      $
	    string(mday.startyear(i,j)),/remove_all )
	  mday.i8day(i,j)=mday.startdoy(i,j) 
          mday.i8year(i,j)=mday.startyear(i,j)
        endif else begin
          widget_control,i8day_text1(i,j),set_value=strcompress(      $
	    string(mday.i8day(i,j)),/remove_all )
	  widget_control,i8day_text2(i,j),set_value=strcompress(      $
	    string(mday.i8year(i,j)),/remove_all )
        endelse
      endif
   endfor
endfor

end                                             

pro sneezy_event,eventsneezy

common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common peabloc,id,num_dims,dim_sizes,encoding,majority,max_rec,num_vars,$
	   num_attrs
common cdfbloc,cdf,anycdf2,KP
common extra,KPvar_select,KPd_select,KPvarnum_select,KPdtype_select,   $
	     iKPcount_select,Kpdimsiz_select
common xxx,cdf_KPselect,butval2, axslide,deghappy, happyindex


type=tag_names(eventsneezy,/structure)
widget_control,eventsneezy.id,get_uvalue=uval
case uval of 
77: widget_control,eventsneezy.top,/destroy
88: begin
      widget_control,eventsneezy.top,/destroy
      psflag.skp=1
      checkdate=1
      for i=0,num_panel-1 do begin
       for j=0,psflag.num_KP_panel(i)-1 do begin 
	 ;print,'i=',i,'   j=',j,'CDF=',cdf_KPselect(i,j)
	 
	 ; check whether the CDF file is multi-day or not
	 read_time,i,j,CHECKDATE=checkdate,stryear,strdoy,stoyear,stodoy
;print,'check-date, stryear:',stryear,'  strdoy:',strdoy
	 find_md,stryear,strdoy,strmonth,strday
	 find_md,stoyear,stodoy,stomonth,stoday

	 mday.startyear(i,j)=stryear
	 mday.startdoy(i,j)=strdoy      ; day of year
	 mday.startmonth(i,j)=strmonth
	 mday.startday(i,j)=strday
	 mday.stopyear(i,j)=stoyear
	 mday.stopdoy(i,j)=stodoy       ; day of year
	 mday.stopmonth(i,j)=stomonth
	 mday.stopday(i,j)=stoday
       endfor
      endfor 
      checkdate=0
      ; set_go
    end
else:begin
       cdf_KPselect(i,j)=getme(eventsneezy.index,uval,i,j,cdf.KPlist)
       KPvar_select(i,j)=cdf.KPvar_list(i,j,eventsneezy.index)
       KPd_select(i,j,0:cdf.num_dims(i,j)-1)=     $
	      cdf.d(i,j,eventsneezy.index,0:cdf.num_dims(i,j)-1)
       KPvarnum_select(i,j)=cdf.KPvar_index(i,j,eventsneezy.index)
       KPdtype_select(i,j)=cdf.KPdata_type(i,j,eventsneezy.index)
       KPdimsiz_select(i,j,0:cdf.num_dims(i,j)-1)=  $
	      cdf.dim_sizes(i,j,0:cdf.num_dims(i,j)-1)
       iKPcount_select(i,j)=eventsneezy.index
       ;print,'i=',i,'   j=',j,'   cdf_KPselect=',cdf_KPselect(i,j)
       ;print,'KP_var_select=',KPvar_select(i,j)
       ;print,'KPd_select=',KPd_select(i,j,0:cdf.num_dims(i,j)-1)
       ;print,'KPvarnum=',KPvarnum_select(i,j)
       ;print,'KPdatatype=',KPdtype_select(i,j)
       ;print,'iKPcount=',iKPcount_select(i,j)
     end
endcase

end

pro sneezy

common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common cdfbloc,cdf,anycdf2,KP
common extra,KPvar_select,KPd_select,KPvarnum_select,KPdtype_select,   $
	     iKPcount_select,KPdimsiz_select
common xxx,cdf_KPselect,butval2, axslide,deghappy, happyindex
common sysbloc,sys_def

cdf_KPselect=strarr(num_panel,3)
KPvar_select=cdf_KPselect & KPd_select=intarr(num_panel,3,10)
KPvarnum_select=intarr(num_panel,3) & KPdtype_select=strarr(num_panel,3)
iKPcount_select=intarr(num_panel,3)
KPdimsiz_select=intarr(num_panel,3,10)

mday={ i8day:lonarr(num_panel,2), i8year:lonarr(num_panel,2),        $
       i8_flag:lonarr(num_panel,2), startyear:lonarr(num_panel,2),   $
       startdoy:lonarr(num_panel,2), startmonth:lonarr(num_panel,2), $
       startday:lonarr(num_panel,2), stopyear:lonarr(num_panel,2),   $
       stopdoy:lonarr(num_panel,2), stopmonth:lonarr(num_panel,2),   $
       stopday:lonarr(num_panel,2), init:0L  }

mday.init=1
case psflag.typeplot of
 1: bartitle='Select ISTP Key Parameters for Time Series Plot'
 2: bartitle='Select ISTP Key Parameters'+                  $
			    ' for Variable-Variable Plot'
endcase
;device,get_screen_size=screensize
base_sneezy=widget_base(/row,title=bartitle,xoffset=sys_def.xsubwin(1),   $
                       yoffset=sys_def.ysubwin(1))

base11=lonarr(num_panel)
label1=base11 & base2=base11 & xlabel2=base11 & xlist5=base11
label2=lonarr(num_panel,2) 
list5=label2 & label33=label2
list=0L

base01=widget_base(base_sneezy,/column)
mes0=widget_label(base01,value='',font=sys_def.fontname)
mes=widget_label(base01,value='   Listings of Key Parameters   ',   $
		 font=sys_def.fontname)

base00=widget_base(base01,/column,/frame)
for i=0,num_panel-1 do begin
    base11(i)=widget_base(base00,/column)
    if( psflag.SorM eq 3) then begin 
      if psflag.num_KP_panel(i) gt 1 then begin
	label33(i,0)=widget_label(base11(i),value='Panel '+strcompress( $
			   string(i+1),/remove_all)+' :  <<  CDF '+     $
			   '(Key Parameter 1):'+cdf_selection(i,0)+'  >>', $
			   font=sys_def.fontname)
	label33(i,1)=widget_label(base11(i),value='           <<  CDF '+  $
			   '(Key Parameter 2):'+cdf_selection(i,1)+'  >>', $
			   font=sys_def.fontname)
      endif else  $
	label33(i,0)=widget_label(base11(i),value='Panel '+strcompress( $
			   string(i+1),/remove_all)+' :  <<  CDF '+     $
			   '(Key Parameter):'+cdf_selection(i,0)+'  >>',  $
			   font=sys_def.fontname)
	
		    

    endif else begin
      label1(i)=widget_label(base11(i),value='Panel '+strcompress( $
	string(i+1),/remove_all)+' :   <<  CDF:  '+cdf_selection(i,0)+$
		      '  >>',font=sys_def.fontname )
    endelse
    base2(i)=widget_base(base11(i),/row,space=10,/frame)
    if(psflag.typeplot eq 2)then begin
	 xlabel2(i)=widget_label(base2(i),value='   Variable X',  $
                                  font=sys_def.fontname)
	 j=0
	 xlist5(i)=widget_list(base2(i),uvalue=10*(i+1)+3,/frame, $
			  value=cdf.KPlist(i,2,0:cdf.KPcount(i,j)-1),ysize=4, $
			  font=sys_def.fontname)
    endif

    for j=0,psflag.num_KP_panel(i)-1 do begin
	 case psflag.typeplot of
	   1: label2(i,j)=widget_label(base2(i),value='   Key Parameter '+$
			  strcompress(string(j+1),/remove_all),   $
                          font=sys_def.fontname )
	   2: label2(i,j)=widget_label(base2(i),value='   Variable Y'+$
			  strcompress(string(j+1),/remove_all),   $
                          font=sys_def.fontname)  
	 endcase
	 list5(i,j)=widget_list(base2(i),uvalue=10*(i+1)+j+1,/frame, $
	              value=cdf.KPlist(i,j,0:cdf.KPcount(i,j)-1),ysize=4,    $
                      font=sys_def.fontname)
    endfor
endfor
base1=widget_base(base_sneezy,/column,space=15)
okbutton=widget_button(base1,value='  OK  ',uvalue=88,font=sys_def.fontname) 
cancelbut=widget_button(base1,value='Cancel',uvalue=77,font=sys_def.fontname)
widget_control,base_sneezy,/realize
xmanager,"sneezy",base_sneezy,group_leader=sys_def.leader,/MODAL

end

pro bashful_event,eventbashful

common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common wgbloc,s2text,r1text,m2but,cdfplate,mm_lcol3,mb_lcol3
common plate,cdfplate_val,plateheader
common listv,file_list,flag_lpr,flag_cdftext,CDF_text,flag_cdf,flag_KP,  $
             sktfile,sfdfile,file_ext
common sysbloc,sys_def

type=tag_names(eventbashful,/structure)
widget_control,eventbashful.id,get_uvalue=uval
case uval of 
;    99: badnews,'*********** To be implemented *************'
    99: display,'seldata.hlp',sys_def.xsubwin(1),sys_def.ysubwin(1),$
                    font=sys_def.fontname
    77: widget_control,/destroy,eventbashful.top
    88: begin
          psflag.scdf=1
	  widget_control,/destroy,eventbashful.top
	end
  else: begin
	  iold=uval/10
	  i=iold-1
	  j=uval-iold*10-1

          getpath
      ; if uval mod (iold*10) lt 3 then begin
	  if flag_cdf ne 0 then filename=cdf_selection(i,j) else filename=''
	  cdf1_selection=pickfile(title=pdtitle,path=startpath,file=filename, $
				      filter=filterspec)
	  cdf1_selection=strcompress(cdf1_selection,/remove_all)
	  ;print,'filetrspec=',filterspec
	  ;print,'cdf_selection:',cdf_selection(i,j)
	  yesfile=where(cdf1_selection ne '',count)
	  if count ne 0 then begin
             cdf_selection(i,j)=cdf1_selection 
	     if psflag.SorM eq 2 then begin    
	        if psflag.num_KP_panel(i) gt 1 then    $
                    cdf_selection(i,1)=cdf_selection(i,j)
	        plateheader='CDF : '
	     endif else plateheader='CDF '+strcompress(string(j+1), $
				 /remove_all)+' : '
	     cdfplate_val(i,j)=cdf_selection(i,j)
	     widget_control,cdfplate(i,j),set_value=plateheader+cdfplate_val(i,j)
          endif else begin 
	     badnews,'   *****   No New CDF/File selected.   *****   '
          endelse
      ; endif else begin
      ;   getpath
      ; endelse

	end
endcase
end

pro bashful

common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common wgbloc,s2text,r1text,m2but,cdfplate,mm_lcol3,mb_lcol3
common plate,cdfplate_val,plateheader
common sysbloc,sys_def
common listv,file_list,flag_lpr,flag_cdftext,CDF_text,flag_cdf,flag_KP,  $
             sktfile,sfdfile,file_ext

case psflag.SorM of
1:begin
     if flag_cdf ne 0 then filename=cdf_selection(0,0)    $
                                 else filename=''
     cdf1_selection=pickfile(title=pdtitle,path=startpath,   $
                             filter=filterspec,file=filename) 
     flag_cdf=1
     ;print,'cdf1_selection=',cdf1_selection
     yesfile=where(cdf1_selection ne '',count)
     if count ne 0 then begin
        psflag.scdf=1
        for i=0,num_panel-1   do begin
           for j=0,psflag.num_KP_panel(i)-1 do $
                            cdf_selection(i,j)=cdf1_selection
        endfor
     endif else badnews,'*****   No CDF/File selected.   *****'
  end
else:begin
      list=0L         
      sub_base1=lonarr(num_panel)
      sub_label1=lonarr(num_panel)
      cdfbutton=lonarr(num_panel,2)
      pathbutton=lonarr(num_panel,2)
      cdfplate=lonarr(num_panel,2)
      subbase21=lonarr(num_panel)
	 
      base_bashful=widget_base(/column,title="Select ISTP CDF File(s)",$
	       space=15, xoffset=sys_def.xsubwin(1),yoffset=sys_def.ysubwin(1) )
      base1=widget_base(base_bashful,/row,space=15)
      okbutton=widget_button(base1,value='  OK  ',uvalue=88,    $
                             font=sys_def.fontname)
      cancelbut=widget_button(base1,value='Cancel',uvalue=77,   $
                             font=sys_def.fontname)
      helpbut=widget_button(base1,value='Help',uvalue=99,font=sys_def.fontname)

      base2=widget_base(base_bashful,/column)
      alabel=widget_label(base2,value='<<  Press button(s) to '+    $
			     'select CDF file(s)  >>',font=sys_def.fontname)
      subbase2=widget_base(base2,/column,space=15,/frame)
      for i=0,num_panel-1 do begin
         subbase21(i)=widget_base(subbase2,/column,/frame)
         sub_base1(i)=widget_base(subbase21(i),/row,space=15)
         sub_label1(i)=widget_label(sub_base1(i),value='Panel '+    $
	  strcompress(string(i+1),/remove_all),font=sys_def.fontname  )
         j=0
         while(j le psflag.num_KP_panel(i)-1)do begin
           if psflag.SorM eq 2 then cdfbutton_val=' CDF '  else        $
	     cdfbutton_val=' CDF '+ strcompress(string(j+1),/remove_all)+' '
           pathbutton_val=cdfbutton_val+' Path...  '
           cdfbutton(i,j)=widget_button(sub_base1(i),value=cdfbutton_val, $
				  uvalue=10*(i+1)+j+1,font=sys_def.fontname )
      ;    pathbutton(i,j)=widget_button(sub_base1(i),value=pathbutton_val, $
      ;                           uvalue=10*(i+1)+j+3,font=sys_def.fontname)
           case psflag.SorM of
        	2:j=j+3
        	3:j=j+1
           else:
           endcase
         endwhile
         for k=0,psflag.num_KP_panel(i)-1 do begin  
           cdfplate(i,k)=widget_label(subbase21(i),   $
			     value=cdfplate_val(i,k),font=sys_def.fontname)
           if psflag.SorM eq 2 then k=4
         endfor
      endfor
      widget_control,base_bashful,/realize
      xmanager,"bashful",base_bashful,group_leader=sys_def.leader,/MODAL
    end
endcase
 
end

pro getpath_event,eventgp
common fillbloc,fillpath,fillext
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length

widget_control,eventgp.id, get_uvalue=uval
case uval of
1: begin
     widget_control,fillpath,get_value=fillpath_val
     widget_control,fillext,get_value=fillext_val
     startpath=fillpath_val(0)
     filterspec=fillext_val(0)
     ;print,startpath,filterspec 
     widget_control,eventgp.top,/destroy
   end
2: begin
     ;print,startpath,filterspec 
     widget_control,eventgp.top,/destroy
   end
3: badnews,'************* To be implemented. *****************'
11:begin
     widget_control,fillpath,get_value=fillpath_val
     startpath=fillpath_val(0)
     ;print,startpath
   end
22:begin
     widget_control,fillext,get_value=fillext_val
     filterspec=fillext_val(0)
     ;print,filterspec
   end
else:
endcase

end

pro getpath
common fillbloc,fillpath,fillext
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common sysbloc,sys_def

base=widget_base(title='Select a File Path and File Filter to Start with !', $
                 /column,xoffset=sys_def.xsubwin(2),yoffset=sys_def.ysubwin(2))
base1=widget_base(base,/frame,/column)
base11=widget_base(base1,/row)
text1=widget_label(base11, value='File Path:      ',font=sys_def.fontname)
fillpath=widget_text(base11,value=startpath,uvalue=11,xsize=50,/frame,   $
                     font=sys_def.fontname,/editable)
base22=widget_base(base1,/row)
text21=widget_label(base22,value='File Filter:    ',font=sys_def.fontname)
fillext=widget_text(base22,value=filterspec,uvalue=22,xsize=50,/frame,  $
                    font=sys_def.fontname,/editable)
base2=widget_base(base,/row,space=15)
butval=['   OK   ','  Cancel  ','  Help  ']
but=lonarr(3)
for i=0,2 do but(i)=widget_button(base2,value=butval(i),uvalue=i+1,   $
                                  font=sys_def.fontname)
widget_control,base,/realize
xmanager,"getpath",base,group_leader=sys_def.leader,/MODAL

end

pro sleepy_event,eventsleepy
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common but,sub_button

KP_per_panel=' '
widget_control,eventsleepy.id,get_uvalue=uval
case uval of
 77: widget_control,/destroy,eventsleepy.top
 88 : begin
	widget_control,/destroy,eventsleepy.top
	for i=0,num_panel-1 do                                  $
	  if psflag.num_KP_panel(i) ne psflag.oldnum_KP_panel(i) then         $
	     psflag.numKPpanel=1 else psflag.numKPpanel=0
      end
 else: begin
	 iold=uval/10
	 i=iold-1
	 j=uval-iold*10-1
	 widget_control,sub_button(i,j),get_value=KP_per_panel
	 psflag.num_KP_panel(i)=fix(KP_per_panel)
       end
endcase
end
   
pro sleepy

common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common but,sub_button
common sysbloc,sys_def
common listv,file_list,flag_lpr,flag_cdftext,CDF_text,flag_cdf,flag_KP,  $
             sktfile,sfdfile,file_ext

base_sleepy=widget_base(/column,/frame,xsize=450,xoffset=sys_def.xsubwin(1), $
                        yoffset=sys_def.ysubwin(1),                          $
	                title='Select Number of key Parameter per panel')
bed1=widget_base(base_sleepy,/row)
bed2=widget_base(base_sleepy,/column,/frame)
okbutton=widget_button(bed1,value='  OK  ',uvalue=88,font=sys_def.fontname)
cancelbut=widget_button(bed1,value='Cancel',uvalue=77,font=sys_def.fontname)
label=widget_label(bed2,value='Number of Key Parameters per Panel',  $
		   font=sys_def.fontname)
sub_base=lonarr(6)
sub_label=lonarr(6)
sub_button=lonarr(6,2)
tri_base=lonarr(6)
for i=0,num_panel-1 do begin
  sub_base(i)=widget_base(bed2,/row,space=50)
  sub_label(i)=widget_label(sub_base(i),value='Panel '+              $
		   strcompress(string(i+1),/remove_all),font=sys_def.fontname)
  tri_base(i)=widget_base(sub_base(i),/row,/exclusive)
  for j=0,1 do                                                       $ 
     sub_button(i,j)=widget_button(tri_base(i),value=strcompress(    $
		      string(j+1))+'          ',uvalue=10*(i+1)+(j+1) $
		      ,/no_release,font=sys_def.fontname)
endfor
sub_base=sub_base(0:num_panel-1)
sub_label=sub_label(0:num_panel-1)
sub_button=sub_button(0:num_panel-1,*)

widget_control,base_sleepy,/realize
for i=0,num_panel-1 do begin $
   if psflag.sleepy ne 0 then                                        $
     widget_control,sub_button(i,psflag.num_KP_panel(i)-1),/set_button,   $
		    get_value=KP_per_panel                         $
   else                                                            $
     widget_control,sub_button(i,0),/set_button,get_value=KP_per_panel
   psflag.num_KP_panel(i)=fix(KP_per_panel)
   psflag.oldnum_KP_panel(i)=psflag.num_KP_panel(i)
endfor
xmanager,"sleepy",base_sleepy,group_leader=sys_def.leader

end

pro make_skeleton,input_file,output_file

openw,1,output_file
cdfid = cdf_open(input_file)	; Open a CDF file
glob = cdf_inquire( cdfid )	; Find out general info
printf,1,'! Generated by   ISTP Key Parameter Visualization Tool - '+ $
         'version 1.5   '
printf,1,'! @ '+ systime()
printf,1,'   '
printf,1,'*********************************************************************'
printf,1,'*                                                                   *'
printf,1,'*                        SKELETON TABLE                             *'
printf,1,'*                                                                   *'
printf,1,'*********************************************************************'
printf,1,'   '
printf,1,'   '
printf,1,'		CDF	: ',input_file
printf,1,'   '
printf,1,'		Encoding: ',glob.encoding
printf,1,'		Majority: ',glob.majority
printf,1,'		Records : ',glob.maxrec+1
printf,1,'		No. of Variables: ', glob.nvars
printf,1,'		No. of Attributes: ',glob.natts
printf,1,'		No. of Dimension(s): ',glob.ndims
printf,1,'		Dimension Size(s): ',glob.dim
printf,1,'   '
printf,1,'   '
for i=0,glob.natts-1 do begin
    cdf_attinq,cdfid,i,name,scope,maxentry,maxzentry
endfor
print_title = 1

for attr_num = 0,glob.natts-1 do begin
   cdf_attinq, cdfid, attr_num, attname, scope, maxentry
   if ((attname eq 'TEXT') or (attname eq 'MODS')) then begin
      On_IoError, noat
      for i=0,glob.nvars-1 do begin
         cdf_attget,cdfid,attr_num,i,attvalue
         if i eq 0 then printf,1,"'",attname,"' = ",attvalue else $ 
		Printf,1,attvalue
      endfor
      noat:
      printf,1,'   '
   endif else begin
      if scope eq "GLOBAL_SCOPE" then begin
	On_IoError, NoGlobAttr
	cdf_attget, cdfid, attr_num, maxentry, attvalue
	if print_title then begin
	printf,1,''
	printf,1, '--------------<<   Global Attributes   >>----------------'
	printf,1,''
	print_title = 0
	endif
	Printf,1, "'", attname, "' = ", attvalue
        printf,1,'   '
	NoGlobAttr:
      endif
   endelse
endfor

printf,1,''
printf,1, '--------------<<       Variables       >>-----------------'
printf,1,''
for var_num=0,glob.nvars-1 do begin
	info = cdf_varinq(cdfid, var_num)
        printf,1,'    '
	printf,1, FORMAT='( A," (",A," )     Record Variance: ", A)', $
			info.name, info.datatype, info.recvar
	On_IoError, NoAttr
	for attr_num=0,glob.natts-1 do begin
             cdf_attinq, cdfid, attr_num, attname, scope, maxentry
             if scope eq 'VARIABLE_SCOPE' then begin
		cdf_attget, cdfid, attr_num, var_num, attvalue
	        printf,1,"	 '", attname, "' = ", attvalue
             endif
	NoAttr:
	endfor
endfor
cdf_close,cdfid
close,1
end

pro display_event, event

widget_control, get_uvalue = retval, event.id
if(retval EQ "EXIT") then widget_control, event.top, /DESTROY

end

pro display, filename, xoff,yoff, title = title, group = group,  $
	 width=width,	height = height, text = text, font = font

if(not(keyword_set(title))) then title = 'Display File :  '+filename
if(not(keyword_set(height))) then height = 24	
if(not(keyword_set(width))) then width = 80

if(not(keyword_set(text)))then begin
 if !version.os eq 'vms' then begin
      yessfdu=0
      cnt=0
      sfdupos=-1
      while yessfdu ne -1 do begin
         yessfdu=strpos(filename,'SFDU',yessfdu)
         if yessfdu ne -1 then begin
            cnt=cnt+1
            sfdupos=yessfdu
            yessfdu=yessfdu+1
         endif
      endwhile
      if sfdupos eq -1 then begin
         yessfdu=0
         cnt=0
         while yessfdu ne -1 do begin
            yessfdu=strpos(filename,'SFD',yessfdu)
            if yessfdu ne -1 then begin
               cnt=cnt+1
               sfdupos=yessfdu
               yessfdu=yessfdu+1
            endif
         endwhile
         if sfdupos eq -1 then openr,unit,filename,/get_lun,error=i   $
         else openr,unit,filename,/get_lun,error=i,/stream
      endif else openr,unit,filename,/get_lun,error=i,/stream
 endif else openr, unit, filename, /get_lun, error=i	


  if i lt 0 then begin
	a = [ !err_string, ' Can not display ' + filename] 
  endif else begin
	  a = strarr(5000)			
	  i = 0
	  c = ''
	  while not eof(unit) do begin
		readf,unit,c
		a(i) = c
		i = i + 1
		endwhile
	  a = a(0:(i-1)>0) 
	  free_lun, unit			
  endelse
endif else a = text

filebase = widget_base(title = title,/column,space=20,xpad=20,ypad=20, $
                       xoffset=xoff,yoffset=yoff)
filequit = widget_button(filebase,value='Quit',uvalue='EXIT') 

if n_elements(font) gt 0 then $
 filetext = widget_text(filebase, xsize=width,ysize=height,/scroll, $
		 font = font,value=a) else                          $
 filetext = widget_text(filebase,xsize=width,ysize=height,/scroll,value=a)

widget_control, filebase, /REALIZE	
Xmanager, "display",filebase 			

end 

pro checkpos,pos_entry,pos_spec,posval,posval_flag

yespos=0
cnt=0
posval_flag=0
while yespos ne -1 do begin
   yespos=strpos(pos_entry,pos_spec,yespos)
   if yespos ne -1 then begin
      cnt=cnt+1
      posval=yespos
      posval_flag=1
      yespos=yespos+1
   endif
endwhile

end

pro textbook,textcount,i,j
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common wgbloc,s2text,r1text,m2but,cdfplate,mm_lcol3,mb_lcol3
common listv,file_list,flag_lpr,flag_cdftext,CDF_text,flag_cdf,flag_KP,  $
             sktfile,sfdfile,file_ext

cdfbb=cdf_selection(i,j)
cdfbb_len=strlen(cdfbb)

case !version.os of
'vms':begin
        dirdiv=']'
        defdirdiv=':'
        sktdir='sys$login:'
      end
'windows':begin
            dirdiv='\'
            sktdir='c:\'
          end
else:begin
       dirdiv='/'
       sktdir='~'
     end
endcase

defcdfdiv='.'

checkpos,cdfbb,dirdiv,pos,posflag
checkpos,cdfbb,defcdfdiv,rpos,nuflag

if !version.os eq 'vms' then begin
   if posflag ne 1 then begin
      checkpos,cdfbb,defdirdiv,leftpos,nuflag
      cdfname=strmid(cdfbb,leftpos+1,rpos-leftpos-1) 
   endif else cdfname=strmid(cdfbb,pos+1,rpos-pos-1)
endif else cdfname=strmid(cdfbb,pos+1,rpos-pos-1)

if flag_lpr eq 0 then begin
   case flag_cdftext of
   2: begin
        CDF_text='Creating Skeleton Table ...'
        widget_control,mb_lcol3,set_value=CDF_text

        case !version.os of
        'vms': sktfile =sktdir+cdfname+'.SKT' 
        'windows': sktfile=sktdir+cdfname+'.SKT'
        else: sktfile=cdfname+'.skt'
        endcase
        
      ; if !version.os eq 'vms' then begin
      ;    cdfcmd='skeletontable/nolog/skeleton='+sktdir+cdfname+ $
      ;           ' '+cdf_selection(i,j)
      ;    spawn,cdfcmd(0)
      ; endif else                                                $
        make_skeleton,cdf_selection(i,j),sktfile

        file_list(textcount)=findfile(sktfile)
        CDF_text='Completed.'
        widget_control,mb_lcol3,set_value=CDF_text
      end
   else: begin
            cdfname=strmid(cdfbb,0,rpos) 
            file_ext='.sfdu'
            sfdufile=findfile( cdfname + file_ext )
            yesfile=where(sfdufile ne '', count1)
            if count1 eq 0 then  begin        
               file_ext='.SFDU'
               sfdufile=findfile( cdfname + file_ext )
               yesfile=where(sfdufile ne '',count2)
               if count2 eq 0 then begin     
                   file_ext='.sfd'
                   sfdufile=findfile( cdfname + file_ext )
                   yesfile=where(sfdufile ne '',count3)
                   if count3 eq 0 then begin 
                     file_ext='.SFD'
                     sfdufile=findfile( cdfname + file_ext ) 
                     yesfile=where(sfdufile ne '',count4)
                     if count4 eq 0 then begin 
                        CDF_text='Cannot find SFDU file for '+cdf_selection(i,j)
                        widget_control,mb_lcol3,set_value=CDF_text
                     endif
                   endif else file_list(textcount)=sfdufile
               endif else file_list(textcount)=sfdufile
            endif else file_list(textcount)=sfdufile
          end
   endcase
endif else begin
          if ((!version.os eq 'vms') or (!version.os eq 'windows'))then begin $ 
             file_ext='.SKT'
             sktfile=strcompress(sktdir+cdfname+file_ext,/remove_all) 
          endif else begin 
             file_ext='.skt'
             sktfile=strcompress(cdfname+file_ext,/remove_all)
          endelse

          cdfname=strmid(cdfbb,0,rpos)  
          file_ext='.sfdu'
          sfile=findfile( cdfname+file_ext )
          yesfile=where(sfile ne '', count)
          if count eq 0 then  begin        
               file_ext='.SFDU'
               sfile=findfile( cdfname+file_ext )
               yesfile=where(sfile ne '',count)
               if count eq 0 then begin     
                   file_ext='.sfd'
                   sfile=findfile( cdfname+file_ext )
                   yesfile=where(sfile ne '',count)
                   if count eq 0 then begin 
                      file_ext='.SFD'
                      sfile=findfile(cdfname+file_ext)
                      sfdfile=cdfname+file_ext
                   endif else sfdfile=cdfname+file_ext
               endif else sfdfile=cdfname+file_ext
          endif else sfdfile=cdfname+file_ext

endelse

end

pro cdftext

common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common wgbloc,s2text,r1text,m2but,cdfplate,mm_lcol3,mb_lcol3
common listv,file_list,flag_lpr,flag_cdftext,CDF_text,flag_cdf,flag_KP,  $
             sktfile,sfdfile,file_ext

flag_lpr=0
file_list=strarr(50)
CDF_text=' '
widget_control,mb_lcol3,set_value=CDF_text
textcount=0
case psflag.SorM of
1:begin
    textbook,textcount,0,0
  end
    
2:begin
    for i=0,num_panel-1 do begin
       textbook,textcount,i,0
       textcount=textcount+1
    endfor
  end
3:begin
    for i=0,num_panel-1 do begin
      for j=0,psflag.num_KP_panel(i)-1 do begin
	 textbook,textcount,i,j
	 textcount=textcount+1
      endfor
    endfor
  end
endcase
widget_control,mm_lcol3,set_value=file_list

end

pro textout,i,j,filecount,cdffile
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common listv,file_list,flag_lpr,flag_cdftext,CDF_text,flag_cdf,flag_KP,  $
             sktfile,sfdfile,file_ext

for k=0,1 do begin
   if k eq 0 then cdffile(k)=findfile(sktfile) $
             else cdffile(k)=findfile(sfdfile)
   file_list(filecount)=cdffile(k)
   filecount=filecount+1
endfor 
end

pro lprtext
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common wgbloc,s2text,r1text,m2but,cdfplate,mm_lcol3,mb_lcol3
common listv,file_list,flag_lpr,flag_cdftext,CDF_text,flag_cdf,flag_KP,  $
             sktfile,sfdfile,file_ext

file_list=strarr(50)
CDF_text=' '
widget_control,mb_lcol3,set_value=CDF_text
cdffile=strarr(2)
filecount=0
textcount=0
flag_lpr=1

case psflag.SorM of
1:begin
    textbook,textcount,0,0
    textout,0,0,filecount,cdffile
  end
2:begin
     for i=0,num_panel-1 do begin
       textbook,textcount,i,0
       textcount=textcount+1
       textout,i,0,filecount,cdffile
     endfor
  end
3:begin
     for i=0,num_panel-1 do begin
       for j=0,psflag.num_KP_panel(i)-1 do begin
         textbook,textcount,i,j
         textcount=textcount+1
	 textout,i,j,filecount,cdffile
       endfor
     endfor
  end
endcase
file_list=file_list(0:filecount-1)
widget_control,mm_lcol3,set_value=file_list
end

pro badnews_event,eventbadnews
widget_control,get_uvalue=uval,eventbadnews.id
case uval of 
 88: widget_control,eventbadnews.top,/destroy
 else:
endcase
end

pro badnews,news
common sysbloc,sys_def
base=widget_base(/column,/frame,space=40,xoffset=sys_def.xsubwin(0),   $
                 yoffset=sys_def.ysubwin(0),title='Message! ') 
null_label=widget_label(base,value='   ',font=sys_def.fontname)
new_label=widget_label(base,value=news,font=sys_def.fontname)
okbutton=widget_button(base,value='Acknowledged',uvalue=88,  $
                       font=sys_def.fontname)
null_label2=widget_label(base,value='   ',font=sys_def.fontname)
widget_control,base,/realize
xmanager,"badnews",base
end

pro sdata_event,eventsd
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common wgbloc,s2text,r1text,m2but,cdfplate,mm_lcol3,mb_lcol3
common peabloc,id,num_dims,dim_sizes,encoding,majority,max_rec,num_vars,$
	   num_attrs
common cdfbloc,cdf,anycdf2,KP
common listv,file_list,flag_lpr,flag_cdftext,CDF_text,flag_cdf,flag_KP,  $
             sktfile,sfdfile,file_ext
common sysbloc,sys_def
common hlpbloc,help_file,ohtext,help_list
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval

type=tag_names(eventsd,/structure)
widget_control,eventsd.id,get_uvalue=uval
case 1 of
(uval eq 1):begin
              case 1 of
              (psflag.scdf eq 0) and (psflag.skp eq 0):begin 
                       if psflag.sdata eq 0 then psflag.sdata=0 else $
                                                 psflag.sdata=1
                       psflag.scdf=0
                       psflag.skp=0
                       widget_control,eventsd.top,/destroy
                       badnews,' ****** No DATA selected ****** '
                       if psflag.sdata eq 1 then psflag.sdata=0 
                     end
              (psflag.scdf eq 1) and (psflag.skp eq 0): badnews,   $
                    ' ****** Please Select/Check Key Parameters ****** '
              else: begin
                     psflag.sdata=1
                     psflag.scdf=0
                     psflag.skp=0
                     widget_control,eventsd.top,/destroy
                    end
              endcase
            end
(uval eq 2):widget_control,eventsd.top,/destroy
;(uval eq 3):begin
;             help_list=['< About SELECT DATA >', 'SELECT CDF Files(s)',$
;                        'SELECT Key Parameter(s)','SFDU Table(s)',    $
;                        'Skeleton Table(s)','Print','Erase','Search...']
;             help_file=['kp14help.txt','scdf.hlp','skp.hlp','sfdu.hlp',$
;                         'skt.hlp','printsd.hlp','erasesd.hlp']
;             onhelp
;            end
(uval eq 3): display,'seldata.hlp',sys_def.xsubwin(1),sys_def.ysubwin(1),$
                         font=sys_def.fontname
(uval eq 100):begin
		index=eventsd.index
		choice=file_list(index)
	        if(flag_lpr eq 1)then begin
                   sys_def.lpr_text=1
                   hardcopy
	           CDF_text='Now,it is printing the file of '+choice
	           widget_control,mb_lcol3,set_value=CDF_text
                   cmd=lpr_command+' '+choice
	           spawn,cmd(0)
                   sys_def.lpr_text=0
	           flag_lpr=0
	        endif else begin
                   display,choice,sys_def.xsubwin(1),sys_def.ysubwin(1),$
                                font=sys_def.fontname
                endelse
	      end
(uval eq 86): begin      ;select cdf's 
	        flag_cdf=1
                if psflag.SorM eq 1 then begin
                    getpath  
                    bashful
                endif else bashful
	      end
(uval eq 87): begin ;select key parameters 
		if((psflag.num_panel eq 0) or (psflag.SorM eq 0) or $
		  (psflag.typeplot eq 0)  or $
		  (flag_cdf eq 0) )then begin
		      news='Selection Priority Out of Order'
		      badnews,news
		endif else begin
                  if ((psflag.sdata eq 0) and (psflag.scdf eq 0))then $
                    badnews,' ******  Select CDF File First !  ****** '  $
                  else begin
        		  flag_KP=1
        		  testpea
        		  sneezy
                  endelse
		endelse
	      end
(uval ge 50) and (uval lt 60):begin
	     icase=uval mod 50
	     case icase of
	     3: lprtext
	     4: begin
		  CDF_text=' '
		  file_list=' '
		  widget_control,mm_lcol3,set_value=file_list
		  widget_control,mb_lcol3,set_value=CDF_text
		end
             5:begin
                 notfoundfile=pickfile(title='Search a file !',$
                                 path=startpath,filter='*.*')
                 yesfile=where(notfoundfile ne '',count)
                 if count ne 0 then display,notfoundfile , $
                   sys_def.xsubwin(1),sys_def.ysubwin(1), font=sys_def.fontname
               end
	     else:begin
		    flag_cdftext=icase
		    cdftext
		  end
	     endcase        
     end

else:
endcase

end

pro sdata
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common wgbloc,s2text,r1text,m2but,cdfplate,mm_lcol3,mb_lcol3
common peabloc,id,num_dims,dim_sizes,encoding,majority,max_rec,num_vars,$
	   num_attrs
common cdfbloc,cdf ,anycdf2,KP
common listv,file_list,flag_lpr,flag_cdftext,CDF_text,flag_cdf,flag_KP,  $
             sktfile,sfdfile,file_ext
common sysbloc,sys_def 

panelbut=lonarr(6) 

; set up bases 
basesd=widget_base(/column,title='Select Data',space=10,   $
                   xoffset=sys_def.xsubwin(0),yoffset=sys_def.ysubwin(0))
top=widget_base(basesd,/row,space=18)
; left

CDF_text='Have Fun!! '
flag_lpr=0
file_list='         '
lcol3=widget_base(top,/column)
lula=widget_label(lcol3,value='CDF file/Key Parameter Reference Tables ',  $
		  font=sys_def.fontname)
m_lcol3=widget_base(lcol3,/frame,/column)
nu=widget_label(m_lcol3,value='Message:       Select CDF file(s) First !',   $
		font=sys_def.fontname)
mtt_lcol3=widget_base(m_lcol3,/row)
cdfut_val=['SFDU Table(s)','Skeleton Table(s)',' Print ',' Erase ','Search...']
cdfutbut=lonarr(5)
for i=0,4 do cdfutbut(i)=widget_button(mtt_lcol3,value=cdfut_val(i),   $
			  uvalue=50+(i+1),font=sys_def.fontname )
mm_lcol3=widget_list(m_lcol3,value=file_list,uvalue=100,xsize=35,$
		    ysize=8,/frame,font=sys_def.fontname)
nu=widget_label(m_lcol3,value='',font=sys_def.fontname)
nu=widget_label(m_lcol3,value='Messages',font=sys_def.fontname)
mb_lcol3=widget_text(m_lcol3,xsize=47,ysize=4,value=CDF_text,  $
		     font=sys_def.fontname)

; right
rcol3=widget_base(top,/column,space=18)
b21=widget_button(rcol3,uvalue=86,/frame,                $
	 value=' SELECT CDF File(s) ',font=sys_def.fontname)
b22=widget_button(rcol3,uvalue=87,/frame,                $
	 value=' SELECT Key Parameter(s) ',font=sys_def.fontname)

nu=widget_label(rcol3,value='                ',font=sys_def.fontname)
nu=widget_label(rcol3,value='                ',font=sys_def.fontname)
nu=widget_label(rcol3,value='                ',font=sys_def.fontname)
ti_val=['     OK     ','   Cancel   ','    Help    ']
tibut=lonarr(3)
for i=0,2 do tibut(i)=widget_button(rcol3,value=ti_val(i),/frame,uvalue=i+1,$   
				    font=sys_def.fontname)
	   
; end

widget_control,basesd,/realize
xmanager,"sdata",basesd,group_leader=sys_def.leader 

end
 
pro poption_event,eventpo
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common sysbloc,sys_def

type=tag_names(eventpo,/structure)
widget_control,eventpo.id,get_uvalue=uval
case 1 of
(uval eq 1): widget_control,eventpo.top,/destroy 
(uval eq 2): widget_control,eventpo.top,/destroy
;(uval eq 3): badnews,'            To be implemented!          '
(uval eq 3): display,'plotset.hlp',sys_def.xsubwin(1),sys_def.ysubwin(1),$
                         font=sys_def.fontname
(uval ge 100):begin
		 iold=uval/100
		 i=iold-1
		 ;print,'Panel=',i+1,'   KP_panel=',psflag.num_KP_panel(i)
		 happy,i+1,psflag.num_KP_panel(i)
	      end
else:
endcase

end

pro poption
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common sysbloc,sys_def

base2=lonarr(num_panel)
label2=base2 & plotbut=base2 & base4=base2
butright=lonarr(3)

basepo=widget_base(/column,title='Plot Options ',space=15,   $
                  xoffset=sys_def.xsubwin(1),yoffset=sys_def.ysubwin(1))
base1=widget_base(basepo,/column,/frame,space=8)
for i=0,num_panel-1 do begin
  base2(i)=widget_base(base1,/row)
  label2(i)=widget_label(base2(i),value='Panel '+strcompress(string(i+1),   $
			 /remove_all)+' ',font=sys_def.fontname )
  plotbut(i)=widget_button(base2(i),/frame,value=' Plot Options... ',  $
		    uvalue=100*(i+1),font=sys_def.fontname )
endfor

baseright=widget_base(basepo,/row,space=10)
butright_val=['  OK  ',' Cancel ',' Help ']
for k=0,2 do butright(k)=widget_button(baseright,value=butright_val(k),$
			  uvalue=(k+1),/frame,font=sys_def.fontname  )
widget_control,/realize,basepo
xmanager,"poption",basepo,group_leader=sys_def.leader

end

pro saveset_event,eventss
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common wgbloc,s2text,r1text,m2but,cdfplate,mm_lcol3,mb_lcol3
common sysbloc,sys_def

widget_control,eventss.id,get_uvalue=uval
case uval of
11:begin
     widget_control,s2text,get_value=folderinput
     foldername=folderinput(0)
   end
1:begin
    widget_control,s2text,get_value=folderinput
    foldername=folderinput(0)
    save,psflag,rpflag,poflag,num_panel,filename=foldername,/verbose
    widget_control,eventss.top,/destroy
  end
2: widget_control,eventss.top,/destroy
;3: badnews,'      To be implemented.      '
3: display,'plotset.hlp',sys_def.xsubwin(1),sys_def.ysubwin(1),$
                         font=sys_def.fontname
else:
endcase
end

pro saveset
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common wgbloc,s2text,r1text,m2but,cdfplate,mm_lcol3,mb_lcol3
common sysbloc,sys_def

ssbase=widget_base(/column,title='Save All Settings in a SaveSet File',$
               xoffset=sys_def.xsubwin(1),yoffset=sys_def.ysubwin(1),space=15)
s1=widget_base(ssbase,/column,/frame,space=10)
s2=widget_base(s1,/row,space=10)
s22=widget_label(s2,value=" SaveSet File Name (File Specification) : ", $
               font=sys_def.fontname)
s2text=widget_text(s2,/frame,font=sys_def.fontname,value=foldername,   $
                   uvalue=11,xsize=50,/editable)
but_val=['  SAVE   ','   Cancel   ','   HELP   ']
s3=widget_base(ssbase,/row,space=15)
for i=0,2 do ssbut=widget_button(s3,/frame,value=but_val(i),uvalue=i+1,$
                                  font=sys_def.fontname)
widget_control,ssbase,/realize
xmanager,"saveset",ssbase,group_leader=sys_def.leader
end


pro plotsetup_event,eventps

common setting,psflag,rpflag,poflag,mday
common extra,KPvar_select,KPd_select,KPvarnum_select,KPdtype_select, $
	     iKPcount_select,KPdimsiz_select
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common wgbloc,s2text,r1text,m2but,cdfplate,mm_lcol3,mb_lcol3
common listv,file_list,flag_lpr,flag_cdftext,CDF_text,flag_cdf,flag_KP,  $
             sktfile,sfdfile,file_ext
common xxx,cdf_KPselect,butval2, axslide,deghappy, happyindex
common keepwindow,phase1_window,ymargin,xmargin,pcharsize,baselog
common cdfscale,m3but,xyrange
common hlpbloc,help_file,ohtext,help_list
common sysbloc,sys_def

type=tag_names(eventps,/structure)
widget_control,eventps.id,get_uvalue=uval
case 1 of
(uval eq 1):begin  ;ok
              widget_control,r1text,get_value=fontsize
              psflag.pfontsize=float(fontsize(0))
              psflag.flag_pfontsize=1
              widget_control,eventps.top,/destroy
            end
(uval eq 2):widget_control,eventps.top,/destroy
(uval eq 3):begin
              widget_control,r1text,get_value=fontsize
              psflag.pfontsize=float(fontsize(0))
              psflag.flag_pfontsize=1
              saveset
            end
;(uval eq 4):begin    ;help
;              help_list=['< About PLOT SETUP >', 'Types of plots', $
;                         'Number of Panels',                       $
;                         'SELECT Numbers of Key Parameters per Panel ...', $
;                         'SELECT Graphic Settings for Each Panel ...',     $
;                         'Overall FONT size', 'Number of CDF',     $
;                         'X and Y Axis Scales',                    $
;                         'Save all settings to a SaveSet File'  ]
;              help_file=['kpvt14help.txt','ptype.hlp','numpanel.hlp',  $
;                         'numkp.hlp','graset.hlp','overfont.hlp',      $
;                         'numcdf.hlp','xyscale.hlp','savepset.hlp' ]
;              onhelp
;            end
(uval eq 4): display,'plotset.hlp',sys_def.xsubwin(1),sys_def.ysubwin(1),$
                         font=sys_def.fontname
(uval gt 10) and (uval lt 20): begin
				 psflag.oldtypeplot=psflag.typeplot
				 psflag.typeplot=uval mod 10 
				 ; 1:time series, 2:variable-variable
                                 psflag.init=1
			       end

(uval gt 20) and (uval lt 30): begin
	 num_panel=uval mod 20
	 psflag.oldnum_panel=psflag.num_panel
	 psflag.num_panel=num_panel
	 ;
	 psflag.sleepy=0
	 psflag.num_KP_panel(*)=1
	 psflag.oldnum_KP_panel(*)=1
	 psflag.numKPpanel=0
	 ;
	 getfontsize
         psflag.init=1
	 widget_control,r1text,set_value=string(psflag.pfontsize)
      end

(uval gt 30) and (uval lt 40): psflag.SorM = uval mod 30 
		     ; 1:singls cdf, 2:single/multi cdf's, 3:multi cdf's

(uval eq 83): begin ; select number of key parameters per panel
		if(psflag.num_panel eq 0)then begin
		  news='   Selection Priority Out of Order!   '
		  badnews,news
		endif else begin
		  psflag.sleepy=1
		  sleepy
		endelse
                psflag.init=1
	      end
(uval eq 84):poption
(uval eq 61): begin
		psflag.xyrange=1
		widget_control,m3but,sensitive=0
	      end
(uval eq 62): begin
		psflag.xyrange=2
		widget_control,m3but,sensitive=1
	      end
(uval eq 63):begin
	       setscale
               psflag.replot=1
	       replot
	       psflag.init=0
	     end
		
(uval eq 200):begin
		widget_control,r1text,get_value=fontsize
		psflag.pfontsize=float(fontsize(0))
		psflag.flag_pfontsize=1
	      end
else:
endcase
end

pro plotsetup
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common wgbloc,s2text,r1text,m2but,cdfplate,mm_lcol3,mb_lcol3
common listv,file_list,flag_lpr,flag_cdftext,CDF_text,flag_cdf,flag_KP,  $
             sktfile,sfdfile,file_ext
common sysbloc,sys_def
common cdfscale,m3but,xyrange

panelbut=lonarr(6)

; set up bases
case !version.os of
'windows': begin
             xoffps=0
             yoffps=20
           end
else:begin
       xoffps=sys_def.xsubwin(0)
       yoffps=sys_def.ysubwin(0)
     end
endcase
baseps=widget_base(/column,title='Plot Setup',space=15,xoffset=xoffps,   $
                   yoffset=yoffps )
leftmain=widget_base(baseps,/row,/frame)
lcol3=widget_base(leftmain,/column,space=10)
mcol3=widget_base(leftmain,/column,space=10)
rcol3=widget_base(baseps,/row,space=8 )
rbcol3=widget_base(baseps,/row,space=15,/frame )

; left
ext1_lcol3=widget_base(lcol3,/column,/frame)
b1text_lcol3=widget_label(ext1_lcol3,value='Types of plots',   $
                          font=sys_def.fontname)
bl2_lcol3=widget_base(ext1_lcol3,/row,/exclusive)
plottbut_val=[' Time Series   ', ' Variable-Variable   ' ]
plottbut=lonarr(2)
for i=0,1 do plottbut(i)=widget_button(bl2_lcol3,value=plottbut_val(i),   $
			 uvalue=10+(i+1),/no_release,font=sys_def.fontname)

bm_lcol3=widget_base(lcol3,/column,/frame)
bmtext_lcol3=widget_label(bm_lcol3,value='Number of Panels',   $
                          font=sys_def.fontname)
bmb1_lcol3=widget_base(bm_lcol3,/row,/exclusive)
for i=0,5 do panelbut(i)=widget_button(bmb1_lcol3,value=' '+strcompress( $
     string(i+1), /remove_all)+'   ',uvalue=20+(i+1),/no_release,  $
     font=sys_def.fontname)
bb_lcol3=widget_base(lcol3,/column,space=5,/frame)
b18=widget_button(bb_lcol3,uvalue=83,                $
	 value=' SELECT Numbers of Key Parameters per Panel ... ',  $
         font=sys_def.fontname)
b17=widget_button(bb_lcol3,uvalue=84,                $
	 value=' SELECT Graphic Settings for Each Panel ... ',  $
         font=sys_def.fontname)

;middle
m01=widget_base(mcol3,/column,/frame)
m01text=widget_label(m01,value='Number of CDF',font=sys_def.fontname)
m02=widget_base(m01,/column,/exclusive)
cdfsorm=["Single CDF for each Panel and Plot Page",   $
         "Single CDF for each Panel and multi CDF's for Plot Page",   $
	 "Multi CDF's for each Panel and Plot Page"]
cdfsorm_but=lonarr(3)
for i=0,2 do cdfsorm_but(i)=widget_button(m02,value=cdfsorm(i),$
		     uvalue=30+(i+1),/no_release,font=sys_def.fontname)

m1=widget_base(mcol3,/column,/frame)
m1text=widget_label(m1,value='X and Y Axis Scales',font=sys_def.fontname)
m2=widget_base(m1,/column,/exclusive)
xyrange=[" Default values : CDF metadata 'SCALEMIN' and 'SCALEMAX' ", $
	 " User Defined Values  "                    ]
m2but=lonarr(2)
for i=0,1 do m2but(i)=widget_button(m2,value=xyrange(i),/no_release,  $
		     uvalue=60+(i+1),font=sys_def.fontname)
m3but=widget_button(m1,value=' Select/Change User Defined Values ',uvalue=63,$
		    font=sys_def.fontname)
r1=widget_label(rcol3,value='Overall FONT size:',font=sys_def.fontname)
r1text=widget_text(rcol3,value= string(psflag.pfontsize),uvalue=200,/editable, $
		   /frame,xsize=15,font=sys_def.fontname)
ti_val=['      OK      ','    Cancel    ',    $
	' Save all settings to a SaveSet File ', '     Help     ']
tibut=lonarr(4)

for i=0,1 do tibut(i)=widget_button(rbcol3,value=ti_val(i),/frame,uvalue=i+1,$ 
				    font=sys_def.fontname)
nu=widget_label(rbcol3,value='   ',font=sys_def.fontname)
for i=2,3 do tibut(i)=widget_button(rbcol3,value=ti_val(i),/frame,uvalue=i+1,$ 
				    font=sys_def.fontname)

	   
; end
widget_control,baseps,/realize
xmanager,"plotsetup",baseps,group_leader=sys_def.leader 

;preset

;psflag.replot=0
if psflag.num_panel ne 0 then     $
  widget_control,panelbut(psflag.num_panel-1),/set_button,get_uvalue=but_val  $
else  widget_control,panelbut(0),/set_button,get_uvalue=but_val
psflag.num_panel=but_val mod 20
num_panel=psflag.num_panel
psflag.oldnum_panel=psflag.num_panel

if psflag.typeplot ne 0 then $
  widget_control,plottbut(psflag.typeplot-1),/set_button,get_uvalue=but_val   $
else widget_control,plottbut(0),/set_button,get_uvalue=but_val
psflag.typeplot=but_val mod 10  
psflag.oldtypeplot=psflag.typeplot

if psflag.SorM ne 0 then $
  widget_control,cdfsorm_but(psflag.SorM-1),/set_button,get_uvalue=but_val   $
else widget_control,cdfsorm_but(0),/set_button,get_uvalue=but_val
psflag.SorM=but_val mod 30  

if psflag.sleepy eq 0 then begin
  psflag.num_KP_panel(*)=1
  psflag.oldnum_KP_panel(*)=1
endif else   $
  psflag.oldnum_KP_panel(*)=psflag.num_KP_panel(*)   ;reset for comparison
psflag.numKPpanel=0

widget_control,m2but(psflag.xyrange-1),/set_button,get_uvalue=but_val
if psflag.xyrange eq 1 then widget_control,m3but,sensitive=0

if psflag.flag_pfontsize eq 0 then begin
    getfontsize
    widget_control,r1text,set_value=string(psflag.pfontsize)
endif else   widget_control,r1text,set_value=string(psflag.pfontsize)

end

pro setscale
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common listv,file_list,flag_lpr,flag_cdftext,CDF_text,flag_cdf,flag_KP,  $
             sktfile,sfdfile,file_ext

if   psflag.init eq 1  then begin 
   for i=0,num_panel-1 do begin
      if psflag.typeplot eq 1 then begin
	  rpflag.xmin(i,2)=0.0
	  rpflag.xmax(i,2)=24.0
      endif else begin
	  rpflag.xmin(i,2)=1.0
	  rpflag.xmax(i,2)=1000.0
      endelse
   
      rpflag.ymin(i,*)=1.0
      rpflag.ymax(i,*)=1000.0
   endfor
endif

end
 
pro getfontsize
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length

case !version.os of
'windows':begin
	    case num_panel of
	     1: psflag.pfontsize= 1.0
	     2: psflag.pfontsize= 1.0
	     3: psflag.pfontsize= 1.0
	     4: psflag.pfontsize= 1.0
	     5: psflag.pfontsize= 1.0
	     6: psflag.pfontsize= 1.0
	    endcase
	  end
else:begin
       case num_panel of
	 1: psflag.pfontsize= 1.5
	 2: psflag.pfontsize= 1.5
	 3: psflag.pfontsize= 2.0
	 4: psflag.pfontsize= 2.0
	 5: psflag.pfontsize= 1.5
	 6: psflag.pfontsize= 1.5
       endcase
     end
endcase
end

pro output_plot,newfile
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval

device,/close
file='idl.'+STRLOWCASE(!D.NAME)
cmd=lpr_command+' '+file
if n_elements(new_file) gt 0 then cmd=[cmd,'mv '+file+' '+new_file] 
spawn,cmd(0)

end

pro hardcopy_event,eventhc
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval
common sysbloc,sys_def
common hlpbloc,help_file,ohtext,help_list

widget_control,eventhc.id,get_uvalue=uval
case uval of
1:begin  ;ok
    sys_def.printer=1
    if ((sys_def.lpr_plot eq 1) and (sys_def.lpr_text eq 0)) then begin
       set_plot,'ps'
       if otflag eq 1 then device,/portrait else device,/landscape
       widget_control,hc_input,get_value=lpr_command
       widget_control,WH(0),get_value=newval
       WH_val(0)=float(newval)
       device,xsize=WH_val(0)
       widget_control,WH(1),get_value=newval
       WH_val(1)=float(newval)
       device,ysize=WH_val(1)

       if otflag eq 1 then begin
          widget_control,off_LL(0),get_value=newval
          off_LLval(0)=float(newval)
          device,xoffset=off_LLval(0)
          widget_control,off_LL(1),get_value=newval
          off_LLval(1)=float(newval)
          device,yoffset=off_LLval(1)
       endif else begin
          widget_control,off_LL(0),get_value=newval
          off_LLval(0)=float(newval)  ; 27.9 cm is the max length on x
          device,yoffset=27.9-off_LLval(0)
          widget_control,off_LL(1),get_value=newval
          off_LLval(1)=float(newval)  ; 21.0 cm is the max length on y
          device,xoffset=off_LLval(1)
       endelse
       
       widget_control,eventhc.top,/destroy
       make_plot
       output_plot
       case !version.os of
       'windows': set_plot,'win'
       else: set_plot,'x'
       endcase
    endif else begin
       widget_control,hc_input,get_value=lpr_command
       widget_control,eventhc.top,/destroy
    endelse
  end
2:widget_control,eventhc.top,/destroy
;3:begin
;    help_list=['< About PRINT >', 'Print Command','Orientation', $
;               'Plot Output on the Page'  ]
;    help_file=['kp14help.txt','pcommand.hlp','orient.hlp','plotout.hlp'] 
;    onhelp
  ;end
3: display,'seeprint.hlp',sys_def.xsubwin(1),sys_def.ysubwin(1),$
               font=sys_def.fontname
23: begin
       set_plot,'ps'
       device,/portrait
       otflag=1
    end
24: begin
       set_plot,'ps'
       device,/landscape
       otflag=0
    end
22: widget_control,hc_input,get_value=lpr_command
else:
endcase
end

pro hardcopy
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval
common sysbloc,sys_def

if sys_def.printer eq 0 then begin
   case !version.os of
      'windows': lpr_command='print '
      'vms': lpr_command='print  '
     else: lpr_command='lpr -Plephp '
   endcase
endif

hcbase=widget_base(/row,title='Print !', xoffset=sys_def.xsubwin(0),   $
                   yoffset=sys_def.ysubwin(0),space=15)
base1=widget_base(hcbase,/column,/frame)
base11=widget_base(base1,/row)
labelhc=widget_label(base11,value='Print Command ( for printer ): ', $
                     font=sys_def.fontname)
hc_input=widget_text(base11,value=lpr_command,uvalue=22, /editable, $
                     /frame,font=sys_def.fontname)
labelhc2=widget_label(base1,value='',font=sys_def.fontname)
if ((sys_def.lpr_plot eq 1) and (sys_def.lpr_text eq 0)) then begin
   basep=widget_base(base1,/row)
   labelhc3=widget_label(basep,value='Orientation :  ',font=sys_def.fontname)
   base3=widget_base(basep,/exclusive,/row,/frame,space=25)
   hcbut1=widget_button(base3,value=' Portrait ',/no_release,uvalue=23,  $
                        font=sys_def.fontname )
   hcbut2=widget_button(base3,value=' Landscape ',/no_release,uvalue=24, $
                        font=sys_def.fontname )
   labelhc2=widget_label(base1,value='',font=sys_def.fontname)
   labelhc3=widget_label(base1,value='Plot Output on the Page',   $
                        font=sys_def.fontname)

   baseWH=lonarr(2)
   WH_lab1=lonarr(2)
   WH_lab2=lonarr(2)
   WH_labval=['Width  ( x_size ) : ',   $
              'Height ( y_size ) : '  ]
   WH=lonarr(2)

   base5=widget_base(base1,/column,/frame )
   for i=0,1 do begin
    baseWH(i)=widget_base(base5,/row)
    WH_lab1(i)=widget_label(baseWH(i),value=WH_labval(i),font=sys_def.fontname)
    WH(i)=widget_text(baseWH(i),value=string(WH_val(i)),uvalue=40+(i+1),   $
                    /frame,font=sys_def.fontname,/editable)
    WH_lab2(i)=widget_label(baseWH(i),value='Centimeters',font=sys_def.fontname)
   endfor

   labelhc2=widget_label(base1,value='',font=sys_def.fontname)

   off_LLcap=['X position at Lower Left Corner : ',   $
              'Y position at Lower Left Corner : '  ]
   baseLL=lonarr(2)
   lab_LL1=lonarr(2)
   lab_LL2=lonarr(2)
   off_LL=lonarr(2)

   for i=0,1 do begin
    baseLL(i)=widget_base(base5,/row)
    lab_LL1(i)=widget_label(baseLL(i),value=off_LLcap(i),font=sys_def.fontname)
    off_LL(i)=widget_text(baseLL(i),value=string(off_LLval(i)),uvalue=40+(i+3),$
                        /frame,font=sys_def.fontname,/editable) 
    lab_LL2(i)=widget_label(baseLL(i),value='Centimeter(s)',   $
                            font=sys_def.fontname)
   endfor
endif

hcbut_val=['  OK  ',' Cancel ',' Help ']
base4=widget_base(hcbase,/column,space=10)
for i=0,2 do hcbut=widget_button(base4,/frame,value=hcbut_val(i),uvalue=i+1,  $
                                 font=sys_def.fontname)

widget_control,hcbase,/realize
if sys_def.lpr_plot eq 1 then begin
if otflag eq 1 then widget_control,hcbut1,/set_button  $
               else widget_control,hcbut2,/set_button
endif
xmanager,"hardcopy",hcbase,group_leader=sys_def.leader,/MODAL
end

pro onhelp_event,eventoh
common sysbloc,sys_def
common hlpbloc,help_file,ohtext,help_list

type=tag_names(eventoh,/structure)
widget_control,eventoh.id,get_uvalue=uval
flag_lpr=0
case uval of
1: widget_control,eventoh.top,/destroy 
100: begin
        index=eventoh.index
        choice=help_file(index)
    ;    display,choice,sys_def.xsubwin(1),sys_def.ysubwin(1),  $
    ;                   font=sys_def.fontname
	;print,choice
	openr,unit,choice,/get_lun,error=i
	if i lt 0 then begin
	   CDF_text=[!err_string,'Can not display!']
          widget_control,ohtext,set_value=CDF_text
	endif else begin
	   if(flag_lpr eq 1)then begin
	      case !version.os of 
	      'windows': lpr_command='print '+choice
	      'vms': lpr_command='print '+choice
	      else: lpr_command='lpr -Plephp '+choice
	      endcase
	      spawn,lpr_command(0)
	      CDF_text='Now,it is printing the file of '+choice
	      flag_lpr=0
	   endif else begin
	      CDF_text=strarr(5000)
	      i=0
	      c='  '
	      while not eof(unit) do begin
		readf,unit,c
		CDF_text(i)=c
		i=i+1
	      endwhile
	      CDF_text=CDF_text(0:i-1)
	      free_lun,unit
	   endelse
	   widget_control,ohtext,set_value=CDF_text
	 endelse
     end
else:
endcase

end

pro onhelp
common hlpbloc,help_file,ohtext,help_list
common sysbloc,sys_def

help_text='     Welcome you to HELP center !     '
baseoh=widget_base(/column,title='Help !',space=10,xoffset=sys_def.xsubwin(0),$
                   yoffset=sys_def.ysubwin(0) )
base1=widget_base(baseoh,/row,space=15)
butoh=widget_button(base1,value='   Quit   ',uvalue=1,/frame,   $
                                 font=sys_def.fontname)
base2=widget_base(baseoh,/row)
base3=widget_base(base2,/column,/frame)
ohlab=widget_label(base3,value='Topics: ',font=sys_def.fontname)
ohlist=widget_list(base3,value=help_list,uvalue=100,xsize=20,ysize=24,/frame,  $
                                 font=sys_def.fontname)
ohtext=widget_text(base2,value=help_text,xsize=80,ysize=24,/scroll,/frame,  $
                                 font=sys_def.fontname)

widget_control,baseoh,/realize
xmanager,'onhelp',baseoh
end

pro phase3_event,event3
common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel, foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common hlpbloc,help_file,ohtext,help_list
common keepwindow,phase1_window,ymargin,xmargin,pcharsize,baselog
common sysbloc,sys_def

type=tag_names(event3,/structure)
widget_control,event3.id,get_uvalue=uval
sys_def.leader=event3.top
uval2=uval mod 30
case uval2 of
    1 : badnews,' **** Multi-window selection/setup is to be implemented. **** '
    2: begin
           openfolder=pickfile(title='Select a SaveSet File and Open it!', $
                             path=startpath)
           yesfile=where(openfolder ne '',count)
           if count ne 0 then restore,openfolder,/verbose     $
           else badnews,'*****   No File Selected.   *****'
        end
    3: begin
          plotsetup
          psflag.plotsetup=1
        end
    4: begin
          if psflag.plotsetup eq 0 then begin
             psflag.num_panel=1
             num_panel=psflag.num_panel
             psflag.oldnum_panel=psflag.num_panel
             psflag.typeplot=1
             psflag.oldtypeplot=1
             psflag.SorM=1
             psflag.num_KP_panel(*)=1
             psflag.oldnum_KP_panel(*)=1
             psflag.numKPpanel=0
             psflag.xyrange=1
             getfontsize
          endif
          sdata
        end
    5: badnews,' ****** Various system controls are to be implemented. ****** '
    6: badnews,' ****** Various tools are to be implemented/integrated. ****** '
    7: begin ;plot
         if( psflag.sdata  ne 0) then begin
            case !version.os of
            'windows': set_plot,'win'
            else: set_plot,'x'
            endcase
	    print,systime()
	    plotset
         endif else badnews,'******  Select Data First !  ******'
	end
    8: begin   ;hardcopy
         if psflag.plot ne 0 then begin
            sys_def.lpr_plot=1
      	    set_plot,'ps'
            hardcopy       ; set up
            sys_def.lpr_plot=0
         endif else badnews,'******  Make Plot First !  ******'
       end
    9: begin
         help_list=[ '< About KPVT version 1.5 >','WINDOW',      $
                     'RESTORE SaveSet', 'PLOT SETUP',            $
                     'SELECT DATA', 'SYSTEM', 'TOOLS', 'PLOT',   $
                     'PRINT', 'HELP', 'QUIT' ]  
         help_file=[ 'readme.doc', 'nofile.hlp','restore.hlp', $
                     'plotset.hlp', 'seldata.hlp','nofile.hlp',    $
                     'nofile.hlp', 'goplot.hlp','seeprint.hlp',  $
                     'gethelp.hlp',  $
                     'goquit.hlp'  ]
        onhelp
       end
    10: begin   ;done
	  erase
	  !p.title=' '
	  !p.subtitle=' '
	  widget_control,/destroy,event3.top
	  widget_control,baselog,sensitive=1
          ;set_plot,'x'
	  ;wset,phase1_window
	  erase
	  !p.multi=0
	  !y.margin=ymargin
	  !x.margin=xmargin
	  !p.charsize=pcharsize
	  cover
	end
else:
endcase
end

 
pro phase3,group3

common setting,psflag,rpflag,poflag,mday
common setvalue,num_panel, foldername, $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length
common wgbloc,s2text,r1text,m2but,cdfplate,mm_lcol3,mb_lcol3
common peabloc,id,num_dims,dim_sizes,encoding,majority,max_rec,num_vars,$
	   num_attrs
common cdfbloc,cdf,anycdf2,KP
common listv,file_list,flag_lpr,flag_cdftext,CDF_text,flag_cdf,flag_KP,  $
             sktfile,sfdfile,file_ext
common sysbloc,sys_def
common plate,cdfplate_val,plateheader
common xxx,cdf_KPselect,butval2, axslide,deghappy, happyindex
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval

!x.style=1
!y.style=1
!x.margin=[12,8]
!y.margin=[6,3]
!p.charsize=1.25

num_panel=6

psflag={plot:0L, replot:0L, num_panel:0L, oldnum_panel:0L, init:0L, SorM:0L, $
	typeplot:0L, oldtypeplot:0L, sleepy:0L, num_KP_panel:lonarr(num_panel),$
	oldnum_KP_panel:lonarr(num_panel), numKPpanel:0L, xyrange:0L,        $
        flag_pfontsize:0L, pfontsize:1.0 ,plotsetup:0L ,sdata:0L, scdf:0L,   $
        skp:0L  }

psflag.num_panel=0 & psflag.sleepy=0 & psflag.SorM=0 & psflag.typeplot=0
psflag.sdata=0
psflag.scdf=0
psflag.skp=0
psflag.plot=0
psflag.replot=0
psflag.xyrange=1
psflag.pfontsize=1.0
psflag.flag_pfontsize=0
psflag.init=1
psflag.plotsetup=0

rpflag={xmin:dblarr(num_panel,4), xmax:dblarr(num_panel,4),  $
	ymin:dblarr(num_panel,4), ymax:dblarr(num_panel,4) }

poflag={xyscale:lonarr(num_panel),                                $
       lineorsym:lonarr(num_panel,2),                             $
       line: intarr(num_panel,2), line_val:intarr(num_panel,2),   $
       symbol:intarr(num_panel,2), symbol_val:intarr(num_panel,2),$
       xmajor:intarr(num_panel), xminor:intarr(num_panel),             $
       ymajor:intarr(num_panel), yminor:intarr(num_panel)  }

poflag.lineorsym(*,*)=99
poflag.xyscale(*)=1
poflag.xmajor(*)=4 & poflag.xminor(*)=6 
poflag.ymajor(*)=4 & poflag.yminor(*)=6
poflag.symbol(*,*)=1 
poflag.symbol_val(*,0)=3 & poflag.symbol_val(*,1)=5
poflag.line(*,*)=0 & poflag.line_val(*,*)=0

foldername=''
listvalue2=strarr(num_panel,3,500)
flag_cdf=0 & flag_KP=0 
cdf_list=strarr(num_panel,2,100)
num_cdf_select=intarr(num_panel,2)
cdf1_list=strarr(100)
cdf_selection=strarr(num_panel,2)
cdf_length=intarr(num_panel,2)
cdfplate_val=strarr(num_panel,2)
cdfplate_val(*,*)='No CDF selected yet.'

WH_val=[18.5,24.5]
off_LLval=[1.5,1.5]
otflag=1
but3val=[' WINDOW ',' RESTORE SaveSet ',' PLOT SETUP ',' SELECT DATA ',  $
         ' SYSTEM ',' TOOLS ',' PLOT ',' PRINT ',' HELP ',' QUIT ']
case !version.os of
'windows':begin
            startpath='c:\'
            filterspec='*.CDF'
            but3val=[' Windows ',' Restore SaveSet ',' Plot Setup ',   $
                ' Select Data ', ' System ',' Tools ','        Plot         ', $
                '        Print         ',' Help ',' Quit ']
            leftspace=5
          end
'vms':begin
        startpath='sys$login:'
        filterspec='*.CDF'
        leftspace=15
      end
else: begin
        startpath='~'
        filterspec='*.cdf'
        leftspace=15
      end
endcase

; set up bases
case !version.os of
'windows': xoff3=0
else: xoff3=200
endcase
base3=widget_base(/row, xoffset=xoff3, $
	    title='ISTP Key Parameter Visualization Tool - Version 1.5')
lcol3=widget_base(base3,/column,space=5)
mcol3=widget_base(base3,/column,/frame)

; left
but3=lonarr(10)
for i=0,5 do but3(i)=widget_button(lcol3, value=but3val(i),uvalue=30+(i+1), $
                                /frame,font=sys_def.fontname)
nu=widget_label(lcol3,value='',font=sys_def.fontname)
nu=widget_label(lcol3,value='',font=sys_def.fontname)
newbase=widget_base(lcol3,/column,/frame,space=5)
new1=widget_label(newbase,value='Execution',font=sys_def.fontname)
for i=0,1 do but3(6+i)=widget_button(newbase,value=but3val(6+i),    $
                             uvalue=30+(6+i+1),/frame,font=sys_def.fontname)
nu=widget_label(lcol3,value='',font=sys_def.fontname)
nu=widget_label(lcol3,value='',font=sys_def.fontname)
for i=0,1 do but3(8+i)=widget_button(lcol3,value=but3val(8+i),    $
                             uvalue=30+(8+i+1),/frame,font=sys_def.fontname)

; right
draw=widget_draw(mcol3,xsize=sys_def.xdraw_phase3,ysize=sys_def.ydraw_phase3, $
                 uvalue='PLOT')

widget_control,base3,/realize
widget_control,draw,get_value=window
case !version.os of
'windows': set_plot,'win'
else: set_plot,'x'
endcase
sys_xtickname=!x.tickname
sys_xtitle=!x.title
xmanager,"phase3",base3,group_leader=group3 
end

pro cover
 
case !version.os of
'windows': begin
	    size1=1.5
	    size2=2.0
	    size3=1.2
	   end
else:begin
       size1=2.5
       size2=3.0
       size3=2.0
     end
endcase

!x.margin=[8,8]
!y.margin=[4,4]
x1=[0,0] & x2=[1,0] & x3=[0,1] & x4=[1,1]
xyouts,0.5,0.75,'!18Key Parameter Visualization Tool',charsiz=size1,$
alignment=0.5,/normal
xyouts,0.5,0.85, '!17ISTP',charsiz=size2,alignment=0.5,/normal
xyouts,0.5,0.1,'!17Syau-Yun W. Hsieh, Hughes STX',charsiz=size3,  $
      alignment=0.5,/normal
xyouts,0.50,0.65,'!18Version 1.5',charsiz=size1,alignment=0.5,/normal
xyouts,0.50,0.18,'!17SPOF, GSFC, NASA',alignment=0.5,charsiz=size3,/normal
end

pro phase1_event,ev

common sysbloc,sys_def
common keepwindow,phase1_window,ymargin,xmargin,pcharsize,baselog

widget_control,ev.id,get_uvalue=uval   
case uval of 
11:begin
     phase1_window=!d.window
     ymargin=!y.margin
     xmargin=!x.margin
     pcharsize=!p.charsize
     widget_control,baselog,sensitive=0
     phase3,ev.top
   end
22: widget_control,ev.top,/destroy
33: display,'readme.doc',sys_def.xsubwin(1),sys_def.ysubwin(1),   $
            font=sys_def.fontname
endcase
end

pro phase1

common keepwindow,phase1_window,ymargin,xmargin,pcharsize,baselog
common sysbloc,sys_def

; sys def
sys_def={xdraw_phase1:0L,ydraw_phase1:0L,xdraw_phase3:0L,ydraw_phase3:0L, $
         xsubwin:lonarr(3),ysubwin:lonarr(3),xoffset_phase1:0L,fontname:'', $
         leader:0L,yoffset_phase1:0L ,printer:0L, lpr_plot:0L, lpr_text:0L }
sys_def.printer=0
sys_def.lpr_plot=0
sys_def.lpr_text=0

case !version.os of
 'windows': set_plot,'win'
else: set_plot,'x'
endcase

device,get_screen_size=screensize
case !version.os of
'windows': begin
	    if ((screensize(0) ge 800) and (screensize(1) ge 600)) then begin
	       sys_def.fontname='Times New Roman*18'  
	       sys_def.xoffset_phase1=100
               sys_def.yoffset_phase1=20
	       sys_def.xdraw_phase1=480
	       sys_def.ydraw_phase1=450
	       sys_def.xdraw_phase3=640
	       sys_def.ydraw_phase3=560
               xoff=[50,100,150]
               sys_def.xsubwin(*)=xoff
               sys_def.ysubwin(*)=xoff
	    endif else begin
	       sys_def.fontname='Times New Roman*14'
	       sys_def.xoffset_phase1=20
               sys_def.yoffset_phase1=10
	       sys_def.xdraw_phase1=450
	       sys_def.ydraw_phase1=400
	       sys_def.xdraw_phase3=510
	       sys_def.ydraw_phase3=440
               xoff=[25,75,100]
               sys_def.xsubwin(*)=xoff
               sys_def.ysubwin(*)=xoff
	    endelse
	   end
else:begin
       sys_def.fontname=''
       sys_def.xoffset_phase1=200
       sys_def.yoffset_phase1=100
       sys_def.xdraw_phase1= 600
       sys_def.ydraw_phase1= 600
       sys_def.xdraw_phase3=650
       if screensize(1) gt 880 then sys_def.ydraw_phase3=850 else $
                                    sys_def.ydraw_phase3=725
       xoff=[100,150,200]
       sys_def.xsubwin(*)=xoff
       sys_def.ysubwin(*)=xoff
       
     end
endcase

baselog=widget_base(/row,space=15,xoffset=sys_def.xoffset_phase1,  $
                    yoffset=sys_def.yoffset_phase1,                $
	 title='ISTP Key Parameter Visualization Tool - Version 1.5')
top_row=widget_base(baselog,/column,/frame)

draw_cover=widget_draw(top_row,xsize=sys_def.xdraw_phase1, $
                               ysize=sys_def.ydraw_phase1)
mid_row=widget_base(baselog,/column)                                 
bot_row=widget_base(mid_row,/column,space=20)

w3=widget_button(bot_row,value='  START  ',uvalue=11,/frame) 
w2=widget_button(bot_row,value='  QUIT  ',uvalue=22,/frame)
nuw=widget_label(bot_row,value='')
w4=widget_button(bot_row,value='  READ ME  ',uvalue=33,/frame)
widget_control,/realize,baselog
cover
xmanager,'phase1',baselog
end
