PRO label_page, label1=label1, side_label=side_label, help=help, $
                charsize=charsize
;+
; NAME:
;      LABEL_PAGE
;
; PURPOSE:
;      Mark a page by writing labels on the side (including Date/Time)
;      and top.
;
; CATEGORY:
;      Utility
;
; CALLING SEQUENCE:
;      LABEL_PAGE, label1=label1, side_label=side_label
; 
; INPUTS:
;      None.
;
; OPTIONAL INPUTS:
;      None.
;	
; KEYWORD PARAMETERS:
;      LABEL1: A string to be placed at the top left of the page.
;      SIDE_LABEL: A string to be concatinated to the Date/Time and
;                  placed along the right side of the page.
;      CHARSIZE: A multiplier for the default size of text.
;
; OUTPUTS:
;      Writing on the page.
;
; OPTIONAL OUTPUTS:
;      None.
;
; COMMON BLOCKS:
;      None.
;
; SIDE EFFECTS:
;      None.
;
; RESTRICTIONS:
;      Not very useful for 'X' Device.  Use for Postscript.
;
; PROCEDURE:
;      Construct the labels and print them using XYOUTS.
;
; EXAMPLE:
;      LABEL_PAGE, label1='Title', side_label='extra information'
;
; MODIFICATION HISTORY:
;      $Log: label_page.pro,v $
;      Revision 1.2  1999/10/20 14:46:14  rdh
;      Added charsize input keyword.
;
;      Revision 1.1  1998/11/17 21:15:09  rdh
;      Initial revision
;
;-
   IF (keyword_set(help)) THEN BEGIN
      print, "label_page, label1='Plot Title', side_label='Right Side Message'"
      print, "Prints a Title at the top of the page, and a side label"
      print, "   on the right as well as the time_stamp."
      return
   ENDIF 
   if not keyword_set(charsize) then charsize=1.0
   IF (keyword_set(label1)) THEN BEGIN
      xyouts, 0.001, 0.995, label1, /normal, alignment=0.0, charsize=charsize
   ENDIF
   
   IF (keyword_set(side_label)) THEN BEGIN
      time_stamp, label=side_label, charsize=charsize
   ENDIF ELSE BEGIN
      time_stamp
   ENDELSE
   
   return
END
