; IDL Procedure for complete control of plotting - Line Plots
PRO LINE_PLOT,  X, Y, $
                XRANGE = XRANGE, YRANGE = YRANGE, $
                XTICKS = XTICKS, XMINOR = XMINOR, $
                XTITLE = XTITLE, XTYPE = XTYPE, $
                YTICKS = YTICKS, YMINOR = YMINOR, $
                YTITLE = YTITLE, YTYPE = YTYPE, $
                TICKLEN = TICKLEN, TITLE = TITLE, CHARSIZE = CHARSIZE, $
                ASPECT_RATIO = ASPECT_RATIO_IN, OVERPLOT = OVERPLOT, $
                PSYM = PSYM, XSP = XSP, YSP = YSP, $
                ROUTINE_TITLE = ROUTINE_TITLE, _EXTRA=e
COMMON device_char, xsize, ysize, aspect_ratio_device
;
;	Line Plot at current position
;	parameters:
;		tick marks: number of major - XTICKS, YTICKS
;		tick marks: number of minor - XMINOR, YMINOR
;		length of major tick marks: TICKLEN - 0.0 to 1.0
;		Range to be plotted: XRANGE = [XLOW,XHIGH], YRANGE
;		axis titles and plot title: XTITLE, YTITLE, TITLE 
;		axis type: XTYPE, YTYPE - 0 = linear, 1 = log10
;		character size:	CHARSIZE
;		aspect ratio Lx/Ly: ASPECT_RATIO
;		XSP is the fraction of space left/right of the plot axes
;		YSP is the fraction of space above/below axes
;		/OVERPLOT  means new plot else plot on same axis
;		PSYM = number used for psym;
;		ROUTINE_TITLE is a string to print with time to title plot
;
cr = '!6'
time1 = SYSTIME(0)
IF KEYWORD_SET(ROUTINE_TITLE) THEN BEGIN
   time = cr+ROUTINE_TITLE + ': ' + strmid(time1,4,7) + strmid(time1,20,4)
ENDIF ELSE BEGIN
   time = ''
ENDELSE

if KEYWORD_SET(aspect_ratio_in) then begin
   if (!p.position(0) EQ !p.position(2)) then begin

      IF KEYWORD_SET(xsp) THEN xlow = xsp ELSE xlow = 0.2
      IF KEYWORD_SET(ysp) THEN ylow = ysp ELSE ylow = 0.2

      ASPECT_SET, xlow, ylow, aspect_ratio_in, aspect_ratio_device

   endif else begin
      print, 'WARNING: aspect ratio not used, !P.POSITION manually set.' 
   endelse
endif

IF KEYWORD_SET(XTYPE) THEN XTYPE = XTYPE ELSE XTYPE = 0
IF KEYWORD_SET(YTYPE) THEN YTYPE = YTYPE ELSE YTYPE = 0

IF KEYWORD_SET(XRANGE) THEN XRANGE = XRANGE ELSE XRANGE = [0,0]
IF KEYWORD_SET(YRANGE) THEN YRANGE = YRANGE ELSE YRANGE = [0,0]

IF KEYWORD_SET(XTICKS) THEN XTICKS = XTICKS ELSE XTICKS = 0
IF KEYWORD_SET(YTICKS) THEN YTICKS = YTICKS ELSE YTICKS = 0

IF KEYWORD_SET(XMINOR) THEN XMINOR = XMINOR ELSE XMINOR = 0
IF KEYWORD_SET(YMINOR) THEN YMINOR = YMINOR ELSE YMINOR = 0

IF KEYWORD_SET(XTITLE) THEN XTITLE = cr+XTITLE ELSE XTITLE = ''
IF KEYWORD_SET(YTITLE) THEN YTITLE = cr+YTITLE ELSE YTITLE = ''
IF KEYWORD_SET(TITLE) THEN TITLE = cr+TITLE ELSE TITLE = ''

IF KEYWORD_SET(TICKLEN) THEN TICKLEN = TICKLEN ELSE TICKLEN = 0.02

IF KEYWORD_SET(CHARSIZE) THEN CHARSIZE = CHARSIZE ELSE CHARSIZE = 1

IF KEYWORD_SET(PSYM) THEN PSYM = PSYM ELSE PSYM = 0

IF KEYWORD_SET(OVERPLOT) THEN BEGIN
   OPLOT, X, Y, PSYM = PSYM
ENDIF ELSE BEGIN
   IF ((XTYPE NE 0)AND(YTYPE NE 0)) THEN $
      BEGIN
	 PLOT_OO, X,Y, XTITLE = XTITLE, YTITLE = YTITLE, TITLE = TITLE, $
	       XRANGE = XRANGE, YRANGE = YRANGE, $
	       TICKLEN = TICKLEN, XSTYLE = 1, YSTYLE = 1, CHARSIZE = CHARSIZE, $
	       PSYM = PSYM, SUBTITLE = time, _EXTRA=e
      END $
   ELSE $
      BEGIN
	 IF (XTYPE NE 0) THEN $
	    BEGIN
	       PLOT_OI, X,Y, XTITLE = XTITLE, YTITLE = YTITLE, $
		  TITLE = TITLE, $
		  XRANGE = XRANGE, YRANGE = YRANGE, $
		  TICKLEN = TICKLEN, YSTYLE = 1, CHARSIZE = CHARSIZE, $
		  PSYM = PSYM, SUBTITLE = time, _EXTRA=e
	    END $
	 ELSE $
	    BEGIN
	       IF (YTYPE NE 0) THEN $
		  BEGIN
		     PLOT_IO, X,Y, XTITLE = XTITLE, YTITLE = YTITLE, $
			 TITLE = TITLE, $
			 XRANGE = XRANGE, YRANGE = YRANGE, $
			 TICKLEN = TICKLEN, XSTYLE = 1, CHARSIZE = CHARSIZE, $
			 PSYM = PSYM, SUBTITLE = time, _EXTRA=e
		  END $
	       ELSE $
		  BEGIN
		     PLOT, X,Y, XTITLE = XTITLE, YTITLE = YTITLE, $
			TITLE = TITLE, $
			XRANGE = XRANGE, YRANGE = YRANGE, $
			XTICKS = XTICKS, XMINOR = XMINOR, $
			YTICKS = YTICKS, YMINOR = YMINOR, $
			TICKLEN = TICKLEN, CHARSIZE = CHARSIZE, $
			PSYM = PSYM, SUBTITLE = time, _EXTRA=e
		  END
	    END
      END
ENDELSE



!p.position = [0.0,0.0,0.0,0.0]


RETURN
END





