PRO LINEAR_FIT_RDH, X, Y, SIGMAX, SIGMAY, m_min=m_min, m_max=m_max, n=n, $
                    confidence=confidence, $
                    M, CHISQ, REDCHISQ, distance=S, $
                    m2, reduced_chisq2, nu, sigma1=sigma1
;
;         x, sigmax, y, sigmay are the points to be fit
;
;         (m_min, m_max) is the interval in slope to sample initially
;         n = number of points within slope interval
;
;         confidence on input is an array whose (0,*) elements contain the
;         offsets to chisq for confidence levels.
;      
;         confidence on output is a 2D array with:
;         (0,*) = chisq offset (same as input)
;         (1,*) = min slope at that offset
;         (2,*) = max slope at that offset
;         (3,*) = chisq level
;         m is the best fit slope
;         chisq, redchisq are the best-fit values
;         m2, reduced_chisq2 are a pair of arrays for chisq(slope)
;         nu is the number of degrees of freedom
;
;
   IF keyword_set(confidence) THEN BEGIN
      s1 = size(confidence)
      IF (s1(0) EQ 0) THEN BEGIN
         print, 'Illegal confidence specified.'
         stop
      ENDIF 
      IF (s1(1) LT 1) THEN BEGIN
         print, 'Illegal confidence dimensions specified.'
         stop
      ENDIF 
      IF (s1(0) EQ 1) THEN BEGIN
         offset = fltarr(4,2)
      ENDIF ELSE BEGIN
         offset = fltarr(4,s1(2))
      ENDELSE 
      offset(0,*) = confidence(0,*)
      noffset = s1(0)

   ENDIF ELSE BEGIN 
      offset = fltarr(1,1)
      offset(0,0) = 3.841
      noffset = 1
   ENDELSE 

;   print, 'X1',offset

   sigmaxsq = sigmax^2
   sigmaysq = sigmay^2

   nu = n_elements(x) - 2

   IF NOT keyword_set(n) THEN n = 500
   IF NOT keyword_set(m_min) THEN m_min = 0.1
   IF NOT keyword_set(m_max) THEN m_max = 10
   done = 0
   WHILE (done EQ 0) DO BEGIN 
      chisq1 = fltarr(n)
      reduced_chisq1 = fltarr(n)

      theta_min = atan(m_min)
      theta_max = atan(m_max)
      m1 = tan(theta_min+(theta_max-theta_min)*findgen(n)/float(n))
      ;m1 = m_min+(m_max-m_min)*findgen(n)/float(n)

      FOR i=0,n-1 DO BEGIN
         m = m1(i)
         chisq1(i) = total((y-m*x)^2/(sigmaysq+m*m*sigmaxsq))
         reduced_chisq1(i) = chisq1(i)/nu
      ENDFOR
      
      c = min(chisq1,i)
      m = m1(i)

      dm_min = 0
      dm_max = 0
      FOR ij=0,noffset-1 DO BEGIN 

         c95 = c + offset(0,ij) + 1.0
         r = where(chisq1 LT c95)
         IF r(0) NE -1 THEN BEGIN
            IF r(0) GT 0 THEN rmin = r(0)-1 ELSE rmin = r(0)
            min95 = m1(rmin)
            rn = n_elements(r)-1
            IF r(rn) LT n-1 THEN rmax = r(rn)+1 ELSE rmax = r(rn)
            max95 = m1(rmax)

            IF rmin EQ 0 THEN dm_min = 0.5
            IF rmax EQ n_elements(m1)-1 THEN dm_max = 1.0

         ENDIF ELSE BEGIN 
            min95 = 0.0
            max95 = 0.0
            print, 'min95, max95 all screwed up. Stopping.'
            stop
         ENDELSE 
         offset(1,ij) = min95
         offset(2,ij) = max95
         offset(3,ij) = c95

      ENDFOR 

      IF (dm_min+dm_max NE 0) THEN BEGIN
         IF (m_min GT 1.e-5*m_max) THEN $
          m_min = m_min - m_min*dm_min $
          ELSE $
          done = 1
         IF (m_max LT 1.e+5*m_max) THEN $
          m_max = m_max + m_max*dm_max $
          ELSE $
          done = 1
         print, 'Expanding search to interval?: ',m_min, m_max
      ENDIF ELSE BEGIN
         done = 1
      ENDELSE

   ENDWHILE
   m_min = min(offset(1,0:noffset-1))
   m_max = max(offset(2,0:noffset-1))


;   print, 'X2',m_min, m_max

   chisq2 = fltarr(n)
   reduced_chisq2 = fltarr(n)
   theta_min = atan(m_min)
   theta_max = atan(m_max)
   m2 = tan(theta_min+(theta_max-theta_min)*findgen(n)/float(n))
   ;m2 = m_min+(m_max-m_min)*findgen(n)/float(n)
   FOR i=0,n-1 DO BEGIN
      m = m2(i)
      chisq2(i) = total((y-m*x)^2/(sigmaysq+m*m*sigmaxsq))
      reduced_chisq2(i) = chisq2(i)/nu
   ENDFOR

   c = min(chisq2,i)
   m = m2(i)


   FOR ij=1,noffset-1 DO BEGIN 

      c95 = c + offset(0,ij)
      r = where(chisq2 LT c95)
      IF r(0) NE -1 THEN BEGIN
         IF r(0) GT 0 THEN rmin = r(0)-1 ELSE rmin = r(0)
         min95 = m2(rmin)
         rn = n_elements(r)-1
         IF r(rn) LT n-1 THEN rmax = r(rn)+1 ELSE rmax = r(rn)
         max95 = m2(rmax)
      ENDIF ELSE BEGIN 
         min95 = 0.0
         max95 = 0.0
         print, 'min95, max95 all screwed up. Stopping.'
         stop
      ENDELSE 
      offset(1,ij) = min95
      offset(2,ij) = max95
      offset(3,ij) = c95

   ENDFOR 

   s = sqrt((y-m*x)^2/(sigmaysq+m*m*sigmaxsq))
   chisq = total(s)
   r = where(y LT m*x)
   s(r) = -s(r)
   redchisq =  chisq/nu

   confidence = offset
;   print, 'XX',confidence

   if keyword_set(sigma1) then begin
       c1= chisq + 1.0
       r= where( chisq2 lt c1 )
       max1= max( m2(r), min=min1 )
       sigma1= [ min1, max1 ]
       print, 'one sigma confidence: ', sigma1(0), sigma1(1)
   endif

   RETURN
END
