pro linear_robust_fit, rchisq, m, b, ks_c99, status, s2, r, n, $
                       x, y, sigx, sigy, $
                       robust_status=robust_status, plot=plot
;
;   Robust Fit for Slope by removing successive 5% of worst outliers
;
;   Input: Result of First Fit
;   Output: Result of Best Fit - and new r.
;
;   Robust_Status=
;        1   Rchisq bottomed-out
;        2   Slope converged
;        4   10 iterations
;        8   Rchisq < Rchisq_Min=0.01
;       16   Fit Failed
;       32   Converged Rchisq > 1, but continued.
;
rchisq_min=0.01                   ;1.5
;
    n=0
    nmax=10
    rchisq_0=rchisq*(1.000001)
    m_0=m
    b_0=b
    ks_c99_0=ks_c99
    status_0=status
    s2_0=s2
    r_0=r
    frac=0.95
    r11=r
    r1=r

    slope=replicate(-1e31,10)
    srchisq=replicate(-1e31,10)

    print, n, n_elements(r), rchisq, m, status

    if !d.name eq 'X' and keyword_set(plot) then  begin
        window, 3
        set_page, nv=4, nh=4
    endif

    done=0
    robust_status=0
    while (n lt nmax) and $
      (rchisq gt rchisq_min) and (status eq 1) and $
      (done eq 0) do begin
    
        rchisq_0=rchisq
        m_0=m
        b_0=b
        ks_c99_0=ks_c99
        status_0=status
        s2_0=s2
        r_0=r
        r11=r1

        is_0=sort(s2_0)
        is=is_0(0:frac*n_elements(is_0))
        r=r_0(is)

        if !d.name eq 'X' and keyword_set(plot) then begin
            histogram_rdh, sqrt(s2_0(r))*hyd_sign(y(r)/x(r)-m), $
              xh, yh, binsize=0.2, min=-10, max=10
            plot, xh, yh, psym=10, title='1st Residuals'
        endif

        gen_fit_release, x=x(r), y=y(r), sigma_x=sigx(r), sigma_y=sigy(r), $
          guess_slope= guess, $
          rchisq=rchisq, slope=m, s2=s2, intercept=b, $
          c99=c99, ks_c99=ks_c99, errorpercent=1e-3, status=status, nparm=1, $
          /force_kappa, kappa_picture=kappa_picture, /renormalize, $
          ks_range_deg=[0,89.9]
        if status ne 1 then message, 'gen_fit_release failed: error '+$
          strtrim(status,2)
;
;      Redo Residuals
;
        x0=(m*y/sigy^2 + x/sigx^2)/(m^2/sigy^2 + 1/sigx^2)
        
        s2=((y-m*x0)/sigy)^2+((x-x0)/sigx)^2
        is_1=sort(s2)
        is=is_1(0:frac*n_elements(is_1))
        r1=r_0(is)

        if !d.name eq 'X' and keyword_set(plot) then begin
            histogram_rdh, sqrt(s2(r1))*hyd_sign(y(r1)/x(r1)-m), $
              xh, yh, binsize=0.2, min=-10, max=10
            plot, xh, yh, psym=10, title='2nd Residuals'
        endif
        print, n, n_elements(r1), rchisq, m, status, (m-m_0)/m_0
        r=r_0
        
        slope(n)=m
        srchisq(n)=rchisq
        if (abs(m-m_0)/m_0 lt 1e-2) then begin
            frac=frac-0.05
            n=n+1
            if n gt 1 then begin
                if (srchisq(n-1) ge srchisq(n-2)) then begin
                    robust_status=robust_status or 1
                    done=1
                endif
           
                dslope=abs(slope(n-1)-slope(n-2))/slope(n-1)
                print, n-2, slope(n-2), n-1, slope(n-1), dslope
                if (dslope lt 0.01) then begin
                    if (rchisq lt 1.0) then begin
                        robust_status=robust_status or 2
                        done=1
                    endif else begin
                        robust_status=robust_status or 32
                    endelse
                endif
            endif
        endif
        if (status ne 1) then begin
            rchisq=1e31
            n=0
        endif

        if n gt nmax then robust_status=robust_status or 4
        if rchisq le rchisq_min then robust_status=robust_status or 8
        if status ne 1 then robust_status=robust_status or 16
    endwhile

    if status ne 1 then begin
        rchisq=rchisq_0
        m=m_0
        b=b_0
        ks_c99=ks_c99_0
        status=status_0
        s2=s2_0
        r=r11
    endif else begin
        r=r1
    endelse
    if !d.name eq 'X' and keyword_set(plot) then wset, 1

return
end
