PRO modify_bfilter, date, start_time, end_time, value, $
                    stop=stop, verbose=verbose, dd=dd, yes=yes
;
;  Edits the (VALIDB filter and B_HIGH_VALID filters) in the 
;  current DDCAL file for the date.
;
;  Enter start_time, end_time in 'hh:mm:ss.sss' format
;
;
;
   spawn, 'date', time
   label = ['# '+strtrim(time,2),'IDL>modify_bfilter, '+strtrim(date,2)+', "'+$
    strtrim(start_time,2)+'", "'+strtrim(end_time,2)+'", '+strtrim(value,2)]
   log = 'ddcal'
   IF keyword_set(dd) THEN BEGIN
      log = 'dd'
      label(1) = label(1)+', /dd'
   ENDIF 

   s = size(start_time)
   IF s(n_elements(s)-2) EQ 7 THEN BEGIN ; format hh:mm:ss.sss
      start_time = gen_time(time=start_time)*86400.d0
   ENDIF 
   s = size(end_time)
   IF s(n_elements(s)-2) EQ 7 THEN BEGIN ; format hh:mm:ss.sss
      end_time = gen_time(time=end_time)*86400.d0
   ENDIF 
;
;  Read HYD/PPA and MFE 8 HZ Validb Data from ddcal file.
;
   filename_56 = ''
   filename_8 = ''
   read_validb_56, date, validb_56, time_56, filename_56, dd=dd, $
    time_interval=[start_time, end_time], verbose=verbose, out=vball_before
   read_validb_8, date, validb_8, time_8, filename_8, dd=dd, $
    time_interval=[start_time, end_time], verbose=verbose, out=vball8_before
;
;  Modify Validb Data according to inputs
;
   IF keyword_set(verbose) THEN BEGIN 
      set_page, nv=3, nh=2
      r = where(time_56 GE start_time AND time_56 LE end_time)
      plot, time_56(r), validb_56(r), psym=1, yrange=[-0.5,1.5], $
       xrange=[start_time,end_time]
      r8 = where(time_8 GE start_time AND time_8 LE end_time)
      plot, time_8(r8), validb_8(r8), psym=1, yrange=[-0.5,1.5], $
       xrange=[start_time,end_time]
   ENDIF 

   edit_validb, validb_56, time_56, start_time, end_time, value
   edit_validb, validb_8, time_8, start_time, end_time, value

   IF keyword_set(verbose) THEN BEGIN 
      plot, time_56(r), validb_56(r), psym=1, yrange=[-0.5,1.5], $
       xrange=[start_time,end_time]
      plot, time_8(r8), validb_8(r8), psym=1, yrange=[-0.5,1.5], $
       xrange=[start_time,end_time]
   ENDIF 

;   filename_56 = '/opt/hydra/l1_12/19980504_hyd_ddcal_v0.89.cdf'
;   filename_8 = '/opt/hydra/l1_12/19980504_hyd_ddcal_v0.89.cdf'

   if not keyword_set(yes) then begin
       IF keyword_set(dd) THEN $
         prompt='Write edit information to ddeis Level 1 file (y/n)?' ELSE $
         prompt='Write edit information to ddcal file (y/n)?'
       print, prompt
       answer = get_kbrd(1)
   endif else begin
       answer='y'
   endelse
   IF strmid(answer, 0, 1) EQ 'y' THEN BEGIN
      print, 'Updating cdf file and edit information.'
      write_validb_56, date, validb_56, time_56, label, filename_56, $
       verbose=verbose, log=log
      write_validb_8, date, validb_8, time_8, label, filename_8, $
       verbose=verbose, log=log

      IF keyword_set(verbose) THEN BEGIN 
         read_validb_56, date, validb_56, time_56, filename_56, dd=dd, $
          time_interval=[start_time, end_time], verbose=verbose, $
          out=vball_after
         plot, time_56(r), validb_56(r), psym=1, yrange=[-0.5,1.5], $
          xrange=[start_time,end_time]
         read_validb_8, date, validb_8, time_8, filename_8, dd=dd, $
          time_interval=[start_time, end_time], verbose=verbose, $
          out=vball8_after
         plot, time_8(r8), validb_8(r8), psym=1, yrange=[-0.5,1.5], $
          xrange=[start_time,end_time]
      ENDIF
   ENDIF ELSE BEGIN
      print, 'File not updated.'
   ENDELSE 


   IF keyword_set(stop) THEN stop
   return
END
