PRO move_cdf_var, date=date, file=file, var=var, $
                  infile=infile, outfile=outfile, stop=stop
;
;
;    Move cdf variable contents from one cdf to another
;
;
   IF keyword_set(date) THEN BEGIN
      date = strtrim(date,2)
   ENDIF ELSE BEGIN 
;      date = '19960427'
      date = '19960429'
   ENDELSE 

   IF keyword_set(infile) THEN BEGIN
      file1 = infile
      IF keyword_set(outfile) THEN BEGIN
         file2 = outfile
      ENDIF ELSE BEGIN
         print, 'Error: infile and outfile must both be specified.'
      ENDELSE 
   ENDIF ELSE BEGIN 
      IF NOT keyword_set(file) THEN BEGIN
         file = '_hyd_s0_v1.14.cdf'
      ENDIF
      file1 = '/net/supras/export/home/holdaway/lzsurvey/'+date+file
      file2 = '/net/supras/export/home/faden/spectra_data/'+date+file
   ENDELSE 
   
   IF NOT keyword_set(var) THEN var = 'B_GSM'


   print, 'Opening cdf input file '+file1
   cdf_in = cdf_open(file1)
   print, 'Reading variable '+var
   cdf_varget, cdf_in, var, data, rec_count=6272
   cdf_close, cdf_in

   IF keyword_set(stop) THEN stop


   print, 'Opening cdf output file '+file2
   cdf_out = cdf_open(file2)
   print, 'Writing variable '+var
   cdf_varput, cdf_out, var, /zvar, data
   cdf_close, cdf_out
   return
END
