PRO pack_validb_56, validb_unpacked, time_unpacked, validb, block_time, $
                 stop=stop
;
;   Pack Validb into array in preparation for writing to cdf
;
;   Input arrays are of length 768*nblocks
;
;   Output validb is 96,nblocks
;   Output block_time is nblocks long.

   nblocks = long(n_elements(validb_unpacked)/768)

   validb_unpack = reform(validb_unpacked, 8, 96, nblocks)
   validb = bytarr(96, nblocks)
   i2 = byte(2^indgen(8))
   FOR i=0,7 DO BEGIN
      validb = validb OR (i2(i)*validb_unpack(i,*,*))
   ENDFOR 

   time_unpack = reform(time_unpacked, 768, nblocks)
   block_time = time_unpack(0,*)

   IF keyword_set(stop) THEN stop
   return
END
