PRO pack_validb_8, validb_unpacked, time_unpacked, validb, mjf_time, $
                 stop=stop
;
;   Pack Validb into array in preparation for writing to cdf
;
;   Input arrays are of length 88*nmjfs
;
;   Output validb is 11,nmjfs
;   Output mjf_time is nmjfs long.

   nmjfs = long(n_elements(validb_unpacked)/88)

   validb_unpack = reform(validb_unpacked, 8, 11, nmjfs)
   validb = bytarr(11, nmjfs)
   i2 = byte(2^indgen(8))
   FOR i=0,7 DO BEGIN
      validb = validb OR (i2(i)*validb_unpack(i,*,*))
   ENDFOR 

   time_unpack = reform(time_unpacked, 88, nmjfs)
   mjf_time = time_unpack(0,*)

   IF keyword_set(stop) THEN stop
   return
END
