pro plot_hms, t, y, ssm=ssm, hsm=hsm, t90=t90, $
              center=center, start=start, date=date, $
              overplot=overplot, $
              _extra=e
;+
;  plot_hms, t, y
;
;  Plots using hh:mm:ss on Abscissa as required.
;
;  - Front-End to hd_plot
;
;  Required keywords:
;
;     One of:  /ssm, /hsm, /t90
;
;  Optional keywords:
;
;     /overplot  -  overplots on a previous axis.
;
;     To draw interval-width bars:
;
;        center=<interval length> or start=<interval_length>
;            [In same units as t]
;
;     Default is 0-width.
;
;
;     date [YYYYMMDD] {Required if day boundaries are crossed.}
;
;
;  Example:
;
;  t=[10.4, 45.7, 120.5]
;  y=[1, 2, 1]
;  plot_hms, t, y, /ssm, ystyle=2, psym=1
;
;  plot_hms, t, y, /ssm, ystyle=2, center=4.6
;
;-
if not keyword_set(date) then date='19960100'

if keyword_set(center) then begin
    time_start=double(t-0.5*center)
    width=center
endif else if keyword_set(start) then begin
    width=double(start)
    time_start=t
endif else begin
    time_start=t
    width=0.0
endelse
if keyword_set(t90) then begin
    s=0
endif else begin
    if keyword_set(hsm) then begin
        width=width*3600.d0
    endif
    s=1
endelse
hd_make_timetags, timetags, time_start, width, t90=t90, hsm=hsm, ssm=ssm, $
  dateyyyymmdd=date, width_seconds=s

hd_plot, timetags, y, overplot=overplot, /nodate, _extra=e

end
