pro plot_separator, v, tstart, tend, $
                    xnif_start, xnif_end, znif_start, znif_end, $
                    xs, txs, zs, tzs, dimensions=dimensions, $
                    smear_coords=smear_coords, smear_times=smear_times, $
                    smear_index=smear_index, $
                    use_smear_input=use_smear_input, $
                    accumulate_smears=accumulate_smears, $
                    midpoint=midpoint, noplot=noplot, $
                    return_points=return_points, matrix=matrix, $
                    xrange=xr, yrange=yr, interval=interval, $
                    avg_method=avg_method, plot=plot
;
;    Plot the value v as a smear in x,z space x=xnif-xs over time
;      interval [tstart,tend].
;
;    Input:
;            v:       "color" value in plot
;            tstart:  Start of "smear" time interval
;            tend:    End of "smear" time interval
;            xnif_start: Xnif at tstart
;            xnif_end:   Xnif at tend
;            znif_start: Znif at tstart
;            znif_end:   Znif at tend
;
;            xs:  Separator x-position
;            txs: time of x-position
;            zs:  Separator z-position
;            tzs: time of z-position
;
;
;            avg_method:    Method of averaging to use:
;                                  'A' = weighted Average (default)
;                                  'B' = Max
;                                  'C' = Min
;                                  'D' = |Max|
;
;
;
init=1
nv=n_elements(v)
if not keyword_set(dimensions) then dimensions=[250,250]
nx=dimensions(0)
ny=dimensions(1)

midpoint=keyword_set(midpoint)
if keyword_set(use_smear_input) then begin
    if not keyword_set(smear_coords) then begin
        smear_coords=1
        smear_index=0
        smear_times=0

        nxs=n_elements(xs)
        nzs=n_elements(zs)
        isx=0L
        iex=100
        isz=0L
        iez=100
        nrxs=10
        nrzs=10

        nv100=nv/50
;print, systime()
        for i=0L,nv-1 do begin
            v0=v(i)
            t0=tstart(i)
            t1=tend(i)

            if (i mod nv100) eq 0 then print, i,' Smear: '+tick_hms(1,2,t0)
;
;           Obtain x,z,t covering the interval [t0,t1] with all "corners".
;
            rxs=where_in_range(txs, t0, t1,n=nrxs,close=ixc)
            rzs=where_in_range(tzs, t0, t1,n=nrzs,close=izc)

            if nrxs gt 0 then begin
                
                t=[t0, txs(rxs), tzs(rzs), t1]
                t=t(uniq(t,sort(t)))
                isx=rxs(0)-1 > 0
                iex=rxs(nrxs-1)+1 < (nxs-1)
                isz=rzs(0)-1 > 0
                iez=rzs(nrzs-1)+1 < (nzs-1)
            endif else begin
                t=[t0,t1]
                isx=ixc-1 > 0
                iex=ixc+1 < (nxs-1)
                isz=izc-1 > 0
                iez=izc+1 < (nzs-1)
            endelse
;
;           Interpolate to corner times
;
            xo=interpol(xs(isx:iex),txs(isx:iex),t)
            zo=interpol(zs(isz:iez),tzs(isz:iez),t)
;
;    Interpolate xnif,znif to all t.
;
            xnif=interpol([xnif_start(i),xnif_end(i)],[t0,t1],t)
            znif=interpol([znif_start(i),znif_end(i)],[t0,t1],t)
;
;    Form position relative to separator
;
            x=xnif-xo
            z=znif-zo

            plot_smear, v0, x, z, t, dimensions=[nx,ny], $
              smear_coords=smear_coords, smear_index=smear_index, $
              smear_times=smear_times, $
              xrange=xr, yrange=yr, init=init
            init=0

            if keyword_set(compare_time_intervals) then begin
                compare_xxc, tstart(i), tend(i), v(i), x, z, $
                  smear_coords, smear_index, smear_times
            endif
;            if (i mod 100) eq 0 then print, systime()
        endfor
                                ;
                                ;   Truncate smear_* arrays
                                ;
        ni=smear_index(0,1)
        if ni ne 0 then begin
            smear_index=smear_index(0:ni-1,*)
            smear_times=smear_times(0:ni-2,*)
            nc=smear_index(1,1)
            smear_coords=smear_coords(0:nc-1,*)
        endif

    endif
endif
;
;    Plot on final time through
;
if not keyword_set(accumulate_smears) then begin
    check_smear, smear_index, smear_times, smear_coords, v, tstart, tend, $
      check=check, /fix, interval=interval
    if check eq 0 then message, 'Smear coordinates incompatible w/quantity.'

    if not keyword_set(return_points) then return_points=0
    plot_smear, v, /plot, $
      smear_coords=smear_coords, smear_index=smear_index, $
      smear_times=smear_times, midpoint=midpoint, $
      matrix=matrix, $
      return_points=return_points, avg_method=avg_method
endif

return
end
