pro  plot_separator_54hz, tstart, tend, $
                          xnif_start, xnif_end, znif_start, znif_end, $
                          xs, txs, zs, tzs, $
                          matrix_dimensions=matrix_dimensions, $
                          xrange=xrange, yrange=zrange, $
                          smear_coords=smear_coords, $
                          smear_index=smear_index, smear_times=smear_times
;
;    Generate smear coordinates for 54Hz data (at mid points)
;
;
if keyword_set(matrix_dimensions) then begin
    nx=matrix_dimensions(0)
    nz=matrix_dimensions(1)
endif else begin
    nx=1000
    nz=1000
endelse
if keyword_set(xrange) then xr=xrange else xr=[-2,2]
if keyword_set(zrange) then zr=zrange else zr=[-4,4]

tmid=0.5*(tend+tstart)

print, 'Creating x-separator coordinates.'
xnif=0.5*(xnif_start+xnif_end)
xsep=interpol(xs, txs, tmid)
x=xnif-xsep

dx=(xr(1)-xr(0))/float(nx)
xn=(x-xr(0))/dx


print, 'Creating z-separator coordinates.'
znif=0.5*(znif_start+znif_end)
zsep=interpol(zs, tzs, tmid)
z=znif-zsep

dz=(zr(1)-zr(0))/float(nz)
zn=(z-zr(0))/dz


nt=n_elements(tstart)
smear_times=[[0,tstart],[0,tend]]
smear_index=[[nx,nz,lindgen(nt)+2],[nx,nz,lindgen(nt)+2]]
smear_coords=[[xr,xn], [zr,zn],[0,0,replicate(1,n_elements(x))]]
print, 'Separator coordinates done.'

return
end
