pro plot_separator_dots, tstart, tend, $
                    xs, txs, zs, tzs, dimensions=dimensions, $
                    smear_coords=smear_coords, smear_times=smear_times, $
                    smear_index=smear_index, $
                    xrange=xr, yrange=zr, interval=interval
;
;    Smear in x,z space x=-xs, z=-zs over time
;      interval [tstart,tend].
;
;    Input:
;            tstart:  Start of "smear" time interval
;            tend:    End of "smear" time interval
;            xs:      Separator x-position
;            txs:     time of x-position
;            zs:      Separator z-position
;            tzs:     time of z-position
;
;    Keyword Inputs:
;            dimensions:       matrix dimensions to use.
;            xrange, yrange:   Physical size of matrix.
;            interval:         Repetition rate.
;
;    Output Keywords:
;            smear_coords, smear_times, smear_index
;
;
print, 'Re-Calculating dot-smear.'
rfill=-1e31

nv=n_elements(tstart)
if not keyword_set(dimensions) then dimensions=[250,250]
nx=dimensions(0)
ny=dimensions(1)

nxs=n_elements(xs)
nzs=n_elements(zs)
r=where(txs ne tzs)
if nxs ne nzs or r(0) ne -1 then $
  message, 'X,Z Separator Coords must have equal times.'



ind=long((tstart-tstart(0))/interval+0.01)
d=ind(1:*)-ind
r=where(d ne 1)
if r(0) ne -1 then message, 'Mapping not linear for quantity.'

fraction=(tend(0)-tstart(0))/interval
find=(txs-tstart(0))/interval
rind=where(find-long(find) le fraction)
ind=long(find(rind))
r=where(ind ge 0 and ind lt nv, nxs)
ind=ind(r)
xs0=xs(rind(r))
zs0=zs(rind(r))

d=ind(1:*)-ind
r=where(d ne 0,nr)
if nr eq 0 then message, 'Indexing failed.'
if r(nr-1) ne nxs-1 then begin
    r=[r,nxs-1]
    nr=nr+1
endif
ri=lindgen(nv)
rs=replicate(nxs,nv)
re=replicate(nxs,nv)

rs0=[0,r(0:nr-2)+1]
re0=r
rs(ind(rs0))=rs0
re(ind(rs0))=re0

x0=xr(0)
dx=(xr(1)-xr(0))/float(nx)
z0=zr(0)
dz=(zr(1)-zr(0))/float(ny)

x=[long((-xs0-x0)/dx),-1000000]
z=[long((-zs0-z0)/dz),-1000000]

smear_coords=[[xr,x],[zr,z], [0,0,replicate(0.018,nxs),0]]
smear_times=[[0,tstart(ri)],[0,tend(ri)]]
smear_index=[[nx,ny,rs+2],[nx,ny,re+2]]

;print, 'Done recalculating dot-smear - 1.'
;print, systime()
;ind=replicate(long(-1),nx,ny)
;ptr=[0]
;iptr=0
;for i=0,nx-1 do begin
;    nind=n_elements(ind)
;    r=where(x eq i)
;    if r(0) ne -1 then begin
;        h=histogram(z(r), reverse_indices=ri, binsize=1, min=0, max=ny-1)

;        s=where(h ne 0)
;        for j=0,n_elements(s)-1 do begin
;            ind(i,s(j))=iptr
;            ptr=[ptr,ri(ri(s(j))]
;            iptr=iptr+1
;        endfor

;        ptr=[ptr,n_elements(ri)]
;    endif
;endfor
;print, systime()



coords={x:x, z:z, w:[replicate(0.018,nxs),0], $
        tstart:tstart(ri), tend:tend(ri), istart:rs, iend:re, $
        xrange:xr, zrange:zr, nx:nx, nz:ny}

print, 'Done recalculating dot-smear.'

return
end

