pro  plot_separator_dots_54, tstart, tend, $
                             xs, txs, zs, tzs, $
                             matrix_dimensions=matrix_dimensions, $
                             xrange=xrange, yrange=zrange, $
                             smear_coords=smear_coords, $
                             smear_index=smear_index, $
                             smear_times=smear_times, $
                             smear_str=ss
;
;    Generate smear coordinates for 54Hz data (at sept coord points)
;
;
test=0

if keyword_set(matrix_dimensions) then begin
    nx=matrix_dimensions(0)
    nz=matrix_dimensions(1)
endif else begin
    nx=1000
    nz=1000
endelse
if keyword_set(xrange) then xr=xrange else xr=[-2,2]
if keyword_set(zrange) then zr=zrange else zr=[-4,4]

nxs=n_elements(xs)
nv=n_elements(tstart)

dx=(xr(1)-xr(0))/float(nx)
x=[long((-xs-xr(0))/dx),-100000]

dz=(zr(1)-zr(0))/float(nz)
z=[long((-zs-zr(0))/dz),-100000]


print, 'Creating timetags.'
width=9.2/512
hd_make_timetags, timetags, tstart, tend-tstart, /ssm
hd_make_timetags, ttags, txs-width*0.5, width, /ssm
print, 'Beginning synchronize.'
ind=hd_synchronize_nearest_neighbor(ttags, timetags, lindgen(nv))
print, 'End synchronize.'

d=ind(1:*)-ind
r=where(d ne 0,nr)
if nr eq 0 then message, 'Indexing failed.'
if r(nr-1) ne nxs-1 then begin
    r=[r,nxs-1]
    nr=nr+1
endif
rs0=[0,r(0:nr-2)+1]
re0=r
ri=lindgen(nv)
rs=replicate(nxs,nv)
re=replicate(nxs,nv)
rs(ind(rs0))=rs0
re(ind(re0))=re0

w=replicate(0.018,n_elements(x))

nt=nv
smear_times=[[0,tstart],[0,tend]]
smear_index=[[nx,nz,rs+2],[nx,nz,re+2]]
smear_coords=[[xr,x], [zr,z],[0,0,w]]
smear_coords_times=[-1,-1,txs,-1]

print, 'Separator coordinates done.'

if keyword_set(connect_the_dot) then begin
    smear_connect_the_dot, $
      smear_times, smear_index, smear_coords, smear_coords_times, $
      gs=[dx,dz], limits=[xr(0), zr(0), xr(1), zr(1)], nx=nx, ny=nz
endif
;save, file='/opt/hydra/archive/utilities/smear/smear_data.idlsav', $
;  timetags, ttags, ind, smear_index, smear_times, smear_coords, xs, zs


;
;  Testing code to speed-up the averaging by saving indices
;
;print, systime()
;indexi=[0]
;indexj=[0]
;index_start=[0]
;index_end=[0]
;index_n=[0]
;index_v=[0]
;point_list=[0]
;for j=0,nz-1 do begin
;    r=where(z eq j)
;    if r(0) ne -1 then begin
;        h=histogram(x(r), reverse_indices=ri, binsize=1, min=0, max=nx-1)
;        nri=n_elements(ri)
;        s=where(h ne 0,ns)

;        n=n_elements(indexi)
;        np=n_elements(point_list)

;        indexi=[indexi,s]
;        indexj=[indexj,replicate(j,ns)]
;        index_start=[index_start,np+ri(s)-(nx+1)]
;        index_end=[index_end,np+ri(s+1)-1-(nx+1)]
;        index_n=[index_n,h(s)]
;        index_v=[index_v,ind(r(ri(nx+1:nri-1)))]
;        point_list=[point_list,r(ri(nx+1:nri-1))]

;        if keyword_set(test) then begin
;            for i=0,ns-1 do begin
;                xi=smear_coords(point_list(index_start(n+i):$
;                                           index_end(n+i))+2,0)
;                zi=smear_coords(point_list(index_start(n+i):$
;                                           index_end(n+i))+2,1)
;                if ((where(xi-indexi(n+i) ne 0))(0) ne -1) and $
;                  ((where(zi-indexj(n+i) ne 0))(0) ne -1) then begin
                    
;                    p=point_list(index_start(n+i):index_end(n+i))
                    
;                    print, n+i, indexi(n+i), indexj(n+i), $
;                      index_start(n+i), index_end(n+i)
;                    print, p
;                    print, xi
;                    print, zi
                    
;                    stop
;                endif
;            endfor
;        endif
;    endif
;endfor


;ss={indexi:indexi, indexj:indexj, $
;           index_start:index_start, index_end:index_end, $
;           index_n:index_n, index_v:index_v, $
;           point_list:point_list, $
;           x:x, z:z, w:w, $
;           times:smear_times, $
;           index:smear_index, $
;           coords:smear_coords}


;print, systime()

;nmp=n_elements(ss.index_n)
;zz=fltarr(nmp)
;ww=fltarr(nmp)

;r1=where(ss.index_n eq 1)
;print, '1: ', n_elements(r1)
;if r1(0) ne -1 then begin
;    cww=ss.w(ss.point_list(ss.index_start(r1)))
;    zz(r1)=tstart(ss.index_v(ss.index_start(r1)) )*cww
;    ww(r1)=cww

;    i=ss.indexi(r1(0))
;    j=ss.indexj(r1(0))
;    rij=where(x eq i and z eq j)
;    print, i,j, ss.index_v(r1(0)), ss.point_list(ss.index_start(r1(0))), $
;      rij, ind(rij)





;endif
;r1=where(ss.index_n eq 2)
;print, '2: ', n_elements(r1)
;if r1(0) ne -1 then begin
;    cww1=ss.w(ss.point_list(ss.index_start(r1)))
;    cww2=ss.w(ss.point_list(ss.index_start(r1)+1))
;    ww(r1)=cww1+cww2
;    zz(r1)=tstart(ss.index_v(ss.index_start(r1)) )*cww1+ $
;      tstart(ss.index_v(ss.index_start(r1)+1) )*cww2
;    ww(r1)=cww1+cww2
;endif
;r1=where(index_n eq 3)
;print, '3: ', n_elements(r1)
;if r1(0) ne -1 then begin
;    cww1=ss.w(ss.point_list(ss.index_start(r1)))
;    cww2=ss.w(ss.point_list(ss.index_start(r1)+1))
;    cww3=ss.w(ss.point_list(ss.index_start(r1)+2))
;    ww(r1)=cww1+cww2
;    zz(r1)=tstart(ss.index_v(ss.index_start(r1)) )*cww1+ $
;      tstart(ss.index_v(ss.index_start(r1)+1) )*cww2+ $
;      tstart(ss.index_v(ss.index_start(r1)+2) )*cww3
;    ww(r1)=cww1+cww2+cww3
;endif
;r1=where(index_n ge 4)
;print, '4+: ', n_elements(r1)
;if r1(0) ne -1 then for i=0,n_elements(r1)-1 do begin
;    cww=ss.w(ss.point_list(ss.index_start(r1(i)):ss.index_end(r1(i))))
;    ww(r1(i))=total(cww)
;    z1=tstart(ss.index_v(ss.index_start(r1(i)):ss.index_end(r1(i))))
;    zz(r1(i))=total(z1*cww)/ww(r1(i))
;endfor
;print, systime()

;stop

return
end


