pro plot_smear, z, x, y, t, $
                xrange=xrange, yrange=yrange, $
                dimensions=dimensions, $
                smear_coords=smear_coords, smear_times=smear_times, $
                smear_index=smear_index, $
                midpoint=midpoint, $
                init=init, plot=plot, $
                return_points=return_coords, $
                matrix=matrix, $
                verbose=verb, avg_method=avg_method
;
;   Plot the smear of z(x(t),y(t)).  Can be called repeatedly to
;   average weighted by time in each matrix cell.
;
;
;   Input: x,y,t: Time-series
;          z:     "color" value to be smeared
;          
;   Output: Plot using hydra_colorscat.
;
;   Keywords:    x/yrange as usual.
;                /init to initialize routine.
;                dimensions: dimensions [nx, ny], for Averaging Matrix space.
;                /plot to plot the final result - no inputs except z.
;
;

midpoint_average=1
rfill=-1e31
verbose=keyword_set(verb)

if not keyword_set(plot) then begin
    if not keyword_set(xrange) then begin
        xrange=[min(x,max=max),max]
        if (xrange(1)-xrange(0)) eq 0 then xrange(1)=xrange(1)+1
    endif
    if not keyword_set(yrange) then begin
        yrange=[min(y,max=max),max]
        if (yrange(1)-yrange(0)) eq 0 then yrange(1)=yrange(1)+1
    endif
    xr=xrange
    yr=yrange
    if not keyword_set(dimensions) then dimensions=[100,100]
    nx=dimensions(0)
    ny=dimensions(1)

    hyd_plot_average_single_segment, x, y, t, nx, ny, xi, yi, wi, $
      xrange=xr, yrange=yr, verbose=verbose

    smear_append, smear_index, smear_times, smear_coords, xi, yi, wi, t, $
      nx, ny, xr, yr

endif else begin

    print, 'Plotting using smear inputs.'

    if keyword_set(midpoint) then begin
        
        smear_midpoint, smear_coords, smear_index, smear_times, $
          z, xx,yy,ww,zz,vzz, matrix=matrix, $
          midpoint_average=midpoint_average, avg_method=avg_method
        
    endif else begin
        
        smear_matrix_average, smear_coords, smear_index, smear_times, $
          z, xx,yy,zz,vzz,ww, matrix=matrix, avg_method=avg_method
    endelse


    if keyword_set(return_coords) then begin
        if keyword_set(xx) then $
          return_coords=[[xx],[yy],[zz],[vzz],[ww]]
    endif

endelse

return
end





