FUNCTION deficiency_string_web, cond, standard, testv, label
   IF (cond) THEN BEGIN 
      dstring = label+': '+strtrim(string(testv,format='(f6.2)'),2)+' -> '+ $
       strtrim(string(standard,format='(f6.2)'),2)+' '
   ENDIF ELSE BEGIN
      dstring = ""
   ENDELSE 

   return, dstring
END
 

PRO plot_version_web, plot_version, plot_number, plot_identifier, versions, $
                      quality_flag, verbose=verbose, $
                      deficiency=deficiency, $
                      version_strings=version_strings, $
                      use_web_file=use_web_file, echo=echo, $
                      init=init
;
;   Read plot version summary file.
;
;   INPUT:  plot_identifier = string indicating type of plot
;   INPUT:  versions = float array of versions to test
;
;   OUTPUT: plot_version = absolute Plot Version
;   OUTPUT: plot_number = absolute HYDRA Plot Number
;   OUTPUT: quality_flag = .true. if it is up-to-date
;   
;   OUTPUT: deficiency returns a string stating what needs to be updated
;
   COMMON plot_version_web_comm, define, plot_vers, nversions, nplots, nparts


   IF NOT keyword_set(define) OR keyword_set(init) THEN BEGIN 

      IF keyword_set(verbose) THEN print, 'Reading plot_version Record.'

      filename = 'plot_version_summary_v00.dat'

      command = 'wget http://supras.physics.uiowa.edu/hydra_data/versions/'+$
       filename

      IF keyword_set(use_web_file) THEN BEGIN 
         
         spawn, 'cd /tmp;mkdir -p hydra'
         spawn, command+' -O /tmp/hydra/'+filename
         file = '/tmp/hydra/'+filename
         get_lun, unit
         openr, unit, file
         
      ENDIF ELSE BEGIN 
         spawn, command+' -O - ', unit=unit
      ENDELSE 

      nversions = 100
      nplots = 100
      nparts = 6

      plot_vers1 = {plot_v1, $
                    plotv: float(0.0), $
                    nparts: 0L, $
                    parts: fltarr(nparts) }

      plot_vers2 = {plot_v2, $
                    nversions: 0L, $
                    identifier: string(""), $
                    versions: replicate(plot_vers1, nversions)}

      plot_vers = replicate(plot_vers2, nplots)

      line = string("")

      iplot = -1

      readf, unit, line
      IF keyword_set(echo) THEN print, line
      WHILE (strmid(line, 0, 3) NE 'END') DO BEGIN
         CASE strmid(line,0,4) OF
            'DDEI': BEGIN
               ident = (str_sep(strcompress(line),' '))(1)
               iplot = iplot+1
               iversion = -1
               plot_vers(iplot).nversions = iversion
               plot_vers(iplot).identifier = ident
            END
            'VERS': BEGIN
               iversion = iversion+1
               plot_vers(iplot).nversions = iversion
               npos = strpos(line, '#')
               IF (npos NE -1) THEN BEGIN
                  line0 = strtrim(strmid(line, 0, npos),2)
               ENDIF ELSE BEGIN
                  line0 = strtrim(line,2)
               ENDELSE 
               line1 = str_sep(strcompress(line0),' ')
               nums = float(line1(1:n_elements(line1)-1))
               plot_vers(iplot).versions(iversion).plotv = nums(0)
               plot_vers(iplot).versions(iversion).nparts = n_elements(nums)-1
               plot_vers(iplot).versions(iversion).parts = $
                nums(1:n_elements(nums)-1)
            END
            ELSE: BEGIN
            END
         ENDCASE 
         readf, unit, line
         IF keyword_set(echo) THEN print, line
      ENDWHILE 
      close, unit
      free_lun, unit

      IF keyword_set(use_web_file) THEN BEGIN 
         spawn, 'rm '+file
      ENDIF 
      define = 1
   ENDIF ELSE BEGIN
      IF keyword_set(verbose) THEN print, 'Not Reading plot_version Record.'
   ENDELSE


   nv = n_elements(versions)
   iver = lonarr(nv)
   FOR i=0,nv-1 DO BEGIN
      IF (versions(i) NE -1.0) THEN iver(i) = 0 ELSE iver(i) = 1
   ENDFOR 
   


   IF keyword_set(verbose) THEN BEGIN 
      print, 'INPUT Version Parameters: '
      FOR i=0,n_elements(versions)-1 DO BEGIN
         IF (versions(i) NE -1.0) THEN $
          print, i, versions(i) ELSE print, i, '*'
      ENDFOR 
   ENDIF 


   vers = long(versions*100+0.01)/100.0

   iplot = 0
   WHILE (plot_vers(iplot).identifier NE plot_identifier) AND $
    (iplot LT nplots-1) DO BEGIN
      iplot = iplot+1
   ENDWHILE 
   IF (plot_vers(iplot).identifier NE plot_identifier) THEN BEGIN
      print, 'HYDRA PLOT IDENTIFIER "'+plot_identifier+$
       '" NOT REGISTERED. ABORTING.'
      stop
   ENDIF 
   plot_number = iplot
   nv = plot_vers(iplot).nversions

   iversion = 0

   logical_v = 1
   FOR i=0,plot_vers(iplot).versions(iversion).nparts-1 DO BEGIN 
      logical_v = logical_v AND $
       ((plot_vers(iplot).versions(iversion).parts(i) EQ vers(i)) OR iver(i))
   ENDFOR
;   print, vers
;   print, plot_vers(iplot).versions(iversion).parts
   WHILE ((NOT logical_v) AND (iversion LT nv)) DO BEGIN
      iversion = iversion + 1

      logical_v = 1
      FOR i=0,plot_vers(iplot).versions(iversion).nparts-1 DO BEGIN 
         logical_v = logical_v AND $
          ((plot_vers(iplot).versions(iversion).parts(i) EQ vers(i)) $
           OR iver(i))
      ENDFOR
;      print, vers
;      print, plot_vers(iplot).versions(iversion).parts
      
   ENDWHILE 
   IF (logical_v) THEN BEGIN
      plot_version = plot_vers(iplot).versions(iversion).plotv
      IF (plot_version EQ plot_vers(iplot).versions(0).plotv) THEN BEGIN
         quality_flag = 1      
      ENDIF ELSE BEGIN
         quality_flag = 0
      ENDELSE 
   ENDIF ELSE BEGIN
      plot_version = 0.00
      quality_flag = 0
   ENDELSE 
   label_string = ["FILEV", "LIBV", "CODEV"]

   np = n_elements(vers)
   diff = fltarr(np)
   deficiency = ""
   FOR i=0, np-1 DO BEGIN 
      diff(i) = plot_vers(iplot).versions(0).parts(i) - vers(i)
;      print, plot_vers(iplot).versions(iversion).parts(i), vers(i)
      deficiency = deficiency + $
       deficiency_string_web((diff(i) NE 0) AND (NOT iver(i)), $
                             plot_vers(iplot).versions(0).parts(i), $
                             vers(i), $
                             Label_string(i))
   ENDFOR 
 
   return
END
