;
;	This is an example file for use with plot routines
;
;
;
;SET_PS, FILE = 'odl.ps', ORIENTATION = 'LAND', SCALE = 1.0, $
;         XOFFSET = 1.0, XSIZE = 9.0, YOFFSET = 1.0, YSIZE = 6.5, $
;         /INCHES, /RATIONAL
SET_PS, /landscape

x = findgen(100)/20.0
y = 100000.0*exp(-x^2/2.0)
xl = 0.01
xh = 7.0
xt1 = 0
xt2 = 5
yl = 1.0e-1
yh = 1.0e+5
yt1 = 0
yt2 = 5
xtitle = 'x-title'
ytitle = 'y-title'
title = 'title'
ticklen = 1.0
CHARSIZE = 1.5

set_page, NHORIZ = 2, NVERT = 2, wait = 0
xtype = 0
ytype = 0
aspect = 1.0
line_plot, x, y, xrange = [xl,xh], xticks = xt1, xminor = xt2, $
           xtitle = xtitle, xtype = xtype, $
	   yrange = [yl,yh], yticks = yt1, yminor = yt2, $
           ytitle = ytitle, ytype = ytype, $
           ticklen = ticklen, title = title, charsize = charsize, $
           ASPECT_RATIO = aspect, xsp = 0.2, ysp = 0.2, $
           ROUTINE_TITLE = 'plotter'
xtype = 0
ytype = 1
aspect = 1.0
line_plot, x, y, xrange = [xl,xh], xticks = xt1, xminor = xt2, $
           xtitle = xtitle, xtype = xtype, $
	   yrange = [yl,yh], yticks = yt1, yminor = yt2, $
           ytitle = ytitle, ytype = ytype, $
           ticklen = ticklen, title = title, charsize = charsize, $
           ASPECT_RATIO = aspect, xsp = 0.3, ysp = 0.3, $
           ROUTINE_TITLE = 'plotter'
xyouts, 0.5, 0.5, '2nd plot'


blank_plot
xyouts, 0.5, 0.5, '3rd plot'


aspect = 1.0
line_plot, x, y, ASPECT_RATIO = aspect, $
           ROUTINE_TITLE = 'Minimal arguments'

end_of_page, /print

;set_page, NVERT = 2, WAIT = 0

xtype = 0
ytype = 0
aspect = 1.0
line_plot, x, y, xrange = [xl,xh], xticks = xt1, xminor = xt2, $
           xtitle = xtitle, xtype = xtype, $
	   yrange = [yl,yh], yticks = yt1, yminor = yt2, $
           ytitle = ytitle, ytype = ytype, $
           ticklen = ticklen, title = title, charsize = charsize, $
           ASPECT_RATIO = aspect, xsp = 0.2, ysp = 0.3, $
           ROUTINE_TITLE = 'plotter'

xtype = 1
ytype = 1
aspect = 2.0
line_plot, x, y, xrange = [xl,xh], xticks = xt1, xminor = xt2, $
           xtitle = xtitle, xtype = xtype, $
	   yrange = [yl,yh], yticks = yt1, yminor = yt2, $
           ytitle = ytitle, ytype = ytype, $
           ticklen = ticklen, title = title, charsize = charsize, $
           ASPECT_RATIO = aspect, ROUTINE_TITLE = 'plotter'


end_of_page, /print

stop
;  Contour Plots
x = findgen(100)/20.0
y = findgen(100)/20.0
f = fltarr(100,100)
for j = 0,99 do begin
   f(*,j) = exp(-(x^2+y(j)^2)/2.0)
endfor
xl = 0.01
xh = 2.0
xt1 = 0
xt2 = 5
yl = 0.01
yh = 2.0
yt1 = 0
yt2 = 5
ticklen = 1.0

set_page, nh=2, nv = 8, wait = 0

xtype = 0
ytype = 0
aspect = 5.0
;print, !p.position
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.3, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.0
;print, !p.position
;contour_plot, 10*f, x, y, /overplot, $
;              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9]

;!P.POSITION = [0.25, 0.125, 0.75, 0.375]

aspect = 1.0
;line_plot, x, y, ASPECT_RATIO = aspect
;print, !p.position
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.2, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.5
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.2, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.5
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.2, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.5
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.2, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.5
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.2, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.5
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.2, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.5
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.2, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.5
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.2, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.5
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.2, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.5
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.2, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.5
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.2, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.5
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.2, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.5
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.2, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.5
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.2, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.5
contour_plot, f, x, y, ASPECT_RATIO = aspect, $
              xsp = 0.1, ysp = 0.2, xrange = [0,3], yrange= [0,3], $
              levels = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9], $
              ticklen = 1.0, routine_title = 'Contour Plot', $
              xtitle = 'x', ytitle = 'y', title = 'Gaussian', $
              charsize = 1.5
;print, !p.position


!P.POSITION = [0,0,0,0]

end_of_prog, /print
;end_of_prog

end
