FUNCTION poisson, x, mu
;+
; NAME:
;      POISSON
;
; PURPOSE:
;      Return the values of a Poisson probability distribution of mean
;      "mu" at positions x where x <= 170.
;
; CATEGORY:
;      Distribution.
;
; CALLING SEQUENCE:
;      p = POISSON(x, mu)
; 
; INPUTS:
;      x:  Array of Points for P(x).
;      mu: Mean value of Distribution.
;
; OPTIONAL INPUTS:
;      None.
;	
; KEYWORD PARAMETERS:
;      None.
;
; OUTPUTS:
;      P([x],mu)
;
; OPTIONAL OUTPUTS:
;      None.
;
; COMMON BLOCKS:
;      None.
;
; SIDE EFFECTS:
;      None.
;
; RESTRICTIONS:
;      None.
;
; PROCEDURE:
;      P(x,mu) = mu^x Exp(-mu) / Factorial(x)
;
; EXAMPLE:
;      x = findgen(50)
;      p = POISSON(x,10)
;      plot, x, p
;
; MODIFICATION HISTORY:
;      $Log: poisson.pro,v $
;      Revision 1.2  1999/03/26 23:09:46  rdh
;      Added caviot for x>170, double for result.
;
;      Revision 1.1  1998/11/17 21:20:59  rdh
;      Initial revision
;
;-
;
xx = [abs(long(x))]
mmu = double(mu)

s = size(x)
ns = n_elements(s)
IF s(ns-2) GE 4 AND min(x) LT 0 THEN $
 print, 'Truncating x to non-negative integer.'
IF mu LT 0 THEN BEGIN 
   print, 'Mean must be non-negative.'
   xx(*) = -1
   return, xx
ENDIF 
nx = n_elements(xx)
poi = dblarr(nx)
FOR i=0, nx-1 DO BEGIN 
   poi(i) = mmu^xx(i)*exp(-mmu)/factorial(xx(i))
ENDFOR 

return, poi
END
