function poisson_max, mean, interpolate=interp, ln=ln
;+
;
;  Return Max value of Poisson Distribution
;
;
;-
common poisson_max_comm, poi_n, poi_ns, poi_max, lnpoi_max
ln=keyword_set(ln)
poi_n=100
if keyword_set(interp) then begin
    if not keyword_set(poi_max) then begin
        poi_ns=findgen(poi_n)
        poi_max=poisson_max(poi_ns, interp=0)
        lnpoi_max=poisson_max(poi_ns, interp=0, /ln)
    endif
endif


n=n_elements(mean)
maxs=fltarr(n)
if keyword_set(interp) then begin
    r=where(mean le poi_n-1 and mean ge 1,nr)
    if not keyword_set(ln) then begin
        if nr gt 0 then $
          maxs[r]=interpol(poi_max, poi_ns, mean[r])
        r=where(mean gt poi_n-1 or mean lt 1,nr)
        if nr gt 0 then $
          maxs[r]=poisson_max(mean[r], interp=0)
    endif else begin
        if nr gt 0 then $
          maxs[r]=interpol(lnpoi_max, poi_ns, mean[r])
        r=where(mean gt poi_n-1 or mean lt 1,nr)
        if nr gt 0 then $
          maxs[r]=poisson_max(mean[r], interp=0, /ln)
    endelse
endif else begin
    for i=0L,n-1 do begin
;        maxs[i]=max(hyd_poisson(findgen(1.2*mean[i]+5),mean[i],ln=ln),ip)
        maxs[i]=hyd_poisson(long(mean[i]),mean[i], ln=ln)
    endfor
endelse
if n eq 1 then maxs=maxs[0]
return, maxs
end



