FUNCTION deficiency_string_web, cond, standard, testv, label
   IF (cond) THEN BEGIN 
      dstring = label+': '+strtrim(string(testv,format='(f6.2)'),2)+' -> '+ $
       strtrim(string(standard,format='(f6.2)'),2)+' '
   ENDIF ELSE BEGIN
      dstring = ""
   ENDELSE 

   return, dstring
END
 

PRO product_version_web, product_version, product_number, $
                         product_identifier, versions, $
                         quality_flag, verbose=verbose, $
                         deficiency=deficiency, $
                         version_strings=version_strings, $
                         use_web_file=use_web_file, echo=echo
;
;   Read product version summary file.
;
;   INPUT:  product_identifier = string indicating type of product
;   INPUT:  versions = float array of versions to test
;
;   OUTPUT: product_version = absolute Plot Version
;   OUTPUT: product_number = absolute HYDRA Plot Number
;   OUTPUT: quality_flag = .true. if it is up-to-date
;   
;   OUTPUT: deficiency returns a string stating what needs to be updated
;
   COMMON product_version_web_comm, define, product_vers, $
    nversions, nproducts, nparts


   IF NOT keyword_set(define) THEN BEGIN 

      IF keyword_set(verbose) THEN print, 'Reading product_version Record.'

      filename = 'prod_version_summary_v00.dat'

      command = 'wget http://supras.physics.uiowa.edu/hydra_data/versions/'+$
       filename

      IF keyword_set(use_web_file) THEN BEGIN 
         
         spawn, 'cd /tmp;mkdir -p hydra'
         spawn, command+' -O /tmp/hydra/'+filename
         file = '/tmp/hydra/'+filename
         get_lun, unit
         openr, unit, file
         
      ENDIF ELSE BEGIN 
         spawn, command+' -O - -o log', unit=unit
      ENDELSE 

      nversions = 100
      nproducts = 100
      nparts = 6

      product_vers1 = {product_v1, $
                       productv: float(0.0), $
                       nparts: 0L, $
                       parts: fltarr(nparts) }

      product_vers2 = {product_v2, $
                       nversions: 0L, $
                       identifier: string(""), $
                       versions: replicate(product_vers1, nversions)}

      product_vers = replicate(product_vers2, nproducts)

      line = string("")

      iproduct = -1

      readf, unit, line
      IF keyword_set(echo) THEN print, line
      WHILE (strmid(line, 0, 3) NE 'END') DO BEGIN
         CASE strmid(line,0,4) OF
            'DDEI': BEGIN
               ident = (str_sep(strcompress(line),' '))(1)
               iproduct = iproduct+1
               iversion = -1
               product_vers(iproduct).nversions = iversion
               product_vers(iproduct).identifier = ident
            END
            'VERS': BEGIN
               iversion = iversion+1
               product_vers(iproduct).nversions = iversion
               line1 = str_sep(strcompress(line),' ')
               nums = float(line1(1:n_elements(line1)-1))
               product_vers(iproduct).versions(iversion).productv = nums(0)
               product_vers(iproduct).versions(iversion).nparts = n_elements(nums)-1
               product_vers(iproduct).versions(iversion).parts = $
                nums(1:n_elements(nums)-1)
            END
            ELSE: BEGIN
            END
         ENDCASE 
         readf, unit, line
         IF keyword_set(echo) THEN print, line
      ENDWHILE 
      close, unit
      free_lun, unit

      IF keyword_set(use_web_file) THEN BEGIN 
         spawn, 'rm '+file
      ENDIF 
      define = 1
   ENDIF ELSE BEGIN
      IF keyword_set(verbose) THEN print, 'Not Reading product_version Record.'
   ENDELSE


   nv = n_elements(versions)
   iver = lonarr(nv)
   FOR i=0,nv-1 DO BEGIN
      IF (versions(i) NE -1.0) THEN iver(i) = 0 ELSE iver(i) = 1
   ENDFOR 
   


   IF keyword_set(verbose) THEN BEGIN 
      print, 'INPUT Version Parameters: '
      FOR i=0,n_elements(versions)-1 DO BEGIN
         IF (versions(i) NE -1.0) THEN $
          print, i, versions(i) ELSE print, i, '*'
      ENDFOR 
   ENDIF 


   vers = long(versions*100+0.01)/100.0

   iproduct = 0
   WHILE (product_vers(iproduct).identifier NE product_identifier) AND $
    (iproduct LT nproducts-1) DO BEGIN
      iproduct = iproduct+1
   ENDWHILE 
   IF (product_vers(iproduct).identifier NE product_identifier) THEN BEGIN
      print, 'HYDRA PLOT IDENTIFIER "'+product_identifier+$
       '" NOT REGISTERED. ABORTING.'
      stop
   ENDIF 
   product_number = iproduct
   nv = product_vers(iproduct).nversions

   iversion = 0

   logical_v = 1
   FOR i=0,product_vers(iproduct).versions(iversion).nparts-1 DO BEGIN 
      logical_v = logical_v AND $
       ((product_vers(iproduct).versions(iversion).parts(i) EQ vers(i)) OR iver(i))
   ENDFOR
;   print, vers
;   print, product_vers(iproduct).versions(iversion).parts
   WHILE ((NOT logical_v) AND (iversion LT nv)) DO BEGIN
      iversion = iversion + 1

      logical_v = 1
      FOR i=0,product_vers(iproduct).versions(iversion).nparts-1 DO BEGIN 
         logical_v = logical_v AND $
          ((product_vers(iproduct).versions(iversion).parts(i) EQ vers(i)) $
           OR iver(i))
      ENDFOR
;      print, vers
;      print, product_vers(iproduct).versions(iversion).parts
      
   ENDWHILE 
   IF (logical_v) THEN BEGIN
      product_version = product_vers(iproduct).versions(iversion).productv
      IF (product_version EQ product_vers(iproduct).versions(0).productv) THEN BEGIN
         quality_flag = 1      
      ENDIF ELSE BEGIN
         quality_flag = 0
      ENDELSE 
   ENDIF ELSE BEGIN
      product_version = 0.00
      quality_flag = 0
   ENDELSE 
   label_string = ["FILEV", "LIBV", "CODEV"]

   np = n_elements(vers)
   diff = fltarr(np)
   deficiency = ""
   FOR i=0, np-1 DO BEGIN 
      diff(i) = (product_vers(iproduct).versions(0).parts(i) - vers(i))
;      print, product_vers(iproduct).versions(iversion).parts(i), vers(i)
      deficiency = deficiency + $
       deficiency_string_web((diff(i) NE 0) AND (NOT iver(i)), $
                             product_vers(iproduct).versions(0).parts(i), $
                             vers(i), $
                             Label_string(i))
   ENDFOR 
   
   return
END
