function read_glintmask, date, electron=electron, ion=ion, level=level, $
                         liberal=liberal, $
                         middle=middle, $
                         conservative=conservative
;+
;
;    Read the glint mask for a particular day
;
;    Arguments:   date: YYYYMMDD
;    Keywords:    /electron or /ion, default is /electron
;                 level=1,2,3 for increasing masking criteria
;
;-
if not keyword_set(date) then message, 'Date argument required.'

if keyword_set(electron) then begin
    species='ELE'
endif else begin
    if keyword_set(ion) then begin
        species='ION'
    endif else begin
        species='ELE'
    endelse
endelse

if keyword_set(level) then begin
    irec=level-1
endif else begin
    if keyword_set(conservative) then irec=2 $
    else if keyword_set(middle) then irec=1 $
    else if keyword_set(liberal) then irec=0 $
    else irec=2
endelse

ddcal_file=hydra_findfile(date, /ddcal)
if ddcal_file eq '' then begin
    message, 'ddcal file not found.',/cont
    return, -1
endif





end
