PRO read_interbox_gains, date=date, version=version, block_mode=block_mode, $
                         data=data, $
                         verbose=verbose, stop=stop, echo=echo

   IF keyword_set(date) THEN BEGIN 
      date = strtrim(date,2) 
   ENDIF ELSE BEGIN
      date = '19960604'
      IF keyword_set(echo) THEN $
       print, 'Date keyword not set, defaulting to '+date
   ENDELSE 

   IF keyword_set(block_mode) THEN BEGIN 
      block_mode = strtrim(string(block_mode,format='(i2.2)'),2) 
   ENDIF ELSE BEGIN
      block_mode = '10'
   ENDELSE 

   IF keyword_set(version) THEN BEGIN 
      vstring = strtrim(string(long(version),format='(i2.2)'),2) 
   ENDIF ELSE BEGIN
      vstring = '05'
      IF keyword_set(echo) THEN print, 'Version defaulting to '+vstring
   ENDELSE 

   data = { time_interval:strarr(2), $
            index:lonarr(64), $
            energy:fltarr(64), $
            ibg:fltarr(64,2), $
            ibg_sigma:fltarr(64,2), $
            rchisq:fltarr(64), $
            ndata:0L $
          }


   dir = '/opt/hydra/gain_data/block_mode_'+block_mode+'/'
   file = 'po_ib_???_'+date+'_v'+vstring+'_'+block_mode+'.dat'

   f = findfile(dir+file, count=nf)

   filename = f(nf-1)
   IF keyword_set(verbose) THEN BEGIN
      print, 'Reading file '+filename
   ENDIF 

   line = string("")
   day1 = strarr(100)
   iday = 0
   openr, 1, filename
   readf, 1, line
   IF keyword_set(echo) THEN print, line
   WHILE (strmid(line,0,1) NE '-') DO BEGIN
      day = str_sep(line,' ')
      FOR id=0, n_elements(day)-1 DO BEGIN
         IF (strmid(day(id),0,1) EQ '1') THEN BEGIN
            day1(iday) = day(id)
            iday = iday+1
         ENDIF 
      ENDFOR 
      readf, 1, line
      IF keyword_set(echo) THEN print, line
   ENDWHILE 

   data.time_interval = [day1(0),day1(iday-1)]

   i = 0L
   en = float(0.0)
   ibg1 = float(0.0)
   ibg_sig1 = float(0.0)
   ibg2 = float(0.0)
   ibg_sig2 = float(0.0)
   rch = float(0.0)

   readf, 1, line
   IF keyword_set(echo) THEN print, line
   WHILE (strmid(line,0,1) NE '-') DO BEGIN
      readf, 1, line
      IF keyword_set(echo) THEN print, line
   ENDWHILE 
   WHILE NOT eof(1) DO BEGIN 
      readf, 1, i, en, ibg1, ibg_sig1, ibg2, ibg_sig2, rch
      IF keyword_set(echo) THEN $
       print, i, en, ibg1, ibg_sig1, ibg2, ibg_sig2, rch
      data.index(i-1) = i
      data.energy(i-1) = en
      data.ibg(i-1,0) = ibg1
      data.ibg_sigma(i-1,0) = ibg_sig1
      data.ibg(i-1,1) = ibg2
      data.ibg_sigma(i-1,1) = ibg_sig2
      data.rchisq(i-1) = rch
      data.ndata = i
   ENDWHILE 

   close, 1

   IF keyword_set(stop) THEN stop
   return
END
