pro read_rg_quick, rel_version, date=date, mode=mode, rel_out, dir=dir, $
                   status=status
;
;   Read the interbox file and return the array
;
status=1
on_ioerror, ERROR

if rel_version ne 'best' then begin
    vw1=string(long(rel_version),format='(i2.2)')
    vf1=strmid(string(rel_version-long(rel_version),format='(f6.3)'),3,3)
endif else begin
    vw1='??'
    vf1='???'
endelse 

if not keyword_set(date) then date=19960604
date=strtrim(date,2)
if not keyword_set(mode) then mode=10
mode=strtrim(mode,2)

if not keyword_set(dir) then $
  dir='/opt/hydra/gain_data/block_mode_'+mode+'/'
 
file='po_rg_'+vf1+'_'+date+'_v'+vw1+'_'+mode+'.dat'
if rel_version eq 'best' then begin
    f=findfile(dir+file,count=nf)
    v_max=long(strmid(basename(f(0)),21,2))
    w_max=long(strmid(basename(f(0)),7,3))
    file=basename(f(0))
    for i=1,nf-1 do begin
        v=long(strmid(basename(f(i)),20,2))
        w=long(strmid(basename(f(i)),6,3))
        if ((v gt v_max) or ((v eq v_max) and (w gt w_max))) then begin
            v_max=v
            w_max=w
            file=basename(f(i))
        endif
    endfor
endif
rg_version_out=float(strmid(file,20,2)+'.'+strmid(file,6,3))
print, 'RG_VERSION_READING: ', rg_version_out

print, dir+file

openr, 1, dir+file

line=''
readf, 1, line
while strmid(line,0,4) ne '----' do readf, 1, line
readf, 1, line
while strmid(line,0,4) ne '----' do readf, 1, line
readf, 1, line
readf, 1, line

case mode of
    '10': nst=55
    '40': nst=29
    '41': nst=29
    default: message, 'Not coded for mode '+mode+'.'
endcase
rel_out=fltarr(9,nst*10)

readf, 1, rel_out
close, 1

ERROR: if status ne 1 then status=0

end
