pro read_smear, file, date, time_range, xg, yg, $
                value, variance, weight, fill, smear_version, $
                dir=dir, reload=reload, avg_method=avg_method, $
                list=list
;
;  Read Plot_Reconnection Smear File and Return matrix values
;
;
;  Input:
;     file                  - idlsav file label to read
;     dir=dir               - Override default directory
;     avg_method=avg_method - 'A', 'B', 'C', 'D'
;
;     /list                 - Prints a list of Available files.
;
;
;
;  Output:
;     Date       - Date of Data
;     time_range - [Start,End times]
;     xg, yg     - Grid Position Values in x,y directions
;     value, variance, weight    
;                - Values at grid: z=Avg, v=Variance, w=Weight in Seconds
;     fill       - Fill Value for No-Data Points in z, v (Also w=0)
;     smear_version - Version of Smear Algorithm
;  
common read_smear_common, dir_save, file_save, date_save, time_range_save, $
  xg_save, yg_save, value_save, variance_save, weight_save, fill_save, $
  smear_version_save, avg_method_save, save

if not keyword_set(avg_method) then $
  avg_method='A'
if not keyword_set(dir) then $
  dir='/home/ddm/bigdisk2/plot_devel/release/savsmr/'

if keyword_set(list) then print, findfile(dir+'*'+avg_method+'.sav')

if not keyword_set(dir_save) then dir_save=' '
if not keyword_set(file_save) then file_save=' '
if not keyword_set(avg_method_save) then avg_method_save=' '

if (keyword_set(save) and (file eq file_save) and (dir eq dir_save) $
    and (avg_method eq avg_method_save)) $
  and (not keyword_set(reload)) then begin

    date = date_save 
    time_range = time_range_save
    xg = xg_save
    yg = yg_save
    value = value_save
    variance = variance_save
    weight = weight_save
    fill = fill_save
    smear_version = smear_version_save
    avg_method = avg_method_save

    return
endif
save=1
fill=-1e31


restore, dir+file+'_'+avg_method+'.sav', /verbose

date=smear_coords.date
time_range=smear_coords.time_range
smear_version=smear_coords.smear_version

xr=smear_coords.xrange
yr=smear_coords.zrange

nx=smear_coords.nx
ny=smear_coords.ny

x=smear_coords.coords(*,0)
y=smear_coords.coords(*,1)
z=smear_coords.coords(*,2)
v=smear_coords.coords(*,3)
w=smear_coords.coords(*,4)

value=fltarr(nx,ny)
variance=fltarr(nx,ny)
weight=fltarr(nx,ny)

dx=(xr(1)-xr(0))/float(nx+1)
dy=(yr(1)-yr(0))/float(ny+1)

xg=findgen(nx)*dx+xr(0)
yg=findgen(ny)*dy+yr(0)

ix=(x-xr(0))/dx
iy=(y-yr(0))/dy

value(ix,iy)=z
variance(ix,iy)=v^2
weight(ix,iy)=w

r=where(weight eq 0.0)
if r(0) ne -1 then begin
    value(r)=fill
    variance(r)=fill
endif

date_save = date 
time_range_save = time_range
xg_save = xg
yg_save = yg
value_save = value
variance_save = variance
weight_save = weight
fill_save = fill
smear_version_save = smear_version
file_save = file
dir_save = dir
avg_method_save = avg_method

return
end

